# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .remote_data import RemoteData
from .remote_field import RemoteField
from .task_account import TaskAccount
from .task_opportunity import TaskOpportunity
from .task_owner import TaskOwner
from .task_status import TaskStatus


class Task(UncheckedBaseModel):
    """
    # The Task Object
    ### Description
    The `Task` object is used to represent a task, such as a to-do item.
    ### Usage Example
    TODO
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    subject: typing.Optional[str] = pydantic.Field(default=None)
    """
    The task's subject.
    """

    content: typing.Optional[str] = pydantic.Field(default=None)
    """
    The task's content.
    """

    owner: typing.Optional[TaskOwner] = pydantic.Field(default=None)
    """
    The task's owner.
    """

    account: typing.Optional[TaskAccount] = pydantic.Field(default=None)
    """
    The task's account.
    """

    opportunity: typing.Optional[TaskOpportunity] = pydantic.Field(default=None)
    """
    The task's opportunity.
    """

    completed_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the task is completed.
    """

    due_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the task is due.
    """

    status: typing.Optional[TaskStatus] = pydantic.Field(default=None)
    """
    The task's status.
    
    * `OPEN` - OPEN
    * `CLOSED` - CLOSED
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None
    remote_fields: typing.Optional[typing.List[RemoteField]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
