# This file was auto-generated by Fern from our API Definition.

import contextlib
import datetime as dt
import typing
from json.decoder import JSONDecodeError

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.datetime_utils import serialize_datetime
from .....core.http_response import AsyncHttpResponse, HttpResponse
from .....core.jsonable_encoder import jsonable_encoder
from .....core.request_options import RequestOptions
from .....core.unchecked_base_model import construct_type
from ...types.download_request_meta import DownloadRequestMeta
from ...types.file import File
from ...types.file_request import FileRequest
from ...types.file_storage_file_response import FileStorageFileResponse
from ...types.meta_response import MetaResponse
from ...types.paginated_download_request_meta_list import PaginatedDownloadRequestMetaList
from ...types.paginated_file_list import PaginatedFileList
from .types.files_download_request_meta_list_request_order_by import FilesDownloadRequestMetaListRequestOrderBy
from .types.files_list_request_expand import FilesListRequestExpand
from .types.files_list_request_order_by import FilesListRequestOrderBy
from .types.files_retrieve_request_expand import FilesRetrieveRequestExpand

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawFilesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        drive_id: typing.Optional[str] = None,
        expand: typing.Optional[FilesListRequestExpand] = None,
        folder_id: typing.Optional[str] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        mime_type: typing.Optional[str] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        name: typing.Optional[str] = None,
        order_by: typing.Optional[FilesListRequestOrderBy] = None,
        page_size: typing.Optional[int] = None,
        remote_created_after: typing.Optional[dt.datetime] = None,
        remote_created_before: typing.Optional[dt.datetime] = None,
        remote_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PaginatedFileList]:
        """
        Returns a list of `File` objects.

        Parameters
        ----------
        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        drive_id : typing.Optional[str]
            Specifying a drive id returns only the files in that drive. Specifying null returns only the files outside the top-level drive.

        expand : typing.Optional[FilesListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        folder_id : typing.Optional[str]
            Specifying a folder id returns only the files in that folder. Specifying null returns only the files in root directory.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        mime_type : typing.Optional[str]
            If provided, will only return files with these mime_types. Multiple values can be separated by commas.

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        name : typing.Optional[str]
            If provided, will only return files with this name. This performs an exact match.

        order_by : typing.Optional[FilesListRequestOrderBy]
            Overrides the default ordering for this endpoint. Possible values include: created_at, -created_at, modified_at, -modified_at.

        page_size : typing.Optional[int]
            Number of results to return per page.

        remote_created_after : typing.Optional[dt.datetime]
            If provided, will only return files created in the third party platform after this datetime.

        remote_created_before : typing.Optional[dt.datetime]
            If provided, will only return files created in the third party platform before this datetime.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaginatedFileList]

        """
        _response = self._client_wrapper.httpx_client.request(
            "filestorage/v1/files",
            method="GET",
            params={
                "created_after": serialize_datetime(created_after) if created_after is not None else None,
                "created_before": serialize_datetime(created_before) if created_before is not None else None,
                "cursor": cursor,
                "drive_id": drive_id,
                "expand": expand,
                "folder_id": folder_id,
                "include_deleted_data": include_deleted_data,
                "include_remote_data": include_remote_data,
                "include_shell_data": include_shell_data,
                "mime_type": mime_type,
                "modified_after": serialize_datetime(modified_after) if modified_after is not None else None,
                "modified_before": serialize_datetime(modified_before) if modified_before is not None else None,
                "name": name,
                "order_by": order_by,
                "page_size": page_size,
                "remote_created_after": serialize_datetime(remote_created_after)
                if remote_created_after is not None
                else None,
                "remote_created_before": serialize_datetime(remote_created_before)
                if remote_created_before is not None
                else None,
                "remote_id": remote_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedFileList,
                    construct_type(
                        type_=PaginatedFileList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        model: FileRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[FileStorageFileResponse]:
        """
        Creates a `File` object with the given values.

        Parameters
        ----------
        model : FileRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[FileStorageFileResponse]

        """
        _response = self._client_wrapper.httpx_client.request(
            "filestorage/v1/files",
            method="POST",
            params={
                "is_debug_mode": is_debug_mode,
                "run_async": run_async,
            },
            json={
                "model": model,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    FileStorageFileResponse,
                    construct_type(
                        type_=FileStorageFileResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[FilesRetrieveRequestExpand] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[File]:
        """
        Returns a `File` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[FilesRetrieveRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[File]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"filestorage/v1/files/{jsonable_encoder(id)}",
            method="GET",
            params={
                "expand": expand,
                "include_remote_data": include_remote_data,
                "include_shell_data": include_shell_data,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    File,
                    construct_type(
                        type_=File,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.contextmanager
    def download_retrieve(
        self,
        id: str,
        *,
        include_shell_data: typing.Optional[bool] = None,
        mime_type: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[HttpResponse[typing.Iterator[bytes]]]:
        """
        Returns the `File` content with the given `id` as a stream of bytes.

        Parameters
        ----------
        id : str

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        mime_type : typing.Optional[str]
            If provided, specifies the export format of the file to be downloaded. For information on supported export formats, please refer to our <a href='https://help.merge.dev/en/articles/8615316-file-export-and-download-specification' target='_blank'>export format help center article</a>.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[HttpResponse[typing.Iterator[bytes]]]

        """
        with self._client_wrapper.httpx_client.stream(
            f"filestorage/v1/files/{jsonable_encoder(id)}/download",
            method="GET",
            params={
                "include_shell_data": include_shell_data,
                "mime_type": mime_type,
            },
            request_options=request_options,
        ) as _response:

            def _stream() -> HttpResponse[typing.Iterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return HttpResponse(
                            response=_response, data=(_chunk for _chunk in _response.iter_bytes(chunk_size=_chunk_size))
                        )
                    _response.read()
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield _stream()

    def download_request_meta_retrieve(
        self,
        id: str,
        *,
        mime_type: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DownloadRequestMeta]:
        """
        Returns metadata to construct an authenticated file download request for a singular file, allowing you to download file directly from the third-party.

        Parameters
        ----------
        id : str

        mime_type : typing.Optional[str]
            If provided, specifies the export format of the file to be downloaded. For information on supported export formats, please refer to our <a href='https://help.merge.dev/en/articles/8615316-file-export-and-download-specification' target='_blank'>export format help center article</a>.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DownloadRequestMeta]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"filestorage/v1/files/{jsonable_encoder(id)}/download/request-meta",
            method="GET",
            params={
                "mime_type": mime_type,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DownloadRequestMeta,
                    construct_type(
                        type_=DownloadRequestMeta,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def download_request_meta_list(
        self,
        *,
        created_after: typing.Optional[str] = None,
        created_before: typing.Optional[str] = None,
        cursor: typing.Optional[str] = None,
        ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        include_deleted_data: typing.Optional[bool] = None,
        mime_types: typing.Optional[str] = None,
        modified_after: typing.Optional[str] = None,
        modified_before: typing.Optional[str] = None,
        order_by: typing.Optional[FilesDownloadRequestMetaListRequestOrderBy] = None,
        page_size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PaginatedDownloadRequestMetaList]:
        """
        Returns metadata to construct authenticated file download requests, allowing you to download files directly from the third-party.

        Parameters
        ----------
        created_after : typing.Optional[str]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[str]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            If provided, will only return objects with the given IDs. Comma-separated list of strings.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        mime_types : typing.Optional[str]
            A comma-separated list of preferred MIME types in order of priority. If supported by the third-party provider, the file(s) will be returned in the first supported MIME type from the list. The default MIME type is PDF. To see supported MIME types by file type, refer to our <a href='https://help.merge.dev/en/articles/8615316-file-export-and-download-specification' target='_blank'>export format help center article</a>.

        modified_after : typing.Optional[str]
            If provided, will only return objects modified after this datetime.

        modified_before : typing.Optional[str]
            If provided, will only return objects modified before this datetime.

        order_by : typing.Optional[FilesDownloadRequestMetaListRequestOrderBy]
            Overrides the default ordering for this endpoint. Possible values include: created_at, -created_at, modified_at, -modified_at.

        page_size : typing.Optional[int]
            Number of results to return per page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaginatedDownloadRequestMetaList]

        """
        _response = self._client_wrapper.httpx_client.request(
            "filestorage/v1/files/download/request-meta",
            method="GET",
            params={
                "created_after": created_after,
                "created_before": created_before,
                "cursor": cursor,
                "ids": ids,
                "include_deleted_data": include_deleted_data,
                "mime_types": mime_types,
                "modified_after": modified_after,
                "modified_before": modified_before,
                "order_by": order_by,
                "page_size": page_size,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedDownloadRequestMetaList,
                    construct_type(
                        type_=PaginatedDownloadRequestMetaList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def meta_post_retrieve(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[MetaResponse]:
        """
        Returns metadata for `FileStorageFile` POSTs.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[MetaResponse]

        """
        _response = self._client_wrapper.httpx_client.request(
            "filestorage/v1/files/meta/post",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MetaResponse,
                    construct_type(
                        type_=MetaResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawFilesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        drive_id: typing.Optional[str] = None,
        expand: typing.Optional[FilesListRequestExpand] = None,
        folder_id: typing.Optional[str] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        mime_type: typing.Optional[str] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        name: typing.Optional[str] = None,
        order_by: typing.Optional[FilesListRequestOrderBy] = None,
        page_size: typing.Optional[int] = None,
        remote_created_after: typing.Optional[dt.datetime] = None,
        remote_created_before: typing.Optional[dt.datetime] = None,
        remote_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PaginatedFileList]:
        """
        Returns a list of `File` objects.

        Parameters
        ----------
        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        drive_id : typing.Optional[str]
            Specifying a drive id returns only the files in that drive. Specifying null returns only the files outside the top-level drive.

        expand : typing.Optional[FilesListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        folder_id : typing.Optional[str]
            Specifying a folder id returns only the files in that folder. Specifying null returns only the files in root directory.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        mime_type : typing.Optional[str]
            If provided, will only return files with these mime_types. Multiple values can be separated by commas.

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        name : typing.Optional[str]
            If provided, will only return files with this name. This performs an exact match.

        order_by : typing.Optional[FilesListRequestOrderBy]
            Overrides the default ordering for this endpoint. Possible values include: created_at, -created_at, modified_at, -modified_at.

        page_size : typing.Optional[int]
            Number of results to return per page.

        remote_created_after : typing.Optional[dt.datetime]
            If provided, will only return files created in the third party platform after this datetime.

        remote_created_before : typing.Optional[dt.datetime]
            If provided, will only return files created in the third party platform before this datetime.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaginatedFileList]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "filestorage/v1/files",
            method="GET",
            params={
                "created_after": serialize_datetime(created_after) if created_after is not None else None,
                "created_before": serialize_datetime(created_before) if created_before is not None else None,
                "cursor": cursor,
                "drive_id": drive_id,
                "expand": expand,
                "folder_id": folder_id,
                "include_deleted_data": include_deleted_data,
                "include_remote_data": include_remote_data,
                "include_shell_data": include_shell_data,
                "mime_type": mime_type,
                "modified_after": serialize_datetime(modified_after) if modified_after is not None else None,
                "modified_before": serialize_datetime(modified_before) if modified_before is not None else None,
                "name": name,
                "order_by": order_by,
                "page_size": page_size,
                "remote_created_after": serialize_datetime(remote_created_after)
                if remote_created_after is not None
                else None,
                "remote_created_before": serialize_datetime(remote_created_before)
                if remote_created_before is not None
                else None,
                "remote_id": remote_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedFileList,
                    construct_type(
                        type_=PaginatedFileList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        model: FileRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[FileStorageFileResponse]:
        """
        Creates a `File` object with the given values.

        Parameters
        ----------
        model : FileRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[FileStorageFileResponse]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "filestorage/v1/files",
            method="POST",
            params={
                "is_debug_mode": is_debug_mode,
                "run_async": run_async,
            },
            json={
                "model": model,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    FileStorageFileResponse,
                    construct_type(
                        type_=FileStorageFileResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[FilesRetrieveRequestExpand] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[File]:
        """
        Returns a `File` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[FilesRetrieveRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[File]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"filestorage/v1/files/{jsonable_encoder(id)}",
            method="GET",
            params={
                "expand": expand,
                "include_remote_data": include_remote_data,
                "include_shell_data": include_shell_data,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    File,
                    construct_type(
                        type_=File,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.asynccontextmanager
    async def download_retrieve(
        self,
        id: str,
        *,
        include_shell_data: typing.Optional[bool] = None,
        mime_type: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]:
        """
        Returns the `File` content with the given `id` as a stream of bytes.

        Parameters
        ----------
        id : str

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        mime_type : typing.Optional[str]
            If provided, specifies the export format of the file to be downloaded. For information on supported export formats, please refer to our <a href='https://help.merge.dev/en/articles/8615316-file-export-and-download-specification' target='_blank'>export format help center article</a>.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]

        """
        async with self._client_wrapper.httpx_client.stream(
            f"filestorage/v1/files/{jsonable_encoder(id)}/download",
            method="GET",
            params={
                "include_shell_data": include_shell_data,
                "mime_type": mime_type,
            },
            request_options=request_options,
        ) as _response:

            async def _stream() -> AsyncHttpResponse[typing.AsyncIterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return AsyncHttpResponse(
                            response=_response,
                            data=(_chunk async for _chunk in _response.aiter_bytes(chunk_size=_chunk_size)),
                        )
                    await _response.aread()
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield await _stream()

    async def download_request_meta_retrieve(
        self,
        id: str,
        *,
        mime_type: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DownloadRequestMeta]:
        """
        Returns metadata to construct an authenticated file download request for a singular file, allowing you to download file directly from the third-party.

        Parameters
        ----------
        id : str

        mime_type : typing.Optional[str]
            If provided, specifies the export format of the file to be downloaded. For information on supported export formats, please refer to our <a href='https://help.merge.dev/en/articles/8615316-file-export-and-download-specification' target='_blank'>export format help center article</a>.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DownloadRequestMeta]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"filestorage/v1/files/{jsonable_encoder(id)}/download/request-meta",
            method="GET",
            params={
                "mime_type": mime_type,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DownloadRequestMeta,
                    construct_type(
                        type_=DownloadRequestMeta,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def download_request_meta_list(
        self,
        *,
        created_after: typing.Optional[str] = None,
        created_before: typing.Optional[str] = None,
        cursor: typing.Optional[str] = None,
        ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        include_deleted_data: typing.Optional[bool] = None,
        mime_types: typing.Optional[str] = None,
        modified_after: typing.Optional[str] = None,
        modified_before: typing.Optional[str] = None,
        order_by: typing.Optional[FilesDownloadRequestMetaListRequestOrderBy] = None,
        page_size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PaginatedDownloadRequestMetaList]:
        """
        Returns metadata to construct authenticated file download requests, allowing you to download files directly from the third-party.

        Parameters
        ----------
        created_after : typing.Optional[str]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[str]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            If provided, will only return objects with the given IDs. Comma-separated list of strings.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        mime_types : typing.Optional[str]
            A comma-separated list of preferred MIME types in order of priority. If supported by the third-party provider, the file(s) will be returned in the first supported MIME type from the list. The default MIME type is PDF. To see supported MIME types by file type, refer to our <a href='https://help.merge.dev/en/articles/8615316-file-export-and-download-specification' target='_blank'>export format help center article</a>.

        modified_after : typing.Optional[str]
            If provided, will only return objects modified after this datetime.

        modified_before : typing.Optional[str]
            If provided, will only return objects modified before this datetime.

        order_by : typing.Optional[FilesDownloadRequestMetaListRequestOrderBy]
            Overrides the default ordering for this endpoint. Possible values include: created_at, -created_at, modified_at, -modified_at.

        page_size : typing.Optional[int]
            Number of results to return per page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaginatedDownloadRequestMetaList]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "filestorage/v1/files/download/request-meta",
            method="GET",
            params={
                "created_after": created_after,
                "created_before": created_before,
                "cursor": cursor,
                "ids": ids,
                "include_deleted_data": include_deleted_data,
                "mime_types": mime_types,
                "modified_after": modified_after,
                "modified_before": modified_before,
                "order_by": order_by,
                "page_size": page_size,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedDownloadRequestMetaList,
                    construct_type(
                        type_=PaginatedDownloadRequestMetaList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def meta_post_retrieve(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[MetaResponse]:
        """
        Returns metadata for `FileStorageFile` POSTs.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[MetaResponse]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "filestorage/v1/files/meta/post",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MetaResponse,
                    construct_type(
                        type_=MetaResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
