# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.datetime_utils import serialize_datetime
from .....core.http_response import AsyncHttpResponse, HttpResponse
from .....core.jsonable_encoder import jsonable_encoder
from .....core.request_options import RequestOptions
from .....core.unchecked_base_model import construct_type
from ...types.issue import Issue
from ...types.paginated_issue_list import PaginatedIssueList
from .types.issues_list_request_status import IssuesListRequestStatus


class RawIssuesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        account_token: typing.Optional[str] = None,
        cursor: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        end_user_organization_name: typing.Optional[str] = None,
        first_incident_time_after: typing.Optional[dt.datetime] = None,
        first_incident_time_before: typing.Optional[dt.datetime] = None,
        include_muted: typing.Optional[str] = None,
        integration_name: typing.Optional[str] = None,
        last_incident_time_after: typing.Optional[dt.datetime] = None,
        last_incident_time_before: typing.Optional[dt.datetime] = None,
        linked_account_id: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        start_date: typing.Optional[str] = None,
        status: typing.Optional[IssuesListRequestStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PaginatedIssueList]:
        """
        Gets all issues for Organization.

        Parameters
        ----------
        account_token : typing.Optional[str]

        cursor : typing.Optional[str]
            The pagination cursor value.

        end_date : typing.Optional[str]
            If included, will only include issues whose most recent action occurred before this time

        end_user_organization_name : typing.Optional[str]

        first_incident_time_after : typing.Optional[dt.datetime]
            If provided, will only return issues whose first incident time was after this datetime.

        first_incident_time_before : typing.Optional[dt.datetime]
            If provided, will only return issues whose first incident time was before this datetime.

        include_muted : typing.Optional[str]
            If true, will include muted issues

        integration_name : typing.Optional[str]

        last_incident_time_after : typing.Optional[dt.datetime]
            If provided, will only return issues whose last incident time was after this datetime.

        last_incident_time_before : typing.Optional[dt.datetime]
            If provided, will only return issues whose last incident time was before this datetime.

        linked_account_id : typing.Optional[str]
            If provided, will only include issues pertaining to the linked account passed in.

        page_size : typing.Optional[int]
            Number of results to return per page.

        start_date : typing.Optional[str]
            If included, will only include issues whose most recent action occurred after this time

        status : typing.Optional[IssuesListRequestStatus]
            Status of the issue. Options: ('ONGOING', 'RESOLVED')

            * `ONGOING` - ONGOING
            * `RESOLVED` - RESOLVED

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaginatedIssueList]

        """
        _response = self._client_wrapper.httpx_client.request(
            "filestorage/v1/issues",
            method="GET",
            params={
                "account_token": account_token,
                "cursor": cursor,
                "end_date": end_date,
                "end_user_organization_name": end_user_organization_name,
                "first_incident_time_after": serialize_datetime(first_incident_time_after)
                if first_incident_time_after is not None
                else None,
                "first_incident_time_before": serialize_datetime(first_incident_time_before)
                if first_incident_time_before is not None
                else None,
                "include_muted": include_muted,
                "integration_name": integration_name,
                "last_incident_time_after": serialize_datetime(last_incident_time_after)
                if last_incident_time_after is not None
                else None,
                "last_incident_time_before": serialize_datetime(last_incident_time_before)
                if last_incident_time_before is not None
                else None,
                "linked_account_id": linked_account_id,
                "page_size": page_size,
                "start_date": start_date,
                "status": status,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedIssueList,
                    construct_type(
                        type_=PaginatedIssueList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[Issue]:
        """
        Get a specific issue.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Issue]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"filestorage/v1/issues/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Issue,
                    construct_type(
                        type_=Issue,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawIssuesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        account_token: typing.Optional[str] = None,
        cursor: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        end_user_organization_name: typing.Optional[str] = None,
        first_incident_time_after: typing.Optional[dt.datetime] = None,
        first_incident_time_before: typing.Optional[dt.datetime] = None,
        include_muted: typing.Optional[str] = None,
        integration_name: typing.Optional[str] = None,
        last_incident_time_after: typing.Optional[dt.datetime] = None,
        last_incident_time_before: typing.Optional[dt.datetime] = None,
        linked_account_id: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        start_date: typing.Optional[str] = None,
        status: typing.Optional[IssuesListRequestStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PaginatedIssueList]:
        """
        Gets all issues for Organization.

        Parameters
        ----------
        account_token : typing.Optional[str]

        cursor : typing.Optional[str]
            The pagination cursor value.

        end_date : typing.Optional[str]
            If included, will only include issues whose most recent action occurred before this time

        end_user_organization_name : typing.Optional[str]

        first_incident_time_after : typing.Optional[dt.datetime]
            If provided, will only return issues whose first incident time was after this datetime.

        first_incident_time_before : typing.Optional[dt.datetime]
            If provided, will only return issues whose first incident time was before this datetime.

        include_muted : typing.Optional[str]
            If true, will include muted issues

        integration_name : typing.Optional[str]

        last_incident_time_after : typing.Optional[dt.datetime]
            If provided, will only return issues whose last incident time was after this datetime.

        last_incident_time_before : typing.Optional[dt.datetime]
            If provided, will only return issues whose last incident time was before this datetime.

        linked_account_id : typing.Optional[str]
            If provided, will only include issues pertaining to the linked account passed in.

        page_size : typing.Optional[int]
            Number of results to return per page.

        start_date : typing.Optional[str]
            If included, will only include issues whose most recent action occurred after this time

        status : typing.Optional[IssuesListRequestStatus]
            Status of the issue. Options: ('ONGOING', 'RESOLVED')

            * `ONGOING` - ONGOING
            * `RESOLVED` - RESOLVED

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaginatedIssueList]

        """
        _response = await self._client_wrapper.httpx_client.request(
            "filestorage/v1/issues",
            method="GET",
            params={
                "account_token": account_token,
                "cursor": cursor,
                "end_date": end_date,
                "end_user_organization_name": end_user_organization_name,
                "first_incident_time_after": serialize_datetime(first_incident_time_after)
                if first_incident_time_after is not None
                else None,
                "first_incident_time_before": serialize_datetime(first_incident_time_before)
                if first_incident_time_before is not None
                else None,
                "include_muted": include_muted,
                "integration_name": integration_name,
                "last_incident_time_after": serialize_datetime(last_incident_time_after)
                if last_incident_time_after is not None
                else None,
                "last_incident_time_before": serialize_datetime(last_incident_time_before)
                if last_incident_time_before is not None
                else None,
                "linked_account_id": linked_account_id,
                "page_size": page_size,
                "start_date": start_date,
                "status": status,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaginatedIssueList,
                    construct_type(
                        type_=PaginatedIssueList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def retrieve(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Issue]:
        """
        Get a specific issue.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Issue]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"filestorage/v1/issues/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Issue,
                    construct_type(
                        type_=Issue,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
