# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .file_drive import FileDrive
from .file_folder import FileFolder
from .file_permissions import FilePermissions
from .remote_data import RemoteData


class File(UncheckedBaseModel):
    """
    # The File Object
    ### Description
    The `File` object is used to represent a file in the workspace. The Object typically exists under a folder or drive, if it exists.
    ### Usage Example
    Fetch from the `GET /api/filestorage/v1/files` endpoint and view their files.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The file's name.
    """

    file_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL to access the file.
    """

    file_thumbnail_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL that produces a thumbnail preview of the file. Typically an image.
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The file's size, in bytes.
    """

    mime_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The file's mime type.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The file's description.
    """

    folder: typing.Optional[FileFolder] = pydantic.Field(default=None)
    """
    The folder that the file belongs to.
    """

    checksum: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    This field stores file checksum data. 'type' indicates the algorithm (e.g. crc_32, sha1, sha256, quickXor, or md5), and 'content_hash' is the unique hash used to verify file integrity and detect alterations.
    """

    permissions: typing.Optional[FilePermissions] = pydantic.Field(default=None)
    """
    The Permission object is used to represent a user's or group's access to a File or Folder. Permissions are unexpanded by default. Use the query param `expand=permissions` to see more details under `GET /files`.
    """

    drive: typing.Optional[FileDrive] = pydantic.Field(default=None)
    """
    The drive that the file belongs to.
    """

    remote_created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's file was created.
    """

    remote_updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's file was updated.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .folder import Folder  # noqa: E402, F401, I001
from .group import Group  # noqa: E402, F401, I001

update_forward_refs(File)
