# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .file_request_drive import FileRequestDrive
from .file_request_folder import FileRequestFolder
from .file_request_permissions import FileRequestPermissions


class FileRequest(UncheckedBaseModel):
    """
    # The File Object
    ### Description
    The `File` object is used to represent a file in the workspace. The Object typically exists under a folder or drive, if it exists.
    ### Usage Example
    Fetch from the `GET /api/filestorage/v1/files` endpoint and view their files.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The file's name.
    """

    file_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL to access the file.
    """

    file_thumbnail_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL that produces a thumbnail preview of the file. Typically an image.
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The file's size, in bytes.
    """

    mime_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The file's mime type.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The file's description.
    """

    folder: typing.Optional[FileRequestFolder] = pydantic.Field(default=None)
    """
    The folder that the file belongs to.
    """

    checksum: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    This field stores file checksum data. 'type' indicates the algorithm (e.g. crc_32, sha1, sha256, quickXor, or md5), and 'content_hash' is the unique hash used to verify file integrity and detect alterations.
    """

    permissions: typing.Optional[FileRequestPermissions] = pydantic.Field(default=None)
    """
    The Permission object is used to represent a user's or group's access to a File or Folder. Permissions are unexpanded by default. Use the query param `expand=permissions` to see more details under `GET /files`.
    """

    drive: typing.Optional[FileRequestDrive] = pydantic.Field(default=None)
    """
    The drive that the file belongs to.
    """

    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .folder import Folder  # noqa: E402, F401, I001
from .group import Group  # noqa: E402, F401, I001

update_forward_refs(FileRequest)
