# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .remote_data import RemoteData


class Group(UncheckedBaseModel):
    """
    # The Group Object
    ### Description
    The `Group` object is used to represent any subset of `Users`. This can extend to company domains as well.
    ### Usage Example
    Fetch from the `GET /api/filestorage/v1/groups` endpoint and view their groups.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The group's name.
    """

    users: typing.List[str] = pydantic.Field()
    """
    The users that belong in the group. If null, this typically means it's either a domain or the third-party platform does not surface this information.
    """

    child_groups: typing.Optional[typing.List["GroupChildGroupsItem"]] = pydantic.Field(default=None)
    """
    Groups that inherit the permissions of the parent group.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .group_child_groups_item import GroupChildGroupsItem  # noqa: E402, F401, I001

update_forward_refs(Group)
