# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .permission_request_group import PermissionRequestGroup
from .permission_request_roles_item import PermissionRequestRolesItem
from .permission_request_type import PermissionRequestType
from .permission_request_user import PermissionRequestUser


class PermissionRequest(UncheckedBaseModel):
    """
    # The Permission Object
    ### Description
    The Permission object is used to represent a user's or group's access to a File or Folder. Permissions are unexpanded by default.

    ### Usage Example
    Fetch from the `GET Files` or `GET Folders` endpoint. Permissions are unexpanded by default. Use the query param `expand=permissions` to see more details.
    """

    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    user: typing.Optional[PermissionRequestUser] = pydantic.Field(default=None)
    """
    The user that is granted this permission. This will only be populated if the type is `USER`.
    """

    group: typing.Optional[PermissionRequestGroup] = pydantic.Field(default=None)
    """
    The group that is granted this permission. This will only be populated if the type is `GROUP`.
    """

    type: typing.Optional[PermissionRequestType] = pydantic.Field(default=None)
    """
    Denotes what type of people have access to the file.
    
    * `USER` - USER
    * `GROUP` - GROUP
    * `COMPANY` - COMPANY
    * `ANYONE` - ANYONE
    """

    roles: typing.Optional[typing.List[typing.Optional[PermissionRequestRolesItem]]] = pydantic.Field(default=None)
    """
    The permissions that the user or group has for the File or Folder. It is possible for a user or group to have multiple roles, such as viewing & uploading. Possible values include: `READ`, `WRITE`, `OWNER`. In cases where there is no clear mapping, the original value passed through will be returned.
    """

    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .group import Group  # noqa: E402, F401, I001

update_forward_refs(PermissionRequest)
