# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.meta_response import MetaResponse
from ...types.paginated_timesheet_entry_list import PaginatedTimesheetEntryList
from ...types.timesheet_entry import TimesheetEntry
from ...types.timesheet_entry_request import TimesheetEntryRequest
from ...types.timesheet_entry_response import TimesheetEntryResponse
from .raw_client import AsyncRawTimesheetEntriesClient, RawTimesheetEntriesClient
from .types.timesheet_entries_list_request_order_by import TimesheetEntriesListRequestOrderBy

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TimesheetEntriesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTimesheetEntriesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTimesheetEntriesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTimesheetEntriesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        employee_id: typing.Optional[str] = None,
        ended_after: typing.Optional[dt.datetime] = None,
        ended_before: typing.Optional[dt.datetime] = None,
        expand: typing.Optional[typing.Literal["employee"]] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        order_by: typing.Optional[TimesheetEntriesListRequestOrderBy] = None,
        page_size: typing.Optional[int] = None,
        remote_id: typing.Optional[str] = None,
        started_after: typing.Optional[dt.datetime] = None,
        started_before: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedTimesheetEntryList:
        """
        Returns a list of `TimesheetEntry` objects.

        Parameters
        ----------
        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        employee_id : typing.Optional[str]
            If provided, will only return timesheet entries for this employee.

        ended_after : typing.Optional[dt.datetime]
            If provided, will only return timesheet entries ended after this datetime.

        ended_before : typing.Optional[dt.datetime]
            If provided, will only return timesheet entries ended before this datetime.

        expand : typing.Optional[typing.Literal["employee"]]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        order_by : typing.Optional[TimesheetEntriesListRequestOrderBy]
            Overrides the default ordering for this endpoint. Possible values include: start_time, -start_time.

        page_size : typing.Optional[int]
            Number of results to return per page.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        started_after : typing.Optional[dt.datetime]
            If provided, will only return timesheet entries started after this datetime.

        started_before : typing.Optional[dt.datetime]
            If provided, will only return timesheet entries started before this datetime.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedTimesheetEntryList


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.hris.timesheet_entries.list(
            cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
        )
        """
        _response = self._raw_client.list(
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            employee_id=employee_id,
            ended_after=ended_after,
            ended_before=ended_before,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            order_by=order_by,
            page_size=page_size,
            remote_id=remote_id,
            started_after=started_after,
            started_before=started_before,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        model: TimesheetEntryRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TimesheetEntryResponse:
        """
        Creates a `TimesheetEntry` object with the given values.

        Parameters
        ----------
        model : TimesheetEntryRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TimesheetEntryResponse


        Examples
        --------
        from merge import Merge
        from merge.resources.hris import TimesheetEntryRequest

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.hris.timesheet_entries.create(
            model=TimesheetEntryRequest(),
        )
        """
        _response = self._raw_client.create(
            model=model, is_debug_mode=is_debug_mode, run_async=run_async, request_options=request_options
        )
        return _response.data

    def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[typing.Literal["employee"]] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TimesheetEntry:
        """
        Returns a `TimesheetEntry` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[typing.Literal["employee"]]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TimesheetEntry


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.hris.timesheet_entries.retrieve(
            id="id",
        )
        """
        _response = self._raw_client.retrieve(
            id,
            expand=expand,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            request_options=request_options,
        )
        return _response.data

    def meta_post_retrieve(self, *, request_options: typing.Optional[RequestOptions] = None) -> MetaResponse:
        """
        Returns metadata for `TimesheetEntry` POSTs.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.hris.timesheet_entries.meta_post_retrieve()
        """
        _response = self._raw_client.meta_post_retrieve(request_options=request_options)
        return _response.data


class AsyncTimesheetEntriesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTimesheetEntriesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTimesheetEntriesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTimesheetEntriesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        employee_id: typing.Optional[str] = None,
        ended_after: typing.Optional[dt.datetime] = None,
        ended_before: typing.Optional[dt.datetime] = None,
        expand: typing.Optional[typing.Literal["employee"]] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        order_by: typing.Optional[TimesheetEntriesListRequestOrderBy] = None,
        page_size: typing.Optional[int] = None,
        remote_id: typing.Optional[str] = None,
        started_after: typing.Optional[dt.datetime] = None,
        started_before: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedTimesheetEntryList:
        """
        Returns a list of `TimesheetEntry` objects.

        Parameters
        ----------
        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        employee_id : typing.Optional[str]
            If provided, will only return timesheet entries for this employee.

        ended_after : typing.Optional[dt.datetime]
            If provided, will only return timesheet entries ended after this datetime.

        ended_before : typing.Optional[dt.datetime]
            If provided, will only return timesheet entries ended before this datetime.

        expand : typing.Optional[typing.Literal["employee"]]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        order_by : typing.Optional[TimesheetEntriesListRequestOrderBy]
            Overrides the default ordering for this endpoint. Possible values include: start_time, -start_time.

        page_size : typing.Optional[int]
            Number of results to return per page.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        started_after : typing.Optional[dt.datetime]
            If provided, will only return timesheet entries started after this datetime.

        started_before : typing.Optional[dt.datetime]
            If provided, will only return timesheet entries started before this datetime.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedTimesheetEntryList


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.hris.timesheet_entries.list(
                cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            employee_id=employee_id,
            ended_after=ended_after,
            ended_before=ended_before,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            order_by=order_by,
            page_size=page_size,
            remote_id=remote_id,
            started_after=started_after,
            started_before=started_before,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        model: TimesheetEntryRequest,
        is_debug_mode: typing.Optional[bool] = None,
        run_async: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TimesheetEntryResponse:
        """
        Creates a `TimesheetEntry` object with the given values.

        Parameters
        ----------
        model : TimesheetEntryRequest

        is_debug_mode : typing.Optional[bool]
            Whether to include debug fields (such as log file links) in the response.

        run_async : typing.Optional[bool]
            Whether or not third-party updates should be run asynchronously.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TimesheetEntryResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.hris import TimesheetEntryRequest

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.hris.timesheet_entries.create(
                model=TimesheetEntryRequest(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            model=model, is_debug_mode=is_debug_mode, run_async=run_async, request_options=request_options
        )
        return _response.data

    async def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[typing.Literal["employee"]] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TimesheetEntry:
        """
        Returns a `TimesheetEntry` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[typing.Literal["employee"]]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TimesheetEntry


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.hris.timesheet_entries.retrieve(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(
            id,
            expand=expand,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            request_options=request_options,
        )
        return _response.data

    async def meta_post_retrieve(self, *, request_options: typing.Optional[RequestOptions] = None) -> MetaResponse:
        """
        Returns metadata for `TimesheetEntry` POSTs.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetaResponse


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.hris.timesheet_entries.meta_post_retrieve()


        asyncio.run(main())
        """
        _response = await self._raw_client.meta_post_retrieve(request_options=request_options)
        return _response.data
