# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .account_details_and_actions_category import AccountDetailsAndActionsCategory
from .account_details_and_actions_integration import AccountDetailsAndActionsIntegration
from .account_details_and_actions_status_enum import AccountDetailsAndActionsStatusEnum


class AccountDetailsAndActions(UncheckedBaseModel):
    """
    # The LinkedAccount Object
    ### Description
    The `LinkedAccount` object is used to represent an end user's link with a specific integration.

    ### Usage Example
    View a list of your organization's `LinkedAccount` objects.
    """

    id: str
    category: typing.Optional[AccountDetailsAndActionsCategory] = None
    status: AccountDetailsAndActionsStatusEnum
    status_detail: typing.Optional[str] = None
    end_user_origin_id: typing.Optional[str] = None
    end_user_organization_name: str
    end_user_email_address: str
    subdomain: typing.Optional[str] = pydantic.Field(default=None)
    """
    The tenant or domain the customer has provided access to.
    """

    webhook_listener_url: str
    is_duplicate: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether a Production Linked Account's credentials match another existing Production Linked Account. This field is `null` for Test Linked Accounts, incomplete Production Linked Accounts, and ignored duplicate Production Linked Account sets.
    """

    integration: typing.Optional[AccountDetailsAndActionsIntegration] = None
    account_type: str
    completed_at: dt.datetime
    integration_specific_fields: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
