# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .benefit_employee import BenefitEmployee
from .remote_data import RemoteData


class Benefit(UncheckedBaseModel):
    """
    # The Benefit Object
    ### Description
    The `Benefit` object is used to represent a benefit that an employee has enrolled in.

    ### Usage Example
    Fetch from the `LIST Benefits` endpoint and filter by `ID` to show all benefits.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    employee: typing.Optional[BenefitEmployee] = pydantic.Field(default=None)
    """
    The employee on the plan.
    """

    provider_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the benefit provider.
    """

    benefit_plan_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of benefit plan
    """

    employee_contribution: typing.Optional[float] = pydantic.Field(default=None)
    """
    The employee's contribution.
    """

    company_contribution: typing.Optional[float] = pydantic.Field(default=None)
    """
    The company's contribution.
    """

    start_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The day and time the benefit started.
    """

    end_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The day and time the benefit ended.
    """

    employer_benefit: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employer benefit plan the employee is enrolled in.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .employee import Employee  # noqa: E402, F401, I001
from .employment import Employment  # noqa: E402, F401, I001
from .team import Team  # noqa: E402, F401, I001

update_forward_refs(Benefit)
