# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class PayCurrencyEnum(str, enum.Enum):
    """
    * `XUA` - ADB Unit of Account
    * `AFN` - Afghan Afghani
    * `AFA` - Afghan Afghani (1927–2002)
    * `ALL` - Albanian Lek
    * `ALK` - Albanian Lek (1946–1965)
    * `DZD` - Algerian Dinar
    * `ADP` - Andorran Peseta
    * `AOA` - Angolan Kwanza
    * `AOK` - Angolan Kwanza (1977–1991)
    * `AON` - Angolan New Kwanza (1990–2000)
    * `AOR` - Angolan Readjusted Kwanza (1995–1999)
    * `ARA` - Argentine Austral
    * `ARS` - Argentine Peso
    * `ARM` - Argentine Peso (1881–1970)
    * `ARP` - Argentine Peso (1983–1985)
    * `ARL` - Argentine Peso Ley (1970–1983)
    * `AMD` - Armenian Dram
    * `AWG` - Aruban Florin
    * `AUD` - Australian Dollar
    * `ATS` - Austrian Schilling
    * `AZN` - Azerbaijani Manat
    * `AZM` - Azerbaijani Manat (1993–2006)
    * `BSD` - Bahamian Dollar
    * `BHD` - Bahraini Dinar
    * `BDT` - Bangladeshi Taka
    * `BBD` - Barbadian Dollar
    * `BYN` - Belarusian Ruble
    * `BYB` - Belarusian Ruble (1994–1999)
    * `BYR` - Belarusian Ruble (2000–2016)
    * `BEF` - Belgian Franc
    * `BEC` - Belgian Franc (convertible)
    * `BEL` - Belgian Franc (financial)
    * `BZD` - Belize Dollar
    * `BMD` - Bermudan Dollar
    * `BTN` - Bhutanese Ngultrum
    * `BOB` - Bolivian Boliviano
    * `BOL` - Bolivian Boliviano (1863–1963)
    * `BOV` - Bolivian Mvdol
    * `BOP` - Bolivian Peso
    * `BAM` - Bosnia-Herzegovina Convertible Mark
    * `BAD` - Bosnia-Herzegovina Dinar (1992–1994)
    * `BAN` - Bosnia-Herzegovina New Dinar (1994–1997)
    * `BWP` - Botswanan Pula
    * `BRC` - Brazilian Cruzado (1986–1989)
    * `BRZ` - Brazilian Cruzeiro (1942–1967)
    * `BRE` - Brazilian Cruzeiro (1990–1993)
    * `BRR` - Brazilian Cruzeiro (1993–1994)
    * `BRN` - Brazilian New Cruzado (1989–1990)
    * `BRB` - Brazilian New Cruzeiro (1967–1986)
    * `BRL` - Brazilian Real
    * `GBP` - British Pound
    * `BND` - Brunei Dollar
    * `BGL` - Bulgarian Hard Lev
    * `BGN` - Bulgarian Lev
    * `BGO` - Bulgarian Lev (1879–1952)
    * `BGM` - Bulgarian Socialist Lev
    * `BUK` - Burmese Kyat
    * `BIF` - Burundian Franc
    * `XPF` - CFP Franc
    * `KHR` - Cambodian Riel
    * `CAD` - Canadian Dollar
    * `CVE` - Cape Verdean Escudo
    * `KYD` - Cayman Islands Dollar
    * `XAF` - Central African CFA Franc
    * `CLE` - Chilean Escudo
    * `CLP` - Chilean Peso
    * `CLF` - Chilean Unit of Account (UF)
    * `CNX` - Chinese People’s Bank Dollar
    * `CNY` - Chinese Yuan
    * `CNH` - Chinese Yuan (offshore)
    * `COP` - Colombian Peso
    * `COU` - Colombian Real Value Unit
    * `KMF` - Comorian Franc
    * `CDF` - Congolese Franc
    * `CRC` - Costa Rican Colón
    * `HRD` - Croatian Dinar
    * `HRK` - Croatian Kuna
    * `CUC` - Cuban Convertible Peso
    * `CUP` - Cuban Peso
    * `CYP` - Cypriot Pound
    * `CZK` - Czech Koruna
    * `CSK` - Czechoslovak Hard Koruna
    * `DKK` - Danish Krone
    * `DJF` - Djiboutian Franc
    * `DOP` - Dominican Peso
    * `NLG` - Dutch Guilder
    * `XCD` - East Caribbean Dollar
    * `DDM` - East German Mark
    * `ECS` - Ecuadorian Sucre
    * `ECV` - Ecuadorian Unit of Constant Value
    * `EGP` - Egyptian Pound
    * `GQE` - Equatorial Guinean Ekwele
    * `ERN` - Eritrean Nakfa
    * `EEK` - Estonian Kroon
    * `ETB` - Ethiopian Birr
    * `EUR` - Euro
    * `XBA` - European Composite Unit
    * `XEU` - European Currency Unit
    * `XBB` - European Monetary Unit
    * `XBC` - European Unit of Account (XBC)
    * `XBD` - European Unit of Account (XBD)
    * `FKP` - Falkland Islands Pound
    * `FJD` - Fijian Dollar
    * `FIM` - Finnish Markka
    * `FRF` - French Franc
    * `XFO` - French Gold Franc
    * `XFU` - French UIC-Franc
    * `GMD` - Gambian Dalasi
    * `GEK` - Georgian Kupon Larit
    * `GEL` - Georgian Lari
    * `DEM` - German Mark
    * `GHS` - Ghanaian Cedi
    * `GHC` - Ghanaian Cedi (1979–2007)
    * `GIP` - Gibraltar Pound
    * `XAU` - Gold
    * `GRD` - Greek Drachma
    * `GTQ` - Guatemalan Quetzal
    * `GWP` - Guinea-Bissau Peso
    * `GNF` - Guinean Franc
    * `GNS` - Guinean Syli
    * `GYD` - Guyanaese Dollar
    * `HTG` - Haitian Gourde
    * `HNL` - Honduran Lempira
    * `HKD` - Hong Kong Dollar
    * `HUF` - Hungarian Forint
    * `IMP` - IMP
    * `ISK` - Icelandic Króna
    * `ISJ` - Icelandic Króna (1918–1981)
    * `INR` - Indian Rupee
    * `IDR` - Indonesian Rupiah
    * `IRR` - Iranian Rial
    * `IQD` - Iraqi Dinar
    * `IEP` - Irish Pound
    * `ILS` - Israeli New Shekel
    * `ILP` - Israeli Pound
    * `ILR` - Israeli Shekel (1980–1985)
    * `ITL` - Italian Lira
    * `JMD` - Jamaican Dollar
    * `JPY` - Japanese Yen
    * `JOD` - Jordanian Dinar
    * `KZT` - Kazakhstani Tenge
    * `KES` - Kenyan Shilling
    * `KWD` - Kuwaiti Dinar
    * `KGS` - Kyrgystani Som
    * `LAK` - Laotian Kip
    * `LVL` - Latvian Lats
    * `LVR` - Latvian Ruble
    * `LBP` - Lebanese Pound
    * `LSL` - Lesotho Loti
    * `LRD` - Liberian Dollar
    * `LYD` - Libyan Dinar
    * `LTL` - Lithuanian Litas
    * `LTT` - Lithuanian Talonas
    * `LUL` - Luxembourg Financial Franc
    * `LUC` - Luxembourgian Convertible Franc
    * `LUF` - Luxembourgian Franc
    * `MOP` - Macanese Pataca
    * `MKD` - Macedonian Denar
    * `MKN` - Macedonian Denar (1992–1993)
    * `MGA` - Malagasy Ariary
    * `MGF` - Malagasy Franc
    * `MWK` - Malawian Kwacha
    * `MYR` - Malaysian Ringgit
    * `MVR` - Maldivian Rufiyaa
    * `MVP` - Maldivian Rupee (1947–1981)
    * `MLF` - Malian Franc
    * `MTL` - Maltese Lira
    * `MTP` - Maltese Pound
    * `MRU` - Mauritanian Ouguiya
    * `MRO` - Mauritanian Ouguiya (1973–2017)
    * `MUR` - Mauritian Rupee
    * `MXV` - Mexican Investment Unit
    * `MXN` - Mexican Peso
    * `MXP` - Mexican Silver Peso (1861–1992)
    * `MDC` - Moldovan Cupon
    * `MDL` - Moldovan Leu
    * `MCF` - Monegasque Franc
    * `MNT` - Mongolian Tugrik
    * `MAD` - Moroccan Dirham
    * `MAF` - Moroccan Franc
    * `MZE` - Mozambican Escudo
    * `MZN` - Mozambican Metical
    * `MZM` - Mozambican Metical (1980–2006)
    * `MMK` - Myanmar Kyat
    * `NAD` - Namibian Dollar
    * `NPR` - Nepalese Rupee
    * `ANG` - Netherlands Antillean Guilder
    * `TWD` - New Taiwan Dollar
    * `NZD` - New Zealand Dollar
    * `NIO` - Nicaraguan Córdoba
    * `NIC` - Nicaraguan Córdoba (1988–1991)
    * `NGN` - Nigerian Naira
    * `KPW` - North Korean Won
    * `NOK` - Norwegian Krone
    * `OMR` - Omani Rial
    * `PKR` - Pakistani Rupee
    * `XPD` - Palladium
    * `PAB` - Panamanian Balboa
    * `PGK` - Papua New Guinean Kina
    * `PYG` - Paraguayan Guarani
    * `PEI` - Peruvian Inti
    * `PEN` - Peruvian Sol
    * `PES` - Peruvian Sol (1863–1965)
    * `PHP` - Philippine Peso
    * `XPT` - Platinum
    * `PLN` - Polish Zloty
    * `PLZ` - Polish Zloty (1950–1995)
    * `PTE` - Portuguese Escudo
    * `GWE` - Portuguese Guinea Escudo
    * `QAR` - Qatari Rial
    * `XRE` - RINET Funds
    * `RHD` - Rhodesian Dollar
    * `RON` - Romanian Leu
    * `ROL` - Romanian Leu (1952–2006)
    * `RUB` - Russian Ruble
    * `RUR` - Russian Ruble (1991–1998)
    * `RWF` - Rwandan Franc
    * `SVC` - Salvadoran Colón
    * `WST` - Samoan Tala
    * `SAR` - Saudi Riyal
    * `RSD` - Serbian Dinar
    * `CSD` - Serbian Dinar (2002–2006)
    * `SCR` - Seychellois Rupee
    * `SLL` - Sierra Leonean Leone
    * `XAG` - Silver
    * `SGD` - Singapore Dollar
    * `SKK` - Slovak Koruna
    * `SIT` - Slovenian Tolar
    * `SBD` - Solomon Islands Dollar
    * `SOS` - Somali Shilling
    * `ZAR` - South African Rand
    * `ZAL` - South African Rand (financial)
    * `KRH` - South Korean Hwan (1953–1962)
    * `KRW` - South Korean Won
    * `KRO` - South Korean Won (1945–1953)
    * `SSP` - South Sudanese Pound
    * `SUR` - Soviet Rouble
    * `ESP` - Spanish Peseta
    * `ESA` - Spanish Peseta (A account)
    * `ESB` - Spanish Peseta (convertible account)
    * `XDR` - Special Drawing Rights
    * `LKR` - Sri Lankan Rupee
    * `SHP` - St. Helena Pound
    * `XSU` - Sucre
    * `SDD` - Sudanese Dinar (1992–2007)
    * `SDG` - Sudanese Pound
    * `SDP` - Sudanese Pound (1957–1998)
    * `SRD` - Surinamese Dollar
    * `SRG` - Surinamese Guilder
    * `SZL` - Swazi Lilangeni
    * `SEK` - Swedish Krona
    * `CHF` - Swiss Franc
    * `SYP` - Syrian Pound
    * `STN` - São Tomé & Príncipe Dobra
    * `STD` - São Tomé & Príncipe Dobra (1977–2017)
    * `TVD` - TVD
    * `TJR` - Tajikistani Ruble
    * `TJS` - Tajikistani Somoni
    * `TZS` - Tanzanian Shilling
    * `XTS` - Testing Currency Code
    * `THB` - Thai Baht
    * `XXX` - The codes assigned for transactions where no currency is involved
    * `TPE` - Timorese Escudo
    * `TOP` - Tongan Paʻanga
    * `TTD` - Trinidad & Tobago Dollar
    * `TND` - Tunisian Dinar
    * `TRY` - Turkish Lira
    * `TRL` - Turkish Lira (1922–2005)
    * `TMT` - Turkmenistani Manat
    * `TMM` - Turkmenistani Manat (1993–2009)
    * `USD` - US Dollar
    * `USN` - US Dollar (Next day)
    * `USS` - US Dollar (Same day)
    * `UGX` - Ugandan Shilling
    * `UGS` - Ugandan Shilling (1966–1987)
    * `UAH` - Ukrainian Hryvnia
    * `UAK` - Ukrainian Karbovanets
    * `AED` - United Arab Emirates Dirham
    * `UYW` - Uruguayan Nominal Wage Index Unit
    * `UYU` - Uruguayan Peso
    * `UYP` - Uruguayan Peso (1975–1993)
    * `UYI` - Uruguayan Peso (Indexed Units)
    * `UZS` - Uzbekistani Som
    * `VUV` - Vanuatu Vatu
    * `VES` - Venezuelan Bolívar
    * `VEB` - Venezuelan Bolívar (1871–2008)
    * `VEF` - Venezuelan Bolívar (2008–2018)
    * `VND` - Vietnamese Dong
    * `VNN` - Vietnamese Dong (1978–1985)
    * `CHE` - WIR Euro
    * `CHW` - WIR Franc
    * `XOF` - West African CFA Franc
    * `YDD` - Yemeni Dinar
    * `YER` - Yemeni Rial
    * `YUN` - Yugoslavian Convertible Dinar (1990–1992)
    * `YUD` - Yugoslavian Hard Dinar (1966–1990)
    * `YUM` - Yugoslavian New Dinar (1994–2002)
    * `YUR` - Yugoslavian Reformed Dinar (1992–1993)
    * `ZWN` - ZWN
    * `ZRN` - Zairean New Zaire (1993–1998)
    * `ZRZ` - Zairean Zaire (1971–1993)
    * `ZMW` - Zambian Kwacha
    * `ZMK` - Zambian Kwacha (1968–2012)
    * `ZWD` - Zimbabwean Dollar (1980–2008)
    * `ZWR` - Zimbabwean Dollar (2008)
    * `ZWL` - Zimbabwean Dollar (2009)
    """

    XUA = "XUA"
    AFN = "AFN"
    AFA = "AFA"
    ALL = "ALL"
    ALK = "ALK"
    DZD = "DZD"
    ADP = "ADP"
    AOA = "AOA"
    AOK = "AOK"
    AON = "AON"
    AOR = "AOR"
    ARA = "ARA"
    ARS = "ARS"
    ARM = "ARM"
    ARP = "ARP"
    ARL = "ARL"
    AMD = "AMD"
    AWG = "AWG"
    AUD = "AUD"
    ATS = "ATS"
    AZN = "AZN"
    AZM = "AZM"
    BSD = "BSD"
    BHD = "BHD"
    BDT = "BDT"
    BBD = "BBD"
    BYN = "BYN"
    BYB = "BYB"
    BYR = "BYR"
    BEF = "BEF"
    BEC = "BEC"
    BEL = "BEL"
    BZD = "BZD"
    BMD = "BMD"
    BTN = "BTN"
    BOB = "BOB"
    BOL = "BOL"
    BOV = "BOV"
    BOP = "BOP"
    BAM = "BAM"
    BAD = "BAD"
    BAN = "BAN"
    BWP = "BWP"
    BRC = "BRC"
    BRZ = "BRZ"
    BRE = "BRE"
    BRR = "BRR"
    BRN = "BRN"
    BRB = "BRB"
    BRL = "BRL"
    GBP = "GBP"
    BND = "BND"
    BGL = "BGL"
    BGN = "BGN"
    BGO = "BGO"
    BGM = "BGM"
    BUK = "BUK"
    BIF = "BIF"
    XPF = "XPF"
    KHR = "KHR"
    CAD = "CAD"
    CVE = "CVE"
    KYD = "KYD"
    XAF = "XAF"
    CLE = "CLE"
    CLP = "CLP"
    CLF = "CLF"
    CNX = "CNX"
    CNY = "CNY"
    CNH = "CNH"
    COP = "COP"
    COU = "COU"
    KMF = "KMF"
    CDF = "CDF"
    CRC = "CRC"
    HRD = "HRD"
    HRK = "HRK"
    CUC = "CUC"
    CUP = "CUP"
    CYP = "CYP"
    CZK = "CZK"
    CSK = "CSK"
    DKK = "DKK"
    DJF = "DJF"
    DOP = "DOP"
    NLG = "NLG"
    XCD = "XCD"
    DDM = "DDM"
    ECS = "ECS"
    ECV = "ECV"
    EGP = "EGP"
    GQE = "GQE"
    ERN = "ERN"
    EEK = "EEK"
    ETB = "ETB"
    EUR = "EUR"
    XBA = "XBA"
    XEU = "XEU"
    XBB = "XBB"
    XBC = "XBC"
    XBD = "XBD"
    FKP = "FKP"
    FJD = "FJD"
    FIM = "FIM"
    FRF = "FRF"
    XFO = "XFO"
    XFU = "XFU"
    GMD = "GMD"
    GEK = "GEK"
    GEL = "GEL"
    DEM = "DEM"
    GHS = "GHS"
    GHC = "GHC"
    GIP = "GIP"
    XAU = "XAU"
    GRD = "GRD"
    GTQ = "GTQ"
    GWP = "GWP"
    GNF = "GNF"
    GNS = "GNS"
    GYD = "GYD"
    HTG = "HTG"
    HNL = "HNL"
    HKD = "HKD"
    HUF = "HUF"
    IMP = "IMP"
    ISK = "ISK"
    ISJ = "ISJ"
    INR = "INR"
    IDR = "IDR"
    IRR = "IRR"
    IQD = "IQD"
    IEP = "IEP"
    ILS = "ILS"
    ILP = "ILP"
    ILR = "ILR"
    ITL = "ITL"
    JMD = "JMD"
    JPY = "JPY"
    JOD = "JOD"
    KZT = "KZT"
    KES = "KES"
    KWD = "KWD"
    KGS = "KGS"
    LAK = "LAK"
    LVL = "LVL"
    LVR = "LVR"
    LBP = "LBP"
    LSL = "LSL"
    LRD = "LRD"
    LYD = "LYD"
    LTL = "LTL"
    LTT = "LTT"
    LUL = "LUL"
    LUC = "LUC"
    LUF = "LUF"
    MOP = "MOP"
    MKD = "MKD"
    MKN = "MKN"
    MGA = "MGA"
    MGF = "MGF"
    MWK = "MWK"
    MYR = "MYR"
    MVR = "MVR"
    MVP = "MVP"
    MLF = "MLF"
    MTL = "MTL"
    MTP = "MTP"
    MRU = "MRU"
    MRO = "MRO"
    MUR = "MUR"
    MXV = "MXV"
    MXN = "MXN"
    MXP = "MXP"
    MDC = "MDC"
    MDL = "MDL"
    MCF = "MCF"
    MNT = "MNT"
    MAD = "MAD"
    MAF = "MAF"
    MZE = "MZE"
    MZN = "MZN"
    MZM = "MZM"
    MMK = "MMK"
    NAD = "NAD"
    NPR = "NPR"
    ANG = "ANG"
    TWD = "TWD"
    NZD = "NZD"
    NIO = "NIO"
    NIC = "NIC"
    NGN = "NGN"
    KPW = "KPW"
    NOK = "NOK"
    OMR = "OMR"
    PKR = "PKR"
    XPD = "XPD"
    PAB = "PAB"
    PGK = "PGK"
    PYG = "PYG"
    PEI = "PEI"
    PEN = "PEN"
    PES = "PES"
    PHP = "PHP"
    XPT = "XPT"
    PLN = "PLN"
    PLZ = "PLZ"
    PTE = "PTE"
    GWE = "GWE"
    QAR = "QAR"
    XRE = "XRE"
    RHD = "RHD"
    RON = "RON"
    ROL = "ROL"
    RUB = "RUB"
    RUR = "RUR"
    RWF = "RWF"
    SVC = "SVC"
    WST = "WST"
    SAR = "SAR"
    RSD = "RSD"
    CSD = "CSD"
    SCR = "SCR"
    SLL = "SLL"
    XAG = "XAG"
    SGD = "SGD"
    SKK = "SKK"
    SIT = "SIT"
    SBD = "SBD"
    SOS = "SOS"
    ZAR = "ZAR"
    ZAL = "ZAL"
    KRH = "KRH"
    KRW = "KRW"
    KRO = "KRO"
    SSP = "SSP"
    SUR = "SUR"
    ESP = "ESP"
    ESA = "ESA"
    ESB = "ESB"
    XDR = "XDR"
    LKR = "LKR"
    SHP = "SHP"
    XSU = "XSU"
    SDD = "SDD"
    SDG = "SDG"
    SDP = "SDP"
    SRD = "SRD"
    SRG = "SRG"
    SZL = "SZL"
    SEK = "SEK"
    CHF = "CHF"
    SYP = "SYP"
    STN = "STN"
    STD = "STD"
    TVD = "TVD"
    TJR = "TJR"
    TJS = "TJS"
    TZS = "TZS"
    XTS = "XTS"
    THB = "THB"
    XXX = "XXX"
    TPE = "TPE"
    TOP = "TOP"
    TTD = "TTD"
    TND = "TND"
    TRY = "TRY"
    TRL = "TRL"
    TMT = "TMT"
    TMM = "TMM"
    USD = "USD"
    USN = "USN"
    USS = "USS"
    UGX = "UGX"
    UGS = "UGS"
    UAH = "UAH"
    UAK = "UAK"
    AED = "AED"
    UYW = "UYW"
    UYU = "UYU"
    UYP = "UYP"
    UYI = "UYI"
    UZS = "UZS"
    VUV = "VUV"
    VES = "VES"
    VEB = "VEB"
    VEF = "VEF"
    VND = "VND"
    VNN = "VNN"
    CHE = "CHE"
    CHW = "CHW"
    XOF = "XOF"
    YDD = "YDD"
    YER = "YER"
    YUN = "YUN"
    YUD = "YUD"
    YUM = "YUM"
    YUR = "YUR"
    ZWN = "ZWN"
    ZRN = "ZRN"
    ZRZ = "ZRZ"
    ZMW = "ZMW"
    ZMK = "ZMK"
    ZWD = "ZWD"
    ZWR = "ZWR"
    ZWL = "ZWL"

    def visit(
        self,
        xua: typing.Callable[[], T_Result],
        afn: typing.Callable[[], T_Result],
        afa: typing.Callable[[], T_Result],
        all_: typing.Callable[[], T_Result],
        alk: typing.Callable[[], T_Result],
        dzd: typing.Callable[[], T_Result],
        adp: typing.Callable[[], T_Result],
        aoa: typing.Callable[[], T_Result],
        aok: typing.Callable[[], T_Result],
        aon: typing.Callable[[], T_Result],
        aor: typing.Callable[[], T_Result],
        ara: typing.Callable[[], T_Result],
        ars: typing.Callable[[], T_Result],
        arm: typing.Callable[[], T_Result],
        arp: typing.Callable[[], T_Result],
        arl: typing.Callable[[], T_Result],
        amd: typing.Callable[[], T_Result],
        awg: typing.Callable[[], T_Result],
        aud: typing.Callable[[], T_Result],
        ats: typing.Callable[[], T_Result],
        azn: typing.Callable[[], T_Result],
        azm: typing.Callable[[], T_Result],
        bsd: typing.Callable[[], T_Result],
        bhd: typing.Callable[[], T_Result],
        bdt: typing.Callable[[], T_Result],
        bbd: typing.Callable[[], T_Result],
        byn: typing.Callable[[], T_Result],
        byb: typing.Callable[[], T_Result],
        byr: typing.Callable[[], T_Result],
        bef: typing.Callable[[], T_Result],
        bec: typing.Callable[[], T_Result],
        bel: typing.Callable[[], T_Result],
        bzd: typing.Callable[[], T_Result],
        bmd: typing.Callable[[], T_Result],
        btn: typing.Callable[[], T_Result],
        bob: typing.Callable[[], T_Result],
        bol: typing.Callable[[], T_Result],
        bov: typing.Callable[[], T_Result],
        bop: typing.Callable[[], T_Result],
        bam: typing.Callable[[], T_Result],
        bad: typing.Callable[[], T_Result],
        ban: typing.Callable[[], T_Result],
        bwp: typing.Callable[[], T_Result],
        brc: typing.Callable[[], T_Result],
        brz: typing.Callable[[], T_Result],
        bre: typing.Callable[[], T_Result],
        brr: typing.Callable[[], T_Result],
        brn: typing.Callable[[], T_Result],
        brb: typing.Callable[[], T_Result],
        brl: typing.Callable[[], T_Result],
        gbp: typing.Callable[[], T_Result],
        bnd: typing.Callable[[], T_Result],
        bgl: typing.Callable[[], T_Result],
        bgn: typing.Callable[[], T_Result],
        bgo: typing.Callable[[], T_Result],
        bgm: typing.Callable[[], T_Result],
        buk: typing.Callable[[], T_Result],
        bif: typing.Callable[[], T_Result],
        xpf: typing.Callable[[], T_Result],
        khr: typing.Callable[[], T_Result],
        cad: typing.Callable[[], T_Result],
        cve: typing.Callable[[], T_Result],
        kyd: typing.Callable[[], T_Result],
        xaf: typing.Callable[[], T_Result],
        cle: typing.Callable[[], T_Result],
        clp: typing.Callable[[], T_Result],
        clf: typing.Callable[[], T_Result],
        cnx: typing.Callable[[], T_Result],
        cny: typing.Callable[[], T_Result],
        cnh: typing.Callable[[], T_Result],
        cop: typing.Callable[[], T_Result],
        cou: typing.Callable[[], T_Result],
        kmf: typing.Callable[[], T_Result],
        cdf: typing.Callable[[], T_Result],
        crc: typing.Callable[[], T_Result],
        hrd: typing.Callable[[], T_Result],
        hrk: typing.Callable[[], T_Result],
        cuc: typing.Callable[[], T_Result],
        cup: typing.Callable[[], T_Result],
        cyp: typing.Callable[[], T_Result],
        czk: typing.Callable[[], T_Result],
        csk: typing.Callable[[], T_Result],
        dkk: typing.Callable[[], T_Result],
        djf: typing.Callable[[], T_Result],
        dop: typing.Callable[[], T_Result],
        nlg: typing.Callable[[], T_Result],
        xcd: typing.Callable[[], T_Result],
        ddm: typing.Callable[[], T_Result],
        ecs: typing.Callable[[], T_Result],
        ecv: typing.Callable[[], T_Result],
        egp: typing.Callable[[], T_Result],
        gqe: typing.Callable[[], T_Result],
        ern: typing.Callable[[], T_Result],
        eek: typing.Callable[[], T_Result],
        etb: typing.Callable[[], T_Result],
        eur: typing.Callable[[], T_Result],
        xba: typing.Callable[[], T_Result],
        xeu: typing.Callable[[], T_Result],
        xbb: typing.Callable[[], T_Result],
        xbc: typing.Callable[[], T_Result],
        xbd: typing.Callable[[], T_Result],
        fkp: typing.Callable[[], T_Result],
        fjd: typing.Callable[[], T_Result],
        fim: typing.Callable[[], T_Result],
        frf: typing.Callable[[], T_Result],
        xfo: typing.Callable[[], T_Result],
        xfu: typing.Callable[[], T_Result],
        gmd: typing.Callable[[], T_Result],
        gek: typing.Callable[[], T_Result],
        gel: typing.Callable[[], T_Result],
        dem: typing.Callable[[], T_Result],
        ghs: typing.Callable[[], T_Result],
        ghc: typing.Callable[[], T_Result],
        gip: typing.Callable[[], T_Result],
        xau: typing.Callable[[], T_Result],
        grd: typing.Callable[[], T_Result],
        gtq: typing.Callable[[], T_Result],
        gwp: typing.Callable[[], T_Result],
        gnf: typing.Callable[[], T_Result],
        gns: typing.Callable[[], T_Result],
        gyd: typing.Callable[[], T_Result],
        htg: typing.Callable[[], T_Result],
        hnl: typing.Callable[[], T_Result],
        hkd: typing.Callable[[], T_Result],
        huf: typing.Callable[[], T_Result],
        imp: typing.Callable[[], T_Result],
        isk: typing.Callable[[], T_Result],
        isj: typing.Callable[[], T_Result],
        inr: typing.Callable[[], T_Result],
        idr: typing.Callable[[], T_Result],
        irr: typing.Callable[[], T_Result],
        iqd: typing.Callable[[], T_Result],
        iep: typing.Callable[[], T_Result],
        ils: typing.Callable[[], T_Result],
        ilp: typing.Callable[[], T_Result],
        ilr: typing.Callable[[], T_Result],
        itl: typing.Callable[[], T_Result],
        jmd: typing.Callable[[], T_Result],
        jpy: typing.Callable[[], T_Result],
        jod: typing.Callable[[], T_Result],
        kzt: typing.Callable[[], T_Result],
        kes: typing.Callable[[], T_Result],
        kwd: typing.Callable[[], T_Result],
        kgs: typing.Callable[[], T_Result],
        lak: typing.Callable[[], T_Result],
        lvl: typing.Callable[[], T_Result],
        lvr: typing.Callable[[], T_Result],
        lbp: typing.Callable[[], T_Result],
        lsl: typing.Callable[[], T_Result],
        lrd: typing.Callable[[], T_Result],
        lyd: typing.Callable[[], T_Result],
        ltl: typing.Callable[[], T_Result],
        ltt: typing.Callable[[], T_Result],
        lul: typing.Callable[[], T_Result],
        luc: typing.Callable[[], T_Result],
        luf: typing.Callable[[], T_Result],
        mop: typing.Callable[[], T_Result],
        mkd: typing.Callable[[], T_Result],
        mkn: typing.Callable[[], T_Result],
        mga: typing.Callable[[], T_Result],
        mgf: typing.Callable[[], T_Result],
        mwk: typing.Callable[[], T_Result],
        myr: typing.Callable[[], T_Result],
        mvr: typing.Callable[[], T_Result],
        mvp: typing.Callable[[], T_Result],
        mlf: typing.Callable[[], T_Result],
        mtl: typing.Callable[[], T_Result],
        mtp: typing.Callable[[], T_Result],
        mru: typing.Callable[[], T_Result],
        mro: typing.Callable[[], T_Result],
        mur: typing.Callable[[], T_Result],
        mxv: typing.Callable[[], T_Result],
        mxn: typing.Callable[[], T_Result],
        mxp: typing.Callable[[], T_Result],
        mdc: typing.Callable[[], T_Result],
        mdl: typing.Callable[[], T_Result],
        mcf: typing.Callable[[], T_Result],
        mnt: typing.Callable[[], T_Result],
        mad: typing.Callable[[], T_Result],
        maf: typing.Callable[[], T_Result],
        mze: typing.Callable[[], T_Result],
        mzn: typing.Callable[[], T_Result],
        mzm: typing.Callable[[], T_Result],
        mmk: typing.Callable[[], T_Result],
        nad: typing.Callable[[], T_Result],
        npr: typing.Callable[[], T_Result],
        ang: typing.Callable[[], T_Result],
        twd: typing.Callable[[], T_Result],
        nzd: typing.Callable[[], T_Result],
        nio: typing.Callable[[], T_Result],
        nic: typing.Callable[[], T_Result],
        ngn: typing.Callable[[], T_Result],
        kpw: typing.Callable[[], T_Result],
        nok: typing.Callable[[], T_Result],
        omr: typing.Callable[[], T_Result],
        pkr: typing.Callable[[], T_Result],
        xpd: typing.Callable[[], T_Result],
        pab: typing.Callable[[], T_Result],
        pgk: typing.Callable[[], T_Result],
        pyg: typing.Callable[[], T_Result],
        pei: typing.Callable[[], T_Result],
        pen: typing.Callable[[], T_Result],
        pes: typing.Callable[[], T_Result],
        php: typing.Callable[[], T_Result],
        xpt: typing.Callable[[], T_Result],
        pln: typing.Callable[[], T_Result],
        plz: typing.Callable[[], T_Result],
        pte: typing.Callable[[], T_Result],
        gwe: typing.Callable[[], T_Result],
        qar: typing.Callable[[], T_Result],
        xre: typing.Callable[[], T_Result],
        rhd: typing.Callable[[], T_Result],
        ron: typing.Callable[[], T_Result],
        rol: typing.Callable[[], T_Result],
        rub: typing.Callable[[], T_Result],
        rur: typing.Callable[[], T_Result],
        rwf: typing.Callable[[], T_Result],
        svc: typing.Callable[[], T_Result],
        wst: typing.Callable[[], T_Result],
        sar: typing.Callable[[], T_Result],
        rsd: typing.Callable[[], T_Result],
        csd: typing.Callable[[], T_Result],
        scr: typing.Callable[[], T_Result],
        sll: typing.Callable[[], T_Result],
        xag: typing.Callable[[], T_Result],
        sgd: typing.Callable[[], T_Result],
        skk: typing.Callable[[], T_Result],
        sit: typing.Callable[[], T_Result],
        sbd: typing.Callable[[], T_Result],
        sos: typing.Callable[[], T_Result],
        zar: typing.Callable[[], T_Result],
        zal: typing.Callable[[], T_Result],
        krh: typing.Callable[[], T_Result],
        krw: typing.Callable[[], T_Result],
        kro: typing.Callable[[], T_Result],
        ssp: typing.Callable[[], T_Result],
        sur: typing.Callable[[], T_Result],
        esp: typing.Callable[[], T_Result],
        esa: typing.Callable[[], T_Result],
        esb: typing.Callable[[], T_Result],
        xdr: typing.Callable[[], T_Result],
        lkr: typing.Callable[[], T_Result],
        shp: typing.Callable[[], T_Result],
        xsu: typing.Callable[[], T_Result],
        sdd: typing.Callable[[], T_Result],
        sdg: typing.Callable[[], T_Result],
        sdp: typing.Callable[[], T_Result],
        srd: typing.Callable[[], T_Result],
        srg: typing.Callable[[], T_Result],
        szl: typing.Callable[[], T_Result],
        sek: typing.Callable[[], T_Result],
        chf: typing.Callable[[], T_Result],
        syp: typing.Callable[[], T_Result],
        stn: typing.Callable[[], T_Result],
        std: typing.Callable[[], T_Result],
        tvd: typing.Callable[[], T_Result],
        tjr: typing.Callable[[], T_Result],
        tjs: typing.Callable[[], T_Result],
        tzs: typing.Callable[[], T_Result],
        xts: typing.Callable[[], T_Result],
        thb: typing.Callable[[], T_Result],
        xxx: typing.Callable[[], T_Result],
        tpe: typing.Callable[[], T_Result],
        top: typing.Callable[[], T_Result],
        ttd: typing.Callable[[], T_Result],
        tnd: typing.Callable[[], T_Result],
        try_: typing.Callable[[], T_Result],
        trl: typing.Callable[[], T_Result],
        tmt: typing.Callable[[], T_Result],
        tmm: typing.Callable[[], T_Result],
        usd: typing.Callable[[], T_Result],
        usn: typing.Callable[[], T_Result],
        uss: typing.Callable[[], T_Result],
        ugx: typing.Callable[[], T_Result],
        ugs: typing.Callable[[], T_Result],
        uah: typing.Callable[[], T_Result],
        uak: typing.Callable[[], T_Result],
        aed: typing.Callable[[], T_Result],
        uyw: typing.Callable[[], T_Result],
        uyu: typing.Callable[[], T_Result],
        uyp: typing.Callable[[], T_Result],
        uyi: typing.Callable[[], T_Result],
        uzs: typing.Callable[[], T_Result],
        vuv: typing.Callable[[], T_Result],
        ves: typing.Callable[[], T_Result],
        veb: typing.Callable[[], T_Result],
        vef: typing.Callable[[], T_Result],
        vnd: typing.Callable[[], T_Result],
        vnn: typing.Callable[[], T_Result],
        che: typing.Callable[[], T_Result],
        chw: typing.Callable[[], T_Result],
        xof: typing.Callable[[], T_Result],
        ydd: typing.Callable[[], T_Result],
        yer: typing.Callable[[], T_Result],
        yun: typing.Callable[[], T_Result],
        yud: typing.Callable[[], T_Result],
        yum: typing.Callable[[], T_Result],
        yur: typing.Callable[[], T_Result],
        zwn: typing.Callable[[], T_Result],
        zrn: typing.Callable[[], T_Result],
        zrz: typing.Callable[[], T_Result],
        zmw: typing.Callable[[], T_Result],
        zmk: typing.Callable[[], T_Result],
        zwd: typing.Callable[[], T_Result],
        zwr: typing.Callable[[], T_Result],
        zwl: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is PayCurrencyEnum.XUA:
            return xua()
        if self is PayCurrencyEnum.AFN:
            return afn()
        if self is PayCurrencyEnum.AFA:
            return afa()
        if self is PayCurrencyEnum.ALL:
            return all_()
        if self is PayCurrencyEnum.ALK:
            return alk()
        if self is PayCurrencyEnum.DZD:
            return dzd()
        if self is PayCurrencyEnum.ADP:
            return adp()
        if self is PayCurrencyEnum.AOA:
            return aoa()
        if self is PayCurrencyEnum.AOK:
            return aok()
        if self is PayCurrencyEnum.AON:
            return aon()
        if self is PayCurrencyEnum.AOR:
            return aor()
        if self is PayCurrencyEnum.ARA:
            return ara()
        if self is PayCurrencyEnum.ARS:
            return ars()
        if self is PayCurrencyEnum.ARM:
            return arm()
        if self is PayCurrencyEnum.ARP:
            return arp()
        if self is PayCurrencyEnum.ARL:
            return arl()
        if self is PayCurrencyEnum.AMD:
            return amd()
        if self is PayCurrencyEnum.AWG:
            return awg()
        if self is PayCurrencyEnum.AUD:
            return aud()
        if self is PayCurrencyEnum.ATS:
            return ats()
        if self is PayCurrencyEnum.AZN:
            return azn()
        if self is PayCurrencyEnum.AZM:
            return azm()
        if self is PayCurrencyEnum.BSD:
            return bsd()
        if self is PayCurrencyEnum.BHD:
            return bhd()
        if self is PayCurrencyEnum.BDT:
            return bdt()
        if self is PayCurrencyEnum.BBD:
            return bbd()
        if self is PayCurrencyEnum.BYN:
            return byn()
        if self is PayCurrencyEnum.BYB:
            return byb()
        if self is PayCurrencyEnum.BYR:
            return byr()
        if self is PayCurrencyEnum.BEF:
            return bef()
        if self is PayCurrencyEnum.BEC:
            return bec()
        if self is PayCurrencyEnum.BEL:
            return bel()
        if self is PayCurrencyEnum.BZD:
            return bzd()
        if self is PayCurrencyEnum.BMD:
            return bmd()
        if self is PayCurrencyEnum.BTN:
            return btn()
        if self is PayCurrencyEnum.BOB:
            return bob()
        if self is PayCurrencyEnum.BOL:
            return bol()
        if self is PayCurrencyEnum.BOV:
            return bov()
        if self is PayCurrencyEnum.BOP:
            return bop()
        if self is PayCurrencyEnum.BAM:
            return bam()
        if self is PayCurrencyEnum.BAD:
            return bad()
        if self is PayCurrencyEnum.BAN:
            return ban()
        if self is PayCurrencyEnum.BWP:
            return bwp()
        if self is PayCurrencyEnum.BRC:
            return brc()
        if self is PayCurrencyEnum.BRZ:
            return brz()
        if self is PayCurrencyEnum.BRE:
            return bre()
        if self is PayCurrencyEnum.BRR:
            return brr()
        if self is PayCurrencyEnum.BRN:
            return brn()
        if self is PayCurrencyEnum.BRB:
            return brb()
        if self is PayCurrencyEnum.BRL:
            return brl()
        if self is PayCurrencyEnum.GBP:
            return gbp()
        if self is PayCurrencyEnum.BND:
            return bnd()
        if self is PayCurrencyEnum.BGL:
            return bgl()
        if self is PayCurrencyEnum.BGN:
            return bgn()
        if self is PayCurrencyEnum.BGO:
            return bgo()
        if self is PayCurrencyEnum.BGM:
            return bgm()
        if self is PayCurrencyEnum.BUK:
            return buk()
        if self is PayCurrencyEnum.BIF:
            return bif()
        if self is PayCurrencyEnum.XPF:
            return xpf()
        if self is PayCurrencyEnum.KHR:
            return khr()
        if self is PayCurrencyEnum.CAD:
            return cad()
        if self is PayCurrencyEnum.CVE:
            return cve()
        if self is PayCurrencyEnum.KYD:
            return kyd()
        if self is PayCurrencyEnum.XAF:
            return xaf()
        if self is PayCurrencyEnum.CLE:
            return cle()
        if self is PayCurrencyEnum.CLP:
            return clp()
        if self is PayCurrencyEnum.CLF:
            return clf()
        if self is PayCurrencyEnum.CNX:
            return cnx()
        if self is PayCurrencyEnum.CNY:
            return cny()
        if self is PayCurrencyEnum.CNH:
            return cnh()
        if self is PayCurrencyEnum.COP:
            return cop()
        if self is PayCurrencyEnum.COU:
            return cou()
        if self is PayCurrencyEnum.KMF:
            return kmf()
        if self is PayCurrencyEnum.CDF:
            return cdf()
        if self is PayCurrencyEnum.CRC:
            return crc()
        if self is PayCurrencyEnum.HRD:
            return hrd()
        if self is PayCurrencyEnum.HRK:
            return hrk()
        if self is PayCurrencyEnum.CUC:
            return cuc()
        if self is PayCurrencyEnum.CUP:
            return cup()
        if self is PayCurrencyEnum.CYP:
            return cyp()
        if self is PayCurrencyEnum.CZK:
            return czk()
        if self is PayCurrencyEnum.CSK:
            return csk()
        if self is PayCurrencyEnum.DKK:
            return dkk()
        if self is PayCurrencyEnum.DJF:
            return djf()
        if self is PayCurrencyEnum.DOP:
            return dop()
        if self is PayCurrencyEnum.NLG:
            return nlg()
        if self is PayCurrencyEnum.XCD:
            return xcd()
        if self is PayCurrencyEnum.DDM:
            return ddm()
        if self is PayCurrencyEnum.ECS:
            return ecs()
        if self is PayCurrencyEnum.ECV:
            return ecv()
        if self is PayCurrencyEnum.EGP:
            return egp()
        if self is PayCurrencyEnum.GQE:
            return gqe()
        if self is PayCurrencyEnum.ERN:
            return ern()
        if self is PayCurrencyEnum.EEK:
            return eek()
        if self is PayCurrencyEnum.ETB:
            return etb()
        if self is PayCurrencyEnum.EUR:
            return eur()
        if self is PayCurrencyEnum.XBA:
            return xba()
        if self is PayCurrencyEnum.XEU:
            return xeu()
        if self is PayCurrencyEnum.XBB:
            return xbb()
        if self is PayCurrencyEnum.XBC:
            return xbc()
        if self is PayCurrencyEnum.XBD:
            return xbd()
        if self is PayCurrencyEnum.FKP:
            return fkp()
        if self is PayCurrencyEnum.FJD:
            return fjd()
        if self is PayCurrencyEnum.FIM:
            return fim()
        if self is PayCurrencyEnum.FRF:
            return frf()
        if self is PayCurrencyEnum.XFO:
            return xfo()
        if self is PayCurrencyEnum.XFU:
            return xfu()
        if self is PayCurrencyEnum.GMD:
            return gmd()
        if self is PayCurrencyEnum.GEK:
            return gek()
        if self is PayCurrencyEnum.GEL:
            return gel()
        if self is PayCurrencyEnum.DEM:
            return dem()
        if self is PayCurrencyEnum.GHS:
            return ghs()
        if self is PayCurrencyEnum.GHC:
            return ghc()
        if self is PayCurrencyEnum.GIP:
            return gip()
        if self is PayCurrencyEnum.XAU:
            return xau()
        if self is PayCurrencyEnum.GRD:
            return grd()
        if self is PayCurrencyEnum.GTQ:
            return gtq()
        if self is PayCurrencyEnum.GWP:
            return gwp()
        if self is PayCurrencyEnum.GNF:
            return gnf()
        if self is PayCurrencyEnum.GNS:
            return gns()
        if self is PayCurrencyEnum.GYD:
            return gyd()
        if self is PayCurrencyEnum.HTG:
            return htg()
        if self is PayCurrencyEnum.HNL:
            return hnl()
        if self is PayCurrencyEnum.HKD:
            return hkd()
        if self is PayCurrencyEnum.HUF:
            return huf()
        if self is PayCurrencyEnum.IMP:
            return imp()
        if self is PayCurrencyEnum.ISK:
            return isk()
        if self is PayCurrencyEnum.ISJ:
            return isj()
        if self is PayCurrencyEnum.INR:
            return inr()
        if self is PayCurrencyEnum.IDR:
            return idr()
        if self is PayCurrencyEnum.IRR:
            return irr()
        if self is PayCurrencyEnum.IQD:
            return iqd()
        if self is PayCurrencyEnum.IEP:
            return iep()
        if self is PayCurrencyEnum.ILS:
            return ils()
        if self is PayCurrencyEnum.ILP:
            return ilp()
        if self is PayCurrencyEnum.ILR:
            return ilr()
        if self is PayCurrencyEnum.ITL:
            return itl()
        if self is PayCurrencyEnum.JMD:
            return jmd()
        if self is PayCurrencyEnum.JPY:
            return jpy()
        if self is PayCurrencyEnum.JOD:
            return jod()
        if self is PayCurrencyEnum.KZT:
            return kzt()
        if self is PayCurrencyEnum.KES:
            return kes()
        if self is PayCurrencyEnum.KWD:
            return kwd()
        if self is PayCurrencyEnum.KGS:
            return kgs()
        if self is PayCurrencyEnum.LAK:
            return lak()
        if self is PayCurrencyEnum.LVL:
            return lvl()
        if self is PayCurrencyEnum.LVR:
            return lvr()
        if self is PayCurrencyEnum.LBP:
            return lbp()
        if self is PayCurrencyEnum.LSL:
            return lsl()
        if self is PayCurrencyEnum.LRD:
            return lrd()
        if self is PayCurrencyEnum.LYD:
            return lyd()
        if self is PayCurrencyEnum.LTL:
            return ltl()
        if self is PayCurrencyEnum.LTT:
            return ltt()
        if self is PayCurrencyEnum.LUL:
            return lul()
        if self is PayCurrencyEnum.LUC:
            return luc()
        if self is PayCurrencyEnum.LUF:
            return luf()
        if self is PayCurrencyEnum.MOP:
            return mop()
        if self is PayCurrencyEnum.MKD:
            return mkd()
        if self is PayCurrencyEnum.MKN:
            return mkn()
        if self is PayCurrencyEnum.MGA:
            return mga()
        if self is PayCurrencyEnum.MGF:
            return mgf()
        if self is PayCurrencyEnum.MWK:
            return mwk()
        if self is PayCurrencyEnum.MYR:
            return myr()
        if self is PayCurrencyEnum.MVR:
            return mvr()
        if self is PayCurrencyEnum.MVP:
            return mvp()
        if self is PayCurrencyEnum.MLF:
            return mlf()
        if self is PayCurrencyEnum.MTL:
            return mtl()
        if self is PayCurrencyEnum.MTP:
            return mtp()
        if self is PayCurrencyEnum.MRU:
            return mru()
        if self is PayCurrencyEnum.MRO:
            return mro()
        if self is PayCurrencyEnum.MUR:
            return mur()
        if self is PayCurrencyEnum.MXV:
            return mxv()
        if self is PayCurrencyEnum.MXN:
            return mxn()
        if self is PayCurrencyEnum.MXP:
            return mxp()
        if self is PayCurrencyEnum.MDC:
            return mdc()
        if self is PayCurrencyEnum.MDL:
            return mdl()
        if self is PayCurrencyEnum.MCF:
            return mcf()
        if self is PayCurrencyEnum.MNT:
            return mnt()
        if self is PayCurrencyEnum.MAD:
            return mad()
        if self is PayCurrencyEnum.MAF:
            return maf()
        if self is PayCurrencyEnum.MZE:
            return mze()
        if self is PayCurrencyEnum.MZN:
            return mzn()
        if self is PayCurrencyEnum.MZM:
            return mzm()
        if self is PayCurrencyEnum.MMK:
            return mmk()
        if self is PayCurrencyEnum.NAD:
            return nad()
        if self is PayCurrencyEnum.NPR:
            return npr()
        if self is PayCurrencyEnum.ANG:
            return ang()
        if self is PayCurrencyEnum.TWD:
            return twd()
        if self is PayCurrencyEnum.NZD:
            return nzd()
        if self is PayCurrencyEnum.NIO:
            return nio()
        if self is PayCurrencyEnum.NIC:
            return nic()
        if self is PayCurrencyEnum.NGN:
            return ngn()
        if self is PayCurrencyEnum.KPW:
            return kpw()
        if self is PayCurrencyEnum.NOK:
            return nok()
        if self is PayCurrencyEnum.OMR:
            return omr()
        if self is PayCurrencyEnum.PKR:
            return pkr()
        if self is PayCurrencyEnum.XPD:
            return xpd()
        if self is PayCurrencyEnum.PAB:
            return pab()
        if self is PayCurrencyEnum.PGK:
            return pgk()
        if self is PayCurrencyEnum.PYG:
            return pyg()
        if self is PayCurrencyEnum.PEI:
            return pei()
        if self is PayCurrencyEnum.PEN:
            return pen()
        if self is PayCurrencyEnum.PES:
            return pes()
        if self is PayCurrencyEnum.PHP:
            return php()
        if self is PayCurrencyEnum.XPT:
            return xpt()
        if self is PayCurrencyEnum.PLN:
            return pln()
        if self is PayCurrencyEnum.PLZ:
            return plz()
        if self is PayCurrencyEnum.PTE:
            return pte()
        if self is PayCurrencyEnum.GWE:
            return gwe()
        if self is PayCurrencyEnum.QAR:
            return qar()
        if self is PayCurrencyEnum.XRE:
            return xre()
        if self is PayCurrencyEnum.RHD:
            return rhd()
        if self is PayCurrencyEnum.RON:
            return ron()
        if self is PayCurrencyEnum.ROL:
            return rol()
        if self is PayCurrencyEnum.RUB:
            return rub()
        if self is PayCurrencyEnum.RUR:
            return rur()
        if self is PayCurrencyEnum.RWF:
            return rwf()
        if self is PayCurrencyEnum.SVC:
            return svc()
        if self is PayCurrencyEnum.WST:
            return wst()
        if self is PayCurrencyEnum.SAR:
            return sar()
        if self is PayCurrencyEnum.RSD:
            return rsd()
        if self is PayCurrencyEnum.CSD:
            return csd()
        if self is PayCurrencyEnum.SCR:
            return scr()
        if self is PayCurrencyEnum.SLL:
            return sll()
        if self is PayCurrencyEnum.XAG:
            return xag()
        if self is PayCurrencyEnum.SGD:
            return sgd()
        if self is PayCurrencyEnum.SKK:
            return skk()
        if self is PayCurrencyEnum.SIT:
            return sit()
        if self is PayCurrencyEnum.SBD:
            return sbd()
        if self is PayCurrencyEnum.SOS:
            return sos()
        if self is PayCurrencyEnum.ZAR:
            return zar()
        if self is PayCurrencyEnum.ZAL:
            return zal()
        if self is PayCurrencyEnum.KRH:
            return krh()
        if self is PayCurrencyEnum.KRW:
            return krw()
        if self is PayCurrencyEnum.KRO:
            return kro()
        if self is PayCurrencyEnum.SSP:
            return ssp()
        if self is PayCurrencyEnum.SUR:
            return sur()
        if self is PayCurrencyEnum.ESP:
            return esp()
        if self is PayCurrencyEnum.ESA:
            return esa()
        if self is PayCurrencyEnum.ESB:
            return esb()
        if self is PayCurrencyEnum.XDR:
            return xdr()
        if self is PayCurrencyEnum.LKR:
            return lkr()
        if self is PayCurrencyEnum.SHP:
            return shp()
        if self is PayCurrencyEnum.XSU:
            return xsu()
        if self is PayCurrencyEnum.SDD:
            return sdd()
        if self is PayCurrencyEnum.SDG:
            return sdg()
        if self is PayCurrencyEnum.SDP:
            return sdp()
        if self is PayCurrencyEnum.SRD:
            return srd()
        if self is PayCurrencyEnum.SRG:
            return srg()
        if self is PayCurrencyEnum.SZL:
            return szl()
        if self is PayCurrencyEnum.SEK:
            return sek()
        if self is PayCurrencyEnum.CHF:
            return chf()
        if self is PayCurrencyEnum.SYP:
            return syp()
        if self is PayCurrencyEnum.STN:
            return stn()
        if self is PayCurrencyEnum.STD:
            return std()
        if self is PayCurrencyEnum.TVD:
            return tvd()
        if self is PayCurrencyEnum.TJR:
            return tjr()
        if self is PayCurrencyEnum.TJS:
            return tjs()
        if self is PayCurrencyEnum.TZS:
            return tzs()
        if self is PayCurrencyEnum.XTS:
            return xts()
        if self is PayCurrencyEnum.THB:
            return thb()
        if self is PayCurrencyEnum.XXX:
            return xxx()
        if self is PayCurrencyEnum.TPE:
            return tpe()
        if self is PayCurrencyEnum.TOP:
            return top()
        if self is PayCurrencyEnum.TTD:
            return ttd()
        if self is PayCurrencyEnum.TND:
            return tnd()
        if self is PayCurrencyEnum.TRY:
            return try_()
        if self is PayCurrencyEnum.TRL:
            return trl()
        if self is PayCurrencyEnum.TMT:
            return tmt()
        if self is PayCurrencyEnum.TMM:
            return tmm()
        if self is PayCurrencyEnum.USD:
            return usd()
        if self is PayCurrencyEnum.USN:
            return usn()
        if self is PayCurrencyEnum.USS:
            return uss()
        if self is PayCurrencyEnum.UGX:
            return ugx()
        if self is PayCurrencyEnum.UGS:
            return ugs()
        if self is PayCurrencyEnum.UAH:
            return uah()
        if self is PayCurrencyEnum.UAK:
            return uak()
        if self is PayCurrencyEnum.AED:
            return aed()
        if self is PayCurrencyEnum.UYW:
            return uyw()
        if self is PayCurrencyEnum.UYU:
            return uyu()
        if self is PayCurrencyEnum.UYP:
            return uyp()
        if self is PayCurrencyEnum.UYI:
            return uyi()
        if self is PayCurrencyEnum.UZS:
            return uzs()
        if self is PayCurrencyEnum.VUV:
            return vuv()
        if self is PayCurrencyEnum.VES:
            return ves()
        if self is PayCurrencyEnum.VEB:
            return veb()
        if self is PayCurrencyEnum.VEF:
            return vef()
        if self is PayCurrencyEnum.VND:
            return vnd()
        if self is PayCurrencyEnum.VNN:
            return vnn()
        if self is PayCurrencyEnum.CHE:
            return che()
        if self is PayCurrencyEnum.CHW:
            return chw()
        if self is PayCurrencyEnum.XOF:
            return xof()
        if self is PayCurrencyEnum.YDD:
            return ydd()
        if self is PayCurrencyEnum.YER:
            return yer()
        if self is PayCurrencyEnum.YUN:
            return yun()
        if self is PayCurrencyEnum.YUD:
            return yud()
        if self is PayCurrencyEnum.YUM:
            return yum()
        if self is PayCurrencyEnum.YUR:
            return yur()
        if self is PayCurrencyEnum.ZWN:
            return zwn()
        if self is PayCurrencyEnum.ZRN:
            return zrn()
        if self is PayCurrencyEnum.ZRZ:
            return zrz()
        if self is PayCurrencyEnum.ZMW:
            return zmw()
        if self is PayCurrencyEnum.ZMK:
            return zmk()
        if self is PayCurrencyEnum.ZWD:
            return zwd()
        if self is PayCurrencyEnum.ZWR:
            return zwr()
        if self is PayCurrencyEnum.ZWL:
            return zwl()
