# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .selective_sync_configurations_usage_enum import SelectiveSyncConfigurationsUsageEnum
from .status_fd_5_enum import StatusFd5Enum
from .sync_status_last_sync_result import SyncStatusLastSyncResult


class SyncStatus(UncheckedBaseModel):
    """
    # The SyncStatus Object
    ### Description
    The `SyncStatus` object is used to represent the syncing state of an account

    ### Usage Example
    View the `SyncStatus` for an account to see how recently its models were synced.
    """

    model_name: str
    model_id: str
    last_sync_start: typing.Optional[dt.datetime] = None
    next_sync_start: typing.Optional[dt.datetime] = None
    last_sync_result: typing.Optional[SyncStatusLastSyncResult] = None
    last_sync_finished: typing.Optional[dt.datetime] = None
    status: StatusFd5Enum
    is_initial_sync: bool
    selective_sync_configurations_usage: typing.Optional[SelectiveSyncConfigurationsUsageEnum] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
