# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .remote_data import RemoteData
from .time_off_approver import TimeOffApprover
from .time_off_employee import TimeOffEmployee
from .time_off_request_type import TimeOffRequestType
from .time_off_status import TimeOffStatus
from .time_off_units import TimeOffUnits


class TimeOff(UncheckedBaseModel):
    """
    # The TimeOff Object
    ### Description
    The `TimeOff` object is used to represent all employees' Time Off entries.

    ### Usage Example
    Fetch from the `LIST TimeOffs` endpoint and filter by `ID` to show all time off requests.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    employee: typing.Optional[TimeOffEmployee] = pydantic.Field(default=None)
    """
    The employee requesting time off.
    """

    approver: typing.Optional[TimeOffApprover] = pydantic.Field(default=None)
    """
    The Merge ID of the employee with the ability to approve the time off request.
    """

    status: typing.Optional[TimeOffStatus] = pydantic.Field(default=None)
    """
    The status of this time off request.
    
    * `REQUESTED` - REQUESTED
    * `APPROVED` - APPROVED
    * `DECLINED` - DECLINED
    * `CANCELLED` - CANCELLED
    * `DELETED` - DELETED
    """

    employee_note: typing.Optional[str] = pydantic.Field(default=None)
    """
    The employee note for this time off request.
    """

    units: typing.Optional[TimeOffUnits] = pydantic.Field(default=None)
    """
    The measurement that the third-party integration uses to count time requested.
    
    * `HOURS` - HOURS
    * `DAYS` - DAYS
    """

    amount: typing.Optional[float] = pydantic.Field(default=None)
    """
    The time off quantity measured by the prescribed “units”.
    """

    request_type: typing.Optional[TimeOffRequestType] = pydantic.Field(default=None)
    """
    The type of time off request.
    
    * `VACATION` - VACATION
    * `SICK` - SICK
    * `PERSONAL` - PERSONAL
    * `JURY_DUTY` - JURY_DUTY
    * `VOLUNTEER` - VOLUNTEER
    * `BEREAVEMENT` - BEREAVEMENT
    """

    start_time: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The day and time of the start of the time requested off.
    """

    end_time: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The day and time of the end of the time requested off.
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .employee import Employee  # noqa: E402, F401, I001
from .employment import Employment  # noqa: E402, F401, I001
from .team import Team  # noqa: E402, F401, I001

update_forward_refs(TimeOff)
