# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.remote_key import RemoteKey
from .raw_client import AsyncRawGenerateKeyClient, RawGenerateKeyClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class GenerateKeyClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawGenerateKeyClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawGenerateKeyClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawGenerateKeyClient
        """
        return self._raw_client

    def create(self, *, name: str, request_options: typing.Optional[RequestOptions] = None) -> RemoteKey:
        """
        Create a remote key.

        Parameters
        ----------
        name : str
            The name of the remote key

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RemoteKey


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.knowledgebase.generate_key.create(
            name="Remote Deployment Key 1",
        )
        """
        _response = self._raw_client.create(name=name, request_options=request_options)
        return _response.data


class AsyncGenerateKeyClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawGenerateKeyClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawGenerateKeyClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawGenerateKeyClient
        """
        return self._raw_client

    async def create(self, *, name: str, request_options: typing.Optional[RequestOptions] = None) -> RemoteKey:
        """
        Create a remote key.

        Parameters
        ----------
        name : str
            The name of the remote key

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RemoteKey


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.knowledgebase.generate_key.create(
                name="Remote Deployment Key 1",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(name=name, request_options=request_options)
        return _response.data
