# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .container_permissions_item import ContainerPermissionsItem
from .container_status import ContainerStatus
from .container_type import ContainerType
from .container_visibility import ContainerVisibility
from .remote_data import RemoteData


class Container(UncheckedBaseModel):
    """
    # The Container Object
    ### Description
    The Container object is used to represent a grouping of articles in the knowledge base. This can include Spaces, Folders, Databases, etc.
    ### Usage Example
    Fetch from the `GET /api/knowledgebase/v1/containers` endpoint and view their containers.
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the container.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the container.
    """

    status: typing.Optional[ContainerStatus] = pydantic.Field(default=None)
    """
    The container's status.
    
    * `DRAFT` - DRAFT
    * `PUBLISHED` - PUBLISHED
    * `ARCHIVED` - ARCHIVED
    * `TRASH` - TRASH
    """

    container_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL to the webpage of the container.
    """

    type: typing.Optional[ContainerType] = pydantic.Field(default=None)
    """
    The container's type.
    
    * `FOLDER` - FOLDER
    * `SPACE` - SPACE
    * `COLLECTION` - COLLECTION
    * `SECTION` - SECTION
    * `CATEGORY` - CATEGORY
    * `DATABASE` - DATABASE
    """

    visibility: typing.Optional[ContainerVisibility] = pydantic.Field(default=None)
    """
    The container's visibility.
    
    * `PUBLIC` - PUBLIC
    * `INTERNAL` - INTERNAL
    * `RESTRICTED` - RESTRICTED
    """

    remote_created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's container was created.
    """

    remote_updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the third party's container was updated.
    """

    parent_article: typing.Optional[str] = pydantic.Field(default=None)
    """
    The parent article a container is nested within.
    """

    parent_container: typing.Optional[str] = pydantic.Field(default=None)
    """
    The parent container a container is nested within.
    """

    permissions: typing.Optional[typing.List[ContainerPermissionsItem]] = None
    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .group import Group  # noqa: E402, F401, I001

update_forward_refs(Container)
