# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.account_details import AccountDetails
from .raw_client import AsyncRawAccountDetailsClient, RawAccountDetailsClient


class AccountDetailsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAccountDetailsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAccountDetailsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAccountDetailsClient
        """
        return self._raw_client

    def retrieve(self, *, request_options: typing.Optional[RequestOptions] = None) -> AccountDetails:
        """
        Get details for a linked account.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountDetails


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ticketing.account_details.retrieve()
        """
        _response = self._raw_client.retrieve(request_options=request_options)
        return _response.data


class AsyncAccountDetailsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAccountDetailsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAccountDetailsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAccountDetailsClient
        """
        return self._raw_client

    async def retrieve(self, *, request_options: typing.Optional[RequestOptions] = None) -> AccountDetails:
        """
        Get details for a linked account.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountDetails


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ticketing.account_details.retrieve()


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(request_options=request_options)
        return _response.data
