# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.account_token import AccountToken
from .raw_client import AsyncRawAccountTokenClient, RawAccountTokenClient


class AccountTokenClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAccountTokenClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAccountTokenClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAccountTokenClient
        """
        return self._raw_client

    def retrieve(self, public_token: str, *, request_options: typing.Optional[RequestOptions] = None) -> AccountToken:
        """
        Returns the account token for the end user with the provided public token.

        Parameters
        ----------
        public_token : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountToken


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.ticketing.account_token.retrieve(
            public_token="public_token",
        )
        """
        _response = self._raw_client.retrieve(public_token, request_options=request_options)
        return _response.data


class AsyncAccountTokenClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAccountTokenClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAccountTokenClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAccountTokenClient
        """
        return self._raw_client

    async def retrieve(
        self, public_token: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AccountToken:
        """
        Returns the account token for the end user with the provided public token.

        Parameters
        ----------
        public_token : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountToken


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.ticketing.account_token.retrieve(
                public_token="public_token",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(public_token, request_options=request_options)
        return _response.data
