# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ....core.unchecked_base_model import UncheckedBaseModel
from .comment_request_contact import CommentRequestContact
from .comment_request_ticket import CommentRequestTicket
from .comment_request_user import CommentRequestUser


class CommentRequest(UncheckedBaseModel):
    """
    # The Comment Object
    ### Description
    The `Comment` object is used to represent a comment on a ticket.

    ### Usage Example
    TODO
    """

    user: typing.Optional[CommentRequestUser] = pydantic.Field(default=None)
    """
    The author of the Comment, if the author is a User. If the third party does not support specifying an author, we will append "[Posted on behalf of {name}]" to the comment.
    """

    contact: typing.Optional[CommentRequestContact] = pydantic.Field(default=None)
    """
    The author of the Comment, if the author is a Contact.If the third party does not support specifying an author, we will append "[Posted on behalf of {name}]" to the comment.
    """

    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    The comment's text body.
    """

    html_body: typing.Optional[str] = pydantic.Field(default=None)
    """
    The comment's text body formatted as html.
    """

    ticket: typing.Optional[CommentRequestTicket] = pydantic.Field(default=None)
    """
    The ticket associated with the comment. 
    """

    is_private: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether or not the comment is internal.
    """

    integration_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    linked_account_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .attachment import Attachment  # noqa: E402, F401, I001
from .collection import Collection  # noqa: E402, F401, I001
from .ticket import Ticket  # noqa: E402, F401, I001

update_forward_refs(CommentRequest)
