# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .remote_data import RemoteData
from .role_ticket_access import RoleTicketAccess
from .role_ticket_actions_item import RoleTicketActionsItem


class Role(UncheckedBaseModel):
    """
    # The Role Object
    ### Description
    The `Role` object is used to represent the set of actions & access that a user with this role is allowed to perform.

    ### Usage Example
    TODO
    """

    id: typing.Optional[str] = None
    remote_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The third-party API ID of the matching object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was created by Merge.
    """

    modified_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The datetime that this object was modified by Merge.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the Role.
    """

    ticket_actions: typing.Optional[typing.List[typing.Optional[RoleTicketActionsItem]]] = pydantic.Field(default=None)
    """
    The set of actions that a User with this Role can perform. Possible enum values include: `VIEW`, `CREATE`, `EDIT`, `DELETE`, `CLOSE`, and `ASSIGN`.
    """

    ticket_access: typing.Optional[RoleTicketAccess] = pydantic.Field(default=None)
    """
    The level of Ticket access that a User with this Role can perform.
    
    * `ALL` - ALL
    * `ASSIGNED_ONLY` - ASSIGNED_ONLY
    * `TEAM_ONLY` - TEAM_ONLY
    """

    remote_was_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).
    """

    field_mappings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    remote_data: typing.Optional[typing.List[RemoteData]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
