"""
    GAMS Engine

    With GAMS Engine you can register and solve GAMS models. It has a namespace management system, so you can restrict your users to certain models.  # noqa: E501

    The version of the OpenAPI document: latest
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from gams.engine.api_client import ApiClient, Endpoint as _Endpoint
from gams.engine.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from gams.engine.model.job import Job
from gams.engine.model.job_no_text_entry_page import JobNoTextEntryPage
from gams.engine.model.log_piece import LogPiece
from gams.engine.model.message import Message
from gams.engine.model.message_and_token import MessageAndToken
from gams.engine.model.quota_exceeded import QuotaExceeded
from gams.engine.model.status_code_meaning import StatusCodeMeaning
from gams.engine.model.stream_entry import StreamEntry
from gams.engine.model.text_entry import TextEntry


class JobsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.consume_stream_entry_endpoint = _Endpoint(
            settings={
                'response_type': (StreamEntry,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/jobs/{token}/stream-entry',
                'operation_id': 'consume_stream_entry',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'token',
                    'entry_name',
                ],
                'required': [
                    'token',
                    'entry_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token':
                        (str,),
                    'entry_name':
                        (str,),
                },
                'attribute_map': {
                    'token': 'token',
                    'entry_name': 'entry_name',
                },
                'location_map': {
                    'token': 'path',
                    'entry_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_job_endpoint = _Endpoint(
            settings={
                'response_type': (MessageAndToken,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/jobs/',
                'operation_id': 'create_job',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'model',
                    'namespace',
                    'run',
                    'inex_string',
                    'text_entries',
                    'stream_entries',
                    'stdout_filename',
                    'arguments',
                    'dep_tokens',
                    'labels',
                    'tag',
                    'access_groups',
                    'model_data',
                    'data',
                    'inex_file',
                ],
                'required': [
                    'model',
                    'namespace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'model':
                        (str,),
                    'namespace':
                        (str,),
                    'run':
                        (str,),
                    'inex_string':
                        (str,),
                    'text_entries':
                        ([str],),
                    'stream_entries':
                        ([str],),
                    'stdout_filename':
                        (str,),
                    'arguments':
                        ([str],),
                    'dep_tokens':
                        ([str],),
                    'labels':
                        ([str],),
                    'tag':
                        (str,),
                    'access_groups':
                        ([str],),
                    'model_data':
                        (file_type,),
                    'data':
                        (file_type,),
                    'inex_file':
                        (file_type,),
                },
                'attribute_map': {
                    'model': 'model',
                    'namespace': 'namespace',
                    'run': 'run',
                    'inex_string': 'inex_string',
                    'text_entries': 'text_entries',
                    'stream_entries': 'stream_entries',
                    'stdout_filename': 'stdout_filename',
                    'arguments': 'arguments',
                    'dep_tokens': 'dep_tokens',
                    'labels': 'labels',
                    'tag': 'tag',
                    'access_groups': 'access_groups',
                    'model_data': 'model_data',
                    'data': 'data',
                    'inex_file': 'inex_file',
                },
                'location_map': {
                    'model': 'query',
                    'namespace': 'query',
                    'run': 'query',
                    'inex_string': 'query',
                    'text_entries': 'query',
                    'stream_entries': 'query',
                    'stdout_filename': 'query',
                    'arguments': 'query',
                    'dep_tokens': 'query',
                    'labels': 'query',
                    'tag': 'query',
                    'access_groups': 'query',
                    'model_data': 'form',
                    'data': 'form',
                    'inex_file': 'form',
                },
                'collection_format_map': {
                    'text_entries': 'multi',
                    'stream_entries': 'multi',
                    'arguments': 'multi',
                    'dep_tokens': 'multi',
                    'labels': 'multi',
                    'access_groups': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.delete_job_zip_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/jobs/{token}/result',
                'operation_id': 'delete_job_zip',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'token',
                ],
                'required': [
                    'token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'token': 'token',
                },
                'location_map': {
                    'token': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_job_endpoint = _Endpoint(
            settings={
                'response_type': (Job,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/jobs/{token}',
                'operation_id': 'get_job',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'token',
                    'x_fields',
                ],
                'required': [
                    'token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token':
                        (str,),
                    'x_fields':
                        (str,),
                },
                'attribute_map': {
                    'token': 'token',
                    'x_fields': 'X-Fields',
                },
                'location_map': {
                    'token': 'path',
                    'x_fields': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_job_text_entry_endpoint = _Endpoint(
            settings={
                'response_type': (TextEntry,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/jobs/{token}/text-entry/{entry_name}',
                'operation_id': 'get_job_text_entry',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'token',
                    'entry_name',
                    'start_position',
                    'length',
                ],
                'required': [
                    'token',
                    'entry_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'start_position',
                    'length',
                ]
            },
            root_map={
                'validations': {
                    ('start_position',): {

                        'inclusive_maximum': 2147483647,
                        'inclusive_minimum': 1,
                    },
                    ('length',): {

                        'inclusive_maximum': 2147483647,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token':
                        (str,),
                    'entry_name':
                        (str,),
                    'start_position':
                        (int,),
                    'length':
                        (int,),
                },
                'attribute_map': {
                    'token': 'token',
                    'entry_name': 'entry_name',
                    'start_position': 'start_position',
                    'length': 'length',
                },
                'location_map': {
                    'token': 'path',
                    'entry_name': 'path',
                    'start_position': 'query',
                    'length': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_job_text_entry_info_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/jobs/{token}/text-entry/{entry_name}',
                'operation_id': 'get_job_text_entry_info',
                'http_method': 'HEAD',
                'servers': None,
            },
            params_map={
                'all': [
                    'token',
                    'entry_name',
                ],
                'required': [
                    'token',
                    'entry_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token':
                        (str,),
                    'entry_name':
                        (str,),
                },
                'attribute_map': {
                    'token': 'token',
                    'entry_name': 'entry_name',
                },
                'location_map': {
                    'token': 'path',
                    'entry_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_job_zip_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/jobs/{token}/result',
                'operation_id': 'get_job_zip',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'token',
                ],
                'required': [
                    'token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'token': 'token',
                },
                'location_map': {
                    'token': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/zip'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_job_zip_info_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/jobs/{token}/result',
                'operation_id': 'get_job_zip_info',
                'http_method': 'HEAD',
                'servers': None,
            },
            params_map={
                'all': [
                    'token',
                ],
                'required': [
                    'token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'token': 'token',
                },
                'location_map': {
                    'token': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_status_codes_endpoint = _Endpoint(
            settings={
                'response_type': ([StatusCodeMeaning],),
                'auth': [],
                'endpoint_path': '/jobs/status-codes',
                'operation_id': 'get_status_codes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_fields',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_fields':
                        (str,),
                },
                'attribute_map': {
                    'x_fields': 'X-Fields',
                },
                'location_map': {
                    'x_fields': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.kill_job_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/jobs/{token}',
                'operation_id': 'kill_job',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'token',
                    'hard_kill',
                ],
                'required': [
                    'token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token':
                        (str,),
                    'hard_kill':
                        (bool,),
                },
                'attribute_map': {
                    'token': 'token',
                    'hard_kill': 'hard_kill',
                },
                'location_map': {
                    'token': 'path',
                    'hard_kill': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_jobs_endpoint = _Endpoint(
            settings={
                'response_type': (JobNoTextEntryPage,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/jobs/',
                'operation_id': 'list_jobs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'everyone',
                    'x_fields',
                    'page',
                    'per_page',
                    'order_by',
                    'order_asc',
                    'show_only_active',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'order_by',
                ],
                'validation': [
                    'page',
                    'per_page',
                ]
            },
            root_map={
                'validations': {
                    ('page',): {

                        'inclusive_maximum': 2147483647,
                        'inclusive_minimum': 1,
                    },
                    ('per_page',): {

                        'inclusive_maximum': 2147483647,
                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                    ('order_by',): {

                        "MODEL": "model",
                        "NAMESPACE": "namespace",
                        "STATUS": "status",
                        "PROCESS_STATUS": "process_status",
                        "SUBMITTED_AT": "submitted_at",
                        "FINISHED_AT": "finished_at",
                        "USER": "user"
                    },
                },
                'openapi_types': {
                    'everyone':
                        (bool,),
                    'x_fields':
                        (str,),
                    'page':
                        (int,),
                    'per_page':
                        (int,),
                    'order_by':
                        (str,),
                    'order_asc':
                        (bool,),
                    'show_only_active':
                        (bool,),
                },
                'attribute_map': {
                    'everyone': 'everyone',
                    'x_fields': 'X-Fields',
                    'page': 'page',
                    'per_page': 'per_page',
                    'order_by': 'order_by',
                    'order_asc': 'order_asc',
                    'show_only_active': 'show_only_active',
                },
                'location_map': {
                    'everyone': 'query',
                    'x_fields': 'header',
                    'page': 'query',
                    'per_page': 'query',
                    'order_by': 'query',
                    'order_asc': 'query',
                    'show_only_active': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.pop_job_logs_endpoint = _Endpoint(
            settings={
                'response_type': (LogPiece,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/jobs/{token}/unread-logs',
                'operation_id': 'pop_job_logs',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'token',
                ],
                'required': [
                    'token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'token': 'token',
                },
                'location_map': {
                    'token': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.pop_stream_entry_endpoint = _Endpoint(
            settings={
                'response_type': (StreamEntry,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/jobs/{token}/stream-entry/{entry_name}',
                'operation_id': 'pop_stream_entry',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'token',
                    'entry_name',
                ],
                'required': [
                    'token',
                    'entry_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token':
                        (str,),
                    'entry_name':
                        (str,),
                },
                'attribute_map': {
                    'token': 'token',
                    'entry_name': 'entry_name',
                },
                'location_map': {
                    'token': 'path',
                    'entry_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.query_job_text_entry_endpoint = _Endpoint(
            settings={
                'response_type': (TextEntry,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/jobs/{token}/text-entry',
                'operation_id': 'query_job_text_entry',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'token',
                    'entry_name',
                    'start_position',
                    'length',
                ],
                'required': [
                    'token',
                    'entry_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'start_position',
                    'length',
                ]
            },
            root_map={
                'validations': {
                    ('start_position',): {

                        'inclusive_maximum': 2147483647,
                        'inclusive_minimum': 1,
                    },
                    ('length',): {

                        'inclusive_maximum': 2147483647,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token':
                        (str,),
                    'entry_name':
                        (str,),
                    'start_position':
                        (int,),
                    'length':
                        (int,),
                },
                'attribute_map': {
                    'token': 'token',
                    'entry_name': 'entry_name',
                    'start_position': 'start_position',
                    'length': 'length',
                },
                'location_map': {
                    'token': 'path',
                    'entry_name': 'query',
                    'start_position': 'query',
                    'length': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.query_job_text_entry_info_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/jobs/{token}/text-entry',
                'operation_id': 'query_job_text_entry_info',
                'http_method': 'HEAD',
                'servers': None,
            },
            params_map={
                'all': [
                    'token',
                    'entry_name',
                ],
                'required': [
                    'token',
                    'entry_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token':
                        (str,),
                    'entry_name':
                        (str,),
                },
                'attribute_map': {
                    'token': 'token',
                    'entry_name': 'entry_name',
                },
                'location_map': {
                    'token': 'path',
                    'entry_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_job_access_groups_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/jobs/{token}/access-groups',
                'operation_id': 'update_job_access_groups',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'token',
                    'access_groups',
                ],
                'required': [
                    'token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token':
                        (str,),
                    'access_groups':
                        ([str],),
                },
                'attribute_map': {
                    'token': 'token',
                    'access_groups': 'access_groups',
                },
                'location_map': {
                    'token': 'path',
                    'access_groups': 'query',
                },
                'collection_format_map': {
                    'access_groups': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_job_tag_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/jobs/{token}/tag',
                'operation_id': 'update_job_tag',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'token',
                    'tag',
                ],
                'required': [
                    'token',
                    'tag',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'tag',
                ]
            },
            root_map={
                'validations': {
                    ('tag',): {

                        'regex': {
                            'pattern': r'^.{0,255}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token':
                        (str,),
                    'tag':
                        (str,),
                },
                'attribute_map': {
                    'token': 'token',
                    'tag': 'tag',
                },
                'location_map': {
                    'token': 'path',
                    'tag': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def consume_stream_entry(
        self,
        token,
        entry_name,
        **kwargs
    ):
        """Flushes and returns the stream entry queue  # noqa: E501

        The job must belong to the logged in user, an invitee of the logged in user, or the logged in user must have admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.consume_stream_entry(token, entry_name, async_req=True)
        >>> result = thread.get()

        Args:
            token (str): Token of the job whose status is to be queried
            entry_name (str): Name of the text entry to be queried

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            StreamEntry
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['token'] = \
            token
        kwargs['entry_name'] = \
            entry_name
        return self.consume_stream_entry_endpoint.call_with_http_info(**kwargs)

    def create_job(
        self,
        model,
        namespace,
        **kwargs
    ):
        """Submits a new job to be solved  # noqa: E501

        Requires execute permission for registered models, requires write and execute permissions for unregistered models. When the disk or volume quota reaches 80%, quota_warning is included in the response.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_job(model, namespace, async_req=True)
        >>> result = thread.get()

        Args:
            model (str): Name of the model
            namespace (str): Namespace containing(or will contain) the model

        Keyword Args:
            run (str): Name of the main gms file with its extension. Will use model + '.gms' if not provided.. [optional]
            inex_string (str): Optional JSON string to filter the contents of the result zip file (inex_file takes precedence if specified). [optional]
            text_entries ([str]): [optional]
            stream_entries ([str]): [optional]
            stdout_filename (str): Name of the file that captures stdout. [optional] if omitted the server will use the default value of "log_stdout.txt"
            arguments ([str]): Arguments that will be passed to GAMS call. [optional]
            dep_tokens ([str]): Tokens of jobs on which this job depends. The order defines the order in which the results of dependent jobs are extracted.. [optional]
            labels ([str]): Labels that will be attached to the job in key=value. Currently supported labels are: cpu_request, memory_request, workspace_request, node_selectors, tolerations, instance. [optional]
            tag (str): Human-readable tag to assign to job (at most 255 characters). [optional]
            access_groups ([str]): Labels of user groups that should be able to access this job.. [optional]
            model_data (file_type): Zip file containing model files, if model is not registered. [optional]
            data (file_type): File containing data in zip. [optional]
            inex_file (file_type): Optional JSON file to filter the contents of the result zip file. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MessageAndToken
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['model'] = \
            model
        kwargs['namespace'] = \
            namespace
        return self.create_job_endpoint.call_with_http_info(**kwargs)

    def delete_job_zip(
        self,
        token,
        **kwargs
    ):
        """Deletes the job result and all the text entries  # noqa: E501

        The job must belong to the logged in user, an invitee of the logged in user, or the logged in user must have admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_job_zip(token, async_req=True)
        >>> result = thread.get()

        Args:
            token (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['token'] = \
            token
        return self.delete_job_zip_endpoint.call_with_http_info(**kwargs)

    def get_job(
        self,
        token,
        **kwargs
    ):
        """Returns the details of a job  # noqa: E501

        The job must belong to the logged in user, an invitee of the logged in user, or the logged in user must have admin role. `labels.resource_warning`, `labels.instance`, `labels.multiplier`, `access_groups` and `tag` fields are hidden by default for compatibility reasons, please use X-Fields header to get it. For example: X-Fields: \\*, labels{\\*}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job(token, async_req=True)
        >>> result = thread.get()

        Args:
            token (str):

        Keyword Args:
            x_fields (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Job
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['token'] = \
            token
        return self.get_job_endpoint.call_with_http_info(**kwargs)

    def get_job_text_entry(
        self,
        token,
        entry_name,
        **kwargs
    ):
        """Gets the value of a text entry  # noqa: E501

        Start position and length can be specified to get a partial text entry. The job must belong to the logged in user, an invitee of the logged in user, or the logged in user must have admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_text_entry(token, entry_name, async_req=True)
        >>> result = thread.get()

        Args:
            token (str): Token of the job whose status is to be queried
            entry_name (str): Name of the text entry to be queried

        Keyword Args:
            start_position (int): Start position of the substring. [optional] if omitted the server will use the default value of 1
            length (int): Number of chars you want to extract; if omitted, whole string is extracted. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TextEntry
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['token'] = \
            token
        kwargs['entry_name'] = \
            entry_name
        return self.get_job_text_entry_endpoint.call_with_http_info(**kwargs)

    def get_job_text_entry_info(
        self,
        token,
        entry_name,
        **kwargs
    ):
        """Returns the number of characters of the text entry  # noqa: E501

        The job must belong to the logged in user, an invitee of the logged in user, or the logged in user must have admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_text_entry_info(token, entry_name, async_req=True)
        >>> result = thread.get()

        Args:
            token (str): Token of the job whose status is to be queried
            entry_name (str): Name of the text entry to be queried

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['token'] = \
            token
        kwargs['entry_name'] = \
            entry_name
        return self.get_job_text_entry_info_endpoint.call_with_http_info(**kwargs)

    def get_job_zip(
        self,
        token,
        **kwargs
    ):
        """Downloads job result  # noqa: E501

        The job must belong to the logged in user, an invitee of the logged in user, or the logged in user must have admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_zip(token, async_req=True)
        >>> result = thread.get()

        Args:
            token (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['token'] = \
            token
        return self.get_job_zip_endpoint.call_with_http_info(**kwargs)

    def get_job_zip_info(
        self,
        token,
        **kwargs
    ):
        """Gets size and md5 hash of job result  # noqa: E501

        The job must belong to the logged in user, an invitee of the logged in user, or the logged in user must have admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_zip_info(token, async_req=True)
        >>> result = thread.get()

        Args:
            token (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['token'] = \
            token
        return self.get_job_zip_info_endpoint.call_with_http_info(**kwargs)

    def get_status_codes(
        self,
        **kwargs
    ):
        """Returns mapping of job status codes to human readable messages  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_status_codes(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            x_fields (str): An optional fields mask. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [StatusCodeMeaning]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_status_codes_endpoint.call_with_http_info(**kwargs)

    def kill_job(
        self,
        token,
        **kwargs
    ):
        """Sends interrupt signal to a job  # noqa: E501

        It has no effect if the job is finished. If the job is pending, worker will disregard the job when it receives the job. If the job is running, it will be terminated. The job must belong to the logged in user, an invitee of the logged in user, or the logged in user must have admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.kill_job(token, async_req=True)
        >>> result = thread.get()

        Args:
            token (str):

        Keyword Args:
            hard_kill (bool): Sends SIGKILL if true, SIGINT otherwise. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['token'] = \
            token
        return self.kill_job_endpoint.call_with_http_info(**kwargs)

    def list_jobs(
        self,
        **kwargs
    ):
        """Lists the jobs of the user unless `everyone` flag is set  # noqa: E501

        If user has admin role and `everyone` flag is set, all jobs are listed. If user is not inviter or admin and `everyone` flag is set, all visible jobs (jobs that were assigned to a user group that user is member of) are listed. If user is inviter and 'everyone' flag is set, jobs of all invitees will be listed additionally.  If `page` is not one and there are no elements at that page, throws 404.  `per_page` is zero by default and it indicates that you want all the values. If a non-zero value provided to `per_page`, result will be paginated by that `page_size`  if `show_only_active` set, submissions that are waiting, queued, running or cancelling will be returned.  The fields that are displayed by default are: `model`, `status`, `process_status`, `submitted_at`, `stdout_filename`, `namespace`, `token`, `finished_at` To see other fields, please use X-Fields accordingly. E.g `X-Fields: *` will show everything.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_jobs(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            everyone (bool): Can be set by admin/inviter; shows submissions of everyone/invitees. [optional]
            x_fields (str): [optional]
            page (int): [optional] if omitted the server will use the default value of 1
            per_page (int): [optional] if omitted the server will use the default value of 0
            order_by (str): [optional] if omitted the server will use the default value of "submitted_at"
            order_asc (bool): [optional] if omitted the server will use the default value of False
            show_only_active (bool): [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            JobNoTextEntryPage
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_jobs_endpoint.call_with_http_info(**kwargs)

    def pop_job_logs(
        self,
        token,
        **kwargs
    ):
        """Flushes and returns stdout of job  # noqa: E501

        The job must belong to the logged in user, an invitee of the logged in user, or the logged in user must have admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.pop_job_logs(token, async_req=True)
        >>> result = thread.get()

        Args:
            token (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            LogPiece
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['token'] = \
            token
        return self.pop_job_logs_endpoint.call_with_http_info(**kwargs)

    def pop_stream_entry(
        self,
        token,
        entry_name,
        **kwargs
    ):
        """Flushes and returns the stream entry queue  # noqa: E501

        The job must belong to the logged in user, an invitee of the logged in user, or the logged in user must have admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.pop_stream_entry(token, entry_name, async_req=True)
        >>> result = thread.get()

        Args:
            token (str): Token of the job whose status is to be queried
            entry_name (str): Name of the stream entry to be queried

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            StreamEntry
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['token'] = \
            token
        kwargs['entry_name'] = \
            entry_name
        return self.pop_stream_entry_endpoint.call_with_http_info(**kwargs)

    def query_job_text_entry(
        self,
        token,
        entry_name,
        **kwargs
    ):
        """Gets the value of a text entry  # noqa: E501

        Start position and length can be specified to get a partial text entry. The job must belong to the logged in user, an invitee of the logged in user, or the logged in user must have admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_job_text_entry(token, entry_name, async_req=True)
        >>> result = thread.get()

        Args:
            token (str): Token of the job whose status is to be queried
            entry_name (str): Name of the text entry to be queried

        Keyword Args:
            start_position (int): Start position of the substring. [optional] if omitted the server will use the default value of 1
            length (int): Number of chars you want to extract; if omitted, whole string is extracted. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TextEntry
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['token'] = \
            token
        kwargs['entry_name'] = \
            entry_name
        return self.query_job_text_entry_endpoint.call_with_http_info(**kwargs)

    def query_job_text_entry_info(
        self,
        token,
        entry_name,
        **kwargs
    ):
        """Returns the number of characters of the text entry  # noqa: E501

        The job must belong to the logged in user, an invitee of the logged in user, or the logged in user must have admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_job_text_entry_info(token, entry_name, async_req=True)
        >>> result = thread.get()

        Args:
            token (str): Token of the job whose status is to be queried
            entry_name (str): Name of the text entry to be queried

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['token'] = \
            token
        kwargs['entry_name'] = \
            entry_name
        return self.query_job_text_entry_info_endpoint.call_with_http_info(**kwargs)

    def update_job_access_groups(
        self,
        token,
        **kwargs
    ):
        """Update access groups that can access a job  # noqa: E501

        Can be queried via getJob endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_job_access_groups(token, async_req=True)
        >>> result = thread.get()

        Args:
            token (str):

        Keyword Args:
            access_groups ([str]): Labels of user groups that should be able to access this job.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['token'] = \
            token
        return self.update_job_access_groups_endpoint.call_with_http_info(**kwargs)

    def update_job_tag(
        self,
        token,
        tag,
        **kwargs
    ):
        """Update human-readable tag of a job  # noqa: E501

        Stored in `tag` field. Can be queried via getJob endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_job_tag(token, tag, async_req=True)
        >>> result = thread.get()

        Args:
            token (str):
            tag (str): Human-readable tag to assign to job (at most 255 characters)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['token'] = \
            token
        kwargs['tag'] = \
            tag
        return self.update_job_tag_endpoint.call_with_http_info(**kwargs)

