"""
    GAMS Engine

    With GAMS Engine you can register and solve GAMS models. It has a namespace management system, so you can restrict your users to certain models.  # noqa: E501

    The version of the OpenAPI document: latest
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from gams.engine.api_client import ApiClient, Endpoint as _Endpoint
from gams.engine.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from gams.engine.model.message import Message
from gams.engine.model.models import Models
from gams.engine.model.namespace import Namespace
from gams.engine.model.namespace_quota import NamespaceQuota
from gams.engine.model.namespace_with_permission import NamespaceWithPermission
from gams.engine.model.perm_and_username import PermAndUsername
from gams.engine.model.user_groups import UserGroups


class NamespacesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.add_user_to_group_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}/user-groups/{label}',
                'operation_id': 'add_user_to_group',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                    'label',
                    'username',
                ],
                'required': [
                    'namespace',
                    'label',
                    'username',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                    'label':
                        (str,),
                    'username':
                        (str,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                    'label': 'label',
                    'username': 'username',
                },
                'location_map': {
                    'namespace': 'path',
                    'label': 'path',
                    'username': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.create_model_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}/models/{model}',
                'operation_id': 'create_model',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                    'model',
                    'data',
                    'inex_string',
                    'arguments',
                    'text_entries',
                    'stream_entries',
                    'run',
                    'protect_model_files',
                    'user_groups',
                    'inex_file',
                ],
                'required': [
                    'namespace',
                    'model',
                    'data',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                    'model':
                        (str,),
                    'data':
                        (file_type,),
                    'inex_string':
                        (str,),
                    'arguments':
                        ([str],),
                    'text_entries':
                        ([str],),
                    'stream_entries':
                        ([str],),
                    'run':
                        (str,),
                    'protect_model_files':
                        (bool,),
                    'user_groups':
                        ([str],),
                    'inex_file':
                        (file_type,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                    'model': 'model',
                    'data': 'data',
                    'inex_string': 'inex_string',
                    'arguments': 'arguments',
                    'text_entries': 'text_entries',
                    'stream_entries': 'stream_entries',
                    'run': 'run',
                    'protect_model_files': 'protect_model_files',
                    'user_groups': 'user_groups',
                    'inex_file': 'inex_file',
                },
                'location_map': {
                    'namespace': 'path',
                    'model': 'path',
                    'data': 'form',
                    'inex_string': 'query',
                    'arguments': 'query',
                    'text_entries': 'query',
                    'stream_entries': 'query',
                    'run': 'query',
                    'protect_model_files': 'query',
                    'user_groups': 'query',
                    'inex_file': 'form',
                },
                'collection_format_map': {
                    'arguments': 'multi',
                    'text_entries': 'multi',
                    'stream_entries': 'multi',
                    'user_groups': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.create_model_deprecated_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}/{model}',
                'operation_id': 'create_model_deprecated',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                    'model',
                    'data',
                    'inex_string',
                    'arguments',
                    'text_entries',
                    'stream_entries',
                    'run',
                    'protect_model_files',
                    'user_groups',
                    'inex_file',
                ],
                'required': [
                    'namespace',
                    'model',
                    'data',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                    'model':
                        (str,),
                    'data':
                        (file_type,),
                    'inex_string':
                        (str,),
                    'arguments':
                        ([str],),
                    'text_entries':
                        ([str],),
                    'stream_entries':
                        ([str],),
                    'run':
                        (str,),
                    'protect_model_files':
                        (bool,),
                    'user_groups':
                        ([str],),
                    'inex_file':
                        (file_type,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                    'model': 'model',
                    'data': 'data',
                    'inex_string': 'inex_string',
                    'arguments': 'arguments',
                    'text_entries': 'text_entries',
                    'stream_entries': 'stream_entries',
                    'run': 'run',
                    'protect_model_files': 'protect_model_files',
                    'user_groups': 'user_groups',
                    'inex_file': 'inex_file',
                },
                'location_map': {
                    'namespace': 'path',
                    'model': 'path',
                    'data': 'form',
                    'inex_string': 'query',
                    'arguments': 'query',
                    'text_entries': 'query',
                    'stream_entries': 'query',
                    'run': 'query',
                    'protect_model_files': 'query',
                    'user_groups': 'query',
                    'inex_file': 'form',
                },
                'collection_format_map': {
                    'arguments': 'multi',
                    'text_entries': 'multi',
                    'stream_entries': 'multi',
                    'user_groups': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.create_namespace_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}',
                'operation_id': 'create_namespace',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                    'disk_quota',
                ],
                'required': [
                    'namespace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'disk_quota',
                ]
            },
            root_map={
                'validations': {
                    ('disk_quota',): {

                        'exclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                    'disk_quota':
                        (int,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                    'disk_quota': 'disk_quota',
                },
                'location_map': {
                    'namespace': 'path',
                    'disk_quota': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.create_user_group_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}/user-groups',
                'operation_id': 'create_user_group',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                    'label',
                ],
                'required': [
                    'namespace',
                    'label',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'label',
                ]
            },
            root_map={
                'validations': {
                    ('label',): {

                        'regex': {
                            'pattern': r'^[a-zA-Z0-9_]{4,70}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                    'label':
                        (str,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                    'label': 'label',
                },
                'location_map': {
                    'namespace': 'path',
                    'label': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.delete_model_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}/models/{model}',
                'operation_id': 'delete_model',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                    'model',
                ],
                'required': [
                    'namespace',
                    'model',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                    'model':
                        (str,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                    'model': 'model',
                },
                'location_map': {
                    'namespace': 'path',
                    'model': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_model_deprecated_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}/{model}',
                'operation_id': 'delete_model_deprecated',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                    'model',
                ],
                'required': [
                    'namespace',
                    'model',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                    'model':
                        (str,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                    'model': 'model',
                },
                'location_map': {
                    'namespace': 'path',
                    'model': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_namespace_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}',
                'operation_id': 'delete_namespace',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                ],
                'required': [
                    'namespace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                },
                'location_map': {
                    'namespace': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_namespace_quota_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}/disk-quota',
                'operation_id': 'delete_namespace_quota',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                ],
                'required': [
                    'namespace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                },
                'location_map': {
                    'namespace': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_user_group_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}/user-groups',
                'operation_id': 'delete_user_group',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                    'label',
                ],
                'required': [
                    'namespace',
                    'label',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'label',
                ]
            },
            root_map={
                'validations': {
                    ('label',): {

                        'regex': {
                            'pattern': r'^[a-zA-Z0-9_]{4,70}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                    'label':
                        (str,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                    'label': 'label',
                },
                'location_map': {
                    'namespace': 'path',
                    'label': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_accessible_namespaces_endpoint = _Endpoint(
            settings={
                'response_type': ([NamespaceWithPermission],),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/permissions/me',
                'operation_id': 'get_accessible_namespaces',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_model_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}/models/{model}',
                'operation_id': 'get_model',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                    'model',
                ],
                'required': [
                    'namespace',
                    'model',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                    'model':
                        (str,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                    'model': 'model',
                },
                'location_map': {
                    'namespace': 'path',
                    'model': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_model_deprecated_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}/{model}',
                'operation_id': 'get_model_deprecated',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                    'model',
                ],
                'required': [
                    'namespace',
                    'model',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                    'model':
                        (str,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                    'model': 'model',
                },
                'location_map': {
                    'namespace': 'path',
                    'model': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_my_permissions_endpoint = _Endpoint(
            settings={
                'response_type': (PermAndUsername,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}/permissions/me',
                'operation_id': 'get_my_permissions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                ],
                'required': [
                    'namespace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                },
                'location_map': {
                    'namespace': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_namespace_quota_endpoint = _Endpoint(
            settings={
                'response_type': (NamespaceQuota,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}/disk-quota',
                'operation_id': 'get_namespace_quota',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                ],
                'required': [
                    'namespace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                },
                'location_map': {
                    'namespace': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_user_groups_endpoint = _Endpoint(
            settings={
                'response_type': ([UserGroups],),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}/user-groups',
                'operation_id': 'get_user_groups',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                ],
                'required': [
                    'namespace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                },
                'location_map': {
                    'namespace': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_user_permission_endpoint = _Endpoint(
            settings={
                'response_type': (PermAndUsername,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}/permissions',
                'operation_id': 'get_user_permission',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                    'username',
                ],
                'required': [
                    'namespace',
                    'username',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                    'username':
                        (str,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                    'username': 'username',
                },
                'location_map': {
                    'namespace': 'path',
                    'username': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_models_endpoint = _Endpoint(
            settings={
                'response_type': ([Models],),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}',
                'operation_id': 'list_models',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                    'x_fields',
                    'model',
                ],
                'required': [
                    'namespace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                    'x_fields':
                        (str,),
                    'model':
                        (str,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                    'x_fields': 'X-Fields',
                    'model': 'model',
                },
                'location_map': {
                    'namespace': 'path',
                    'x_fields': 'header',
                    'model': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_namespaces_endpoint = _Endpoint(
            settings={
                'response_type': ([Namespace],),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/',
                'operation_id': 'list_namespaces',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.remove_user_from_group_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}/user-groups/{label}',
                'operation_id': 'remove_user_from_group',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                    'label',
                    'username',
                ],
                'required': [
                    'namespace',
                    'label',
                    'username',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                    'label':
                        (str,),
                    'username':
                        (str,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                    'label': 'label',
                    'username': 'username',
                },
                'location_map': {
                    'namespace': 'path',
                    'label': 'path',
                    'username': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.replace_user_permission_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}/permissions',
                'operation_id': 'replace_user_permission',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                    'username',
                    'permissions',
                ],
                'required': [
                    'namespace',
                    'username',
                    'permissions',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'permissions',
                ]
            },
            root_map={
                'validations': {
                    ('permissions',): {

                        'inclusive_maximum': 7,
                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                    'username':
                        (str,),
                    'permissions':
                        (int,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                    'username': 'username',
                    'permissions': 'permissions',
                },
                'location_map': {
                    'namespace': 'path',
                    'username': 'form',
                    'permissions': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.update_model_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}/models/{model}',
                'operation_id': 'update_model',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                    'model',
                    'inex_string',
                    'arguments',
                    'run',
                    'protect_model_files',
                    'user_groups',
                    'text_entries',
                    'stream_entries',
                    'delete_inex_file',
                    'delete_arguments',
                    'delete_run',
                    'delete_user_groups',
                    'delete_text_entries',
                    'delete_stream_entries',
                    'data',
                    'inex_file',
                ],
                'required': [
                    'namespace',
                    'model',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                    'model':
                        (str,),
                    'inex_string':
                        (str,),
                    'arguments':
                        ([str],),
                    'run':
                        (str,),
                    'protect_model_files':
                        (bool,),
                    'user_groups':
                        ([str],),
                    'text_entries':
                        ([str],),
                    'stream_entries':
                        ([str],),
                    'delete_inex_file':
                        (bool,),
                    'delete_arguments':
                        (bool,),
                    'delete_run':
                        (bool,),
                    'delete_user_groups':
                        (bool,),
                    'delete_text_entries':
                        (bool,),
                    'delete_stream_entries':
                        (bool,),
                    'data':
                        (file_type,),
                    'inex_file':
                        (file_type,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                    'model': 'model',
                    'inex_string': 'inex_string',
                    'arguments': 'arguments',
                    'run': 'run',
                    'protect_model_files': 'protect_model_files',
                    'user_groups': 'user_groups',
                    'text_entries': 'text_entries',
                    'stream_entries': 'stream_entries',
                    'delete_inex_file': 'delete_inex_file',
                    'delete_arguments': 'delete_arguments',
                    'delete_run': 'delete_run',
                    'delete_user_groups': 'delete_user_groups',
                    'delete_text_entries': 'delete_text_entries',
                    'delete_stream_entries': 'delete_stream_entries',
                    'data': 'data',
                    'inex_file': 'inex_file',
                },
                'location_map': {
                    'namespace': 'path',
                    'model': 'path',
                    'inex_string': 'query',
                    'arguments': 'query',
                    'run': 'query',
                    'protect_model_files': 'query',
                    'user_groups': 'query',
                    'text_entries': 'query',
                    'stream_entries': 'query',
                    'delete_inex_file': 'query',
                    'delete_arguments': 'query',
                    'delete_run': 'query',
                    'delete_user_groups': 'query',
                    'delete_text_entries': 'query',
                    'delete_stream_entries': 'query',
                    'data': 'form',
                    'inex_file': 'form',
                },
                'collection_format_map': {
                    'arguments': 'multi',
                    'user_groups': 'multi',
                    'text_entries': 'multi',
                    'stream_entries': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.update_model_deprecated_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}/{model}',
                'operation_id': 'update_model_deprecated',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                    'model',
                    'inex_string',
                    'arguments',
                    'run',
                    'protect_model_files',
                    'user_groups',
                    'text_entries',
                    'stream_entries',
                    'delete_inex_file',
                    'delete_arguments',
                    'delete_run',
                    'delete_user_groups',
                    'delete_text_entries',
                    'delete_stream_entries',
                    'data',
                    'inex_file',
                ],
                'required': [
                    'namespace',
                    'model',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                    'model':
                        (str,),
                    'inex_string':
                        (str,),
                    'arguments':
                        ([str],),
                    'run':
                        (str,),
                    'protect_model_files':
                        (bool,),
                    'user_groups':
                        ([str],),
                    'text_entries':
                        ([str],),
                    'stream_entries':
                        ([str],),
                    'delete_inex_file':
                        (bool,),
                    'delete_arguments':
                        (bool,),
                    'delete_run':
                        (bool,),
                    'delete_user_groups':
                        (bool,),
                    'delete_text_entries':
                        (bool,),
                    'delete_stream_entries':
                        (bool,),
                    'data':
                        (file_type,),
                    'inex_file':
                        (file_type,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                    'model': 'model',
                    'inex_string': 'inex_string',
                    'arguments': 'arguments',
                    'run': 'run',
                    'protect_model_files': 'protect_model_files',
                    'user_groups': 'user_groups',
                    'text_entries': 'text_entries',
                    'stream_entries': 'stream_entries',
                    'delete_inex_file': 'delete_inex_file',
                    'delete_arguments': 'delete_arguments',
                    'delete_run': 'delete_run',
                    'delete_user_groups': 'delete_user_groups',
                    'delete_text_entries': 'delete_text_entries',
                    'delete_stream_entries': 'delete_stream_entries',
                    'data': 'data',
                    'inex_file': 'inex_file',
                },
                'location_map': {
                    'namespace': 'path',
                    'model': 'path',
                    'inex_string': 'query',
                    'arguments': 'query',
                    'run': 'query',
                    'protect_model_files': 'query',
                    'user_groups': 'query',
                    'text_entries': 'query',
                    'stream_entries': 'query',
                    'delete_inex_file': 'query',
                    'delete_arguments': 'query',
                    'delete_run': 'query',
                    'delete_user_groups': 'query',
                    'delete_text_entries': 'query',
                    'delete_stream_entries': 'query',
                    'data': 'form',
                    'inex_file': 'form',
                },
                'collection_format_map': {
                    'arguments': 'multi',
                    'user_groups': 'multi',
                    'text_entries': 'multi',
                    'stream_entries': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.update_namespace_quota_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/namespaces/{namespace}/disk-quota',
                'operation_id': 'update_namespace_quota',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace',
                    'disk_quota',
                ],
                'required': [
                    'namespace',
                    'disk_quota',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'disk_quota',
                ]
            },
            root_map={
                'validations': {
                    ('disk_quota',): {

                        'exclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace':
                        (str,),
                    'disk_quota':
                        (int,),
                },
                'attribute_map': {
                    'namespace': 'namespace',
                    'disk_quota': 'disk_quota',
                },
                'location_map': {
                    'namespace': 'path',
                    'disk_quota': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )

    def add_user_to_group(
        self,
        namespace,
        label,
        username,
        **kwargs
    ):
        """Adds a user to a group  # noqa: E501

        Inviters can add any invitees to a group they are a member of or that belongs to an invitee. Admins can add anyone to any group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_user_to_group(namespace, label, username, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):
            label (str):
            username (str): Username to add

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        kwargs['label'] = \
            label
        kwargs['username'] = \
            username
        return self.add_user_to_group_endpoint.call_with_http_info(**kwargs)

    def create_model(
        self,
        namespace,
        model,
        data,
        **kwargs
    ):
        """Registers a new model in the given namespace  # noqa: E501

        Requires write permission.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_model(namespace, model, data, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):
            model (str):
            data (file_type): Zip file containing files of model

        Keyword Args:
            inex_string (str): JSON string that describes which files will be included/excluded from results archive (if provided, inex_file takes precendence). [optional]
            arguments ([str]): Arguments that will be passed to GAMS call. [optional]
            text_entries ([str]): Files to store as text entries. [optional]
            stream_entries ([str]): Files to stream during execution. [optional]
            run (str): Main GMS file to run, please include file extension as well. Will use model + '.gms' if not provided.. [optional]
            protect_model_files (bool): Whether to protect model files from being overwritten by data files.. [optional]
            user_groups ([str]): Restrict access to specific user groups. [optional]
            inex_file (file_type): JSON file that describes which files will be included/excluded from results archive. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        kwargs['model'] = \
            model
        kwargs['data'] = \
            data
        return self.create_model_endpoint.call_with_http_info(**kwargs)

    def create_model_deprecated(
        self,
        namespace,
        model,
        data,
        **kwargs
    ):
        """Registers a new model in the given namespace  # noqa: E501

        Requires write permission.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_model_deprecated(namespace, model, data, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):
            model (str):
            data (file_type): Zip file containing files of model

        Keyword Args:
            inex_string (str): JSON string that describes which files will be included/excluded from results archive (if provided, inex_file takes precendence). [optional]
            arguments ([str]): Arguments that will be passed to GAMS call. [optional]
            text_entries ([str]): Files to store as text entries. [optional]
            stream_entries ([str]): Files to stream during execution. [optional]
            run (str): Main GMS file to run, please include file extension as well. Will use model + '.gms' if not provided.. [optional]
            protect_model_files (bool): Whether to protect model files from being overwritten by data files.. [optional]
            user_groups ([str]): Restrict access to specific user groups. [optional]
            inex_file (file_type): JSON file that describes which files will be included/excluded from results archive. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        kwargs['model'] = \
            model
        kwargs['data'] = \
            data
        return self.create_model_deprecated_endpoint.call_with_http_info(**kwargs)

    def create_namespace(
        self,
        namespace,
        **kwargs
    ):
        """Creates a namespace  # noqa: E501

        Requires admin role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_namespace(namespace, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):

        Keyword Args:
            disk_quota (int): disk quota in bytes. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        return self.create_namespace_endpoint.call_with_http_info(**kwargs)

    def create_user_group(
        self,
        namespace,
        label,
        **kwargs
    ):
        """Creates a new user group  # noqa: E501

        Requires admin role or inviter role with write permissions on the namespace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_user_group(namespace, label, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):
            label (str): Group label

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        kwargs['label'] = \
            label
        return self.create_user_group_endpoint.call_with_http_info(**kwargs)

    def delete_model(
        self,
        namespace,
        model,
        **kwargs
    ):
        """Deletes a model registered in the namespace  # noqa: E501

        Requires write permission.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_model(namespace, model, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):
            model (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        kwargs['model'] = \
            model
        return self.delete_model_endpoint.call_with_http_info(**kwargs)

    def delete_model_deprecated(
        self,
        namespace,
        model,
        **kwargs
    ):
        """Deletes a model registered in the namespace  # noqa: E501

        Requires write permission.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_model_deprecated(namespace, model, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):
            model (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        kwargs['model'] = \
            model
        return self.delete_model_deprecated_endpoint.call_with_http_info(**kwargs)

    def delete_namespace(
        self,
        namespace,
        **kwargs
    ):
        """Deletes a namespace  # noqa: E501

        Models, permissions and results assigned to this namespace are deleted. If jobs are running in this namespace, they are aborted. Requires admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_namespace(namespace, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        return self.delete_namespace_endpoint.call_with_http_info(**kwargs)

    def delete_namespace_quota(
        self,
        namespace,
        **kwargs
    ):
        """Deletes namespace disk quota  # noqa: E501

        Requires admin role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_namespace_quota(namespace, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        return self.delete_namespace_quota_endpoint.call_with_http_info(**kwargs)

    def delete_user_group(
        self,
        namespace,
        label,
        **kwargs
    ):
        """Deletes a user group  # noqa: E501

        Inviters with write permission to the namespace can delete their own groups as well as the groups of any invitees. Admins can delete any group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_user_group(namespace, label, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):
            label (str): Group label

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        kwargs['label'] = \
            label
        return self.delete_user_group_endpoint.call_with_http_info(**kwargs)

    def get_accessible_namespaces(
        self,
        **kwargs
    ):
        """Lists the namespaces where the user has a non-zero permission, along with that `permission` and `disk_quota`  # noqa: E501

        If the user does not have write permission, then the `disk_quota` is None. If the user has write permission but `disk_quota` is still None, it means namespace does not have any disk quota.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_accessible_namespaces(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [NamespaceWithPermission]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_accessible_namespaces_endpoint.call_with_http_info(**kwargs)

    def get_model(
        self,
        namespace,
        model,
        **kwargs
    ):
        """Downloads model data  # noqa: E501

        Requires read permission.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_model(namespace, model, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):
            model (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        kwargs['model'] = \
            model
        return self.get_model_endpoint.call_with_http_info(**kwargs)

    def get_model_deprecated(
        self,
        namespace,
        model,
        **kwargs
    ):
        """Downloads model data  # noqa: E501

        Requires read permission.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_model_deprecated(namespace, model, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):
            model (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        kwargs['model'] = \
            model
        return self.get_model_deprecated_endpoint.call_with_http_info(**kwargs)

    def get_my_permissions(
        self,
        namespace,
        **kwargs
    ):
        """Returns the permissions of the logged in user in the given namespace  # noqa: E501

        If user has admin role, it always returns 7.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_my_permissions(namespace, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PermAndUsername
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        return self.get_my_permissions_endpoint.call_with_http_info(**kwargs)

    def get_namespace_quota(
        self,
        namespace,
        **kwargs
    ):
        """Displays namespace disk quota  # noqa: E501

        Requires write permission  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_namespace_quota(namespace, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            NamespaceQuota
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        return self.get_namespace_quota_endpoint.call_with_http_info(**kwargs)

    def get_user_groups(
        self,
        namespace,
        **kwargs
    ):
        """Fetches user groups  # noqa: E501

        If user, fetches groups in which the user is a member. If inviter, fetches groups the inviter is a member of, as well as all groups of invitees. If admin, fetches all groups.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_groups(namespace, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [UserGroups]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        return self.get_user_groups_endpoint.call_with_http_info(**kwargs)

    def get_user_permission(
        self,
        namespace,
        username,
        **kwargs
    ):
        """Gets permissions of the given user for the given namespace  # noqa: E501

        Admins can query all users, inviters can only query the invitees. Users can query themselves.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_permission(namespace, username, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):
            username (str): Username

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PermAndUsername
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        kwargs['username'] = \
            username
        return self.get_user_permission_endpoint.call_with_http_info(**kwargs)

    def list_models(
        self,
        namespace,
        **kwargs
    ):
        """Lists the models in a namespace  # noqa: E501

        If the model argument is specified, the information about this model is displayed only if the model is registered in the namespace. Models that are not assigned to a user group are visible to anyone with any permission (read, write, and/or execute) in the namespace. Models assigned to one or more user groups are only visible if the user can see any of these user groups. `protect_model_files` field is hidden by default for compatibility reasons, please use X-Fields header to get it. For example: X-Fields: \\*  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_models(namespace, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):

        Keyword Args:
            x_fields (str): [optional]
            model (str): Name of the model to filter. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Models]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        return self.list_models_endpoint.call_with_http_info(**kwargs)

    def list_namespaces(
        self,
        **kwargs
    ):
        """Lists the namespaces  # noqa: E501

        You must have some permission on namespace to see it. Admins can see every namespace and every permission. Inviters can see namespaces for which they have permission, as well as the permissions of invitees. Users can see namespaces in which they have permissions, as well as the permissions for themselves.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_namespaces(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Namespace]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_namespaces_endpoint.call_with_http_info(**kwargs)

    def remove_user_from_group(
        self,
        namespace,
        label,
        username,
        **kwargs
    ):
        """Removes a user from a group  # noqa: E501

        Inviters can remove any invitees from a group they are a member of or that belongs to an invitee. Admins can remove anyone from any group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_user_from_group(namespace, label, username, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):
            label (str):
            username (str): Username to remove

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        kwargs['label'] = \
            label
        kwargs['username'] = \
            username
        return self.remove_user_from_group_endpoint.call_with_http_info(**kwargs)

    def replace_user_permission(
        self,
        namespace,
        username,
        permissions,
        **kwargs
    ):
        """Sets permissions of the given user for the given namespace  # noqa: E501

        Admins can grant all permissions, inviting persons can only grant the permissions they have. Requires admin or inviter role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.replace_user_permission(namespace, username, permissions, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):
            username (str): Username
            permissions (int): 4 - Read access to namespace 2 - Write access to namespace(delete, update, create) 1 - Execute model access to namespace  Sum to calculate permission

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        kwargs['username'] = \
            username
        kwargs['permissions'] = \
            permissions
        return self.replace_user_permission_endpoint.call_with_http_info(**kwargs)

    def update_model(
        self,
        namespace,
        model,
        **kwargs
    ):
        """Partially update registered models  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_model(namespace, model, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):
            model (str):

        Keyword Args:
            inex_string (str): JSON string that describes which files will be included/excluded from results archive (if provided, inex_file takes precendence). [optional]
            arguments ([str]): Arguments that will be passed to GAMS call. [optional]
            run (str): Main GMS file to run, please include file extension as well. Will use model + '.gms' if not provided.. [optional]
            protect_model_files (bool): Whether to protect model files from being overwritten by data files.. [optional]
            user_groups ([str]): Restrict access to specific user groups. [optional]
            text_entries ([str]): Files to store as text entries. [optional]
            stream_entries ([str]): Files to stream during execution. [optional]
            delete_inex_file (bool): If `inex_file` is provided, setting this throws error, otherwise setting this to true deletes the inex file. [optional] if omitted the server will use the default value of False
            delete_arguments (bool): If `arguments` is provided, setting this throws error, otherwise setting this deletes the arguments. [optional] if omitted the server will use the default value of False
            delete_run (bool): If `run` is provided, setting this throws error, otherwise setting this to true deletes the run filename. [optional] if omitted the server will use the default value of False
            delete_user_groups (bool): If `user_groups` is provided, setting this throws error, otherwise setting this deletes the user groups. [optional] if omitted the server will use the default value of False
            delete_text_entries (bool): If `text_entries` is provided, setting this throws error, otherwise setting this deletes the text entries. [optional] if omitted the server will use the default value of False
            delete_stream_entries (bool): If `stream_entries` is provided, setting this throws error, otherwise setting this deletes the stream entries. [optional] if omitted the server will use the default value of False
            data (file_type): Zip file containing files of model. [optional]
            inex_file (file_type): JSON file that describes which files will be included/excluded from results archive. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        kwargs['model'] = \
            model
        return self.update_model_endpoint.call_with_http_info(**kwargs)

    def update_model_deprecated(
        self,
        namespace,
        model,
        **kwargs
    ):
        """Partially update registered models  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_model_deprecated(namespace, model, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):
            model (str):

        Keyword Args:
            inex_string (str): JSON string that describes which files will be included/excluded from results archive (if provided, inex_file takes precendence). [optional]
            arguments ([str]): Arguments that will be passed to GAMS call. [optional]
            run (str): Main GMS file to run, please include file extension as well. Will use model + '.gms' if not provided.. [optional]
            protect_model_files (bool): Whether to protect model files from being overwritten by data files.. [optional]
            user_groups ([str]): Restrict access to specific user groups. [optional]
            text_entries ([str]): Files to store as text entries. [optional]
            stream_entries ([str]): Files to stream during execution. [optional]
            delete_inex_file (bool): If `inex_file` is provided, setting this throws error, otherwise setting this to true deletes the inex file. [optional] if omitted the server will use the default value of False
            delete_arguments (bool): If `arguments` is provided, setting this throws error, otherwise setting this deletes the arguments. [optional] if omitted the server will use the default value of False
            delete_run (bool): If `run` is provided, setting this throws error, otherwise setting this to true deletes the run filename. [optional] if omitted the server will use the default value of False
            delete_user_groups (bool): If `user_groups` is provided, setting this throws error, otherwise setting this deletes the user groups. [optional] if omitted the server will use the default value of False
            delete_text_entries (bool): If `text_entries` is provided, setting this throws error, otherwise setting this deletes the text entries. [optional] if omitted the server will use the default value of False
            delete_stream_entries (bool): If `stream_entries` is provided, setting this throws error, otherwise setting this deletes the stream entries. [optional] if omitted the server will use the default value of False
            data (file_type): Zip file containing files of model. [optional]
            inex_file (file_type): JSON file that describes which files will be included/excluded from results archive. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        kwargs['model'] = \
            model
        return self.update_model_deprecated_endpoint.call_with_http_info(**kwargs)

    def update_namespace_quota(
        self,
        namespace,
        disk_quota=1000000000,
        **kwargs
    ):
        """Updates namespace disk quota  # noqa: E501

        Requires admin role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_namespace_quota(namespace, disk_quota=1000000000, async_req=True)
        >>> result = thread.get()

        Args:
            namespace (str):
            disk_quota (int): disk quota in bytes. defaults to 1000000000, must be one of [1000000000]

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['namespace'] = \
            namespace
        kwargs['disk_quota'] = \
            disk_quota
        return self.update_namespace_quota_endpoint.call_with_http_info(**kwargs)

