"""
    GAMS Engine

    With GAMS Engine you can register and solve GAMS models. It has a namespace management system, so you can restrict your users to certain models.  # noqa: E501

    The version of the OpenAPI document: latest
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from gams.engine.api_client import ApiClient, Endpoint as _Endpoint
from gams.engine.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from gams.engine.model.message import Message
from gams.engine.model.model_instance_info_full import ModelInstanceInfoFull
from gams.engine.model.model_usage import ModelUsage
from gams.engine.model.model_userinstance_info import ModelUserinstanceInfo
from gams.engine.model.quota import Quota


class UsageApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_instance_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/usage/instances',
                'operation_id': 'create_instance',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'label',
                    'cpu_request',
                    'memory_request',
                    'multiplier',
                    'workspace_request',
                    'tolerations',
                    'node_selectors',
                    'gams_license',
                ],
                'required': [
                    'label',
                    'cpu_request',
                    'memory_request',
                    'multiplier',
                    'workspace_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'label',
                    'cpu_request',
                    'memory_request',
                    'multiplier',
                    'workspace_request',
                    'gams_license',
                ]
            },
            root_map={
                'validations': {
                    ('label',): {
                        'max_length': 30,
                        'min_length': 1,
                    },
                    ('cpu_request',): {

                        'inclusive_minimum': 0,
                    },
                    ('memory_request',): {

                        'exclusive_minimum': 0,
                    },
                    ('multiplier',): {

                        'inclusive_minimum': 0,
                    },
                    ('workspace_request',): {

                        'inclusive_maximum': 1000000,
                        'inclusive_minimum': 100,
                    },
                    ('gams_license',): {
                        'max_length': 1000,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'label':
                        (str,),
                    'cpu_request':
                        (float,),
                    'memory_request':
                        (int,),
                    'multiplier':
                        (float,),
                    'workspace_request':
                        (int,),
                    'tolerations':
                        ([str],),
                    'node_selectors':
                        ([str],),
                    'gams_license':
                        (str,),
                },
                'attribute_map': {
                    'label': 'label',
                    'cpu_request': 'cpu_request',
                    'memory_request': 'memory_request',
                    'multiplier': 'multiplier',
                    'workspace_request': 'workspace_request',
                    'tolerations': 'tolerations',
                    'node_selectors': 'node_selectors',
                    'gams_license': 'gams_license',
                },
                'location_map': {
                    'label': 'form',
                    'cpu_request': 'form',
                    'memory_request': 'form',
                    'multiplier': 'form',
                    'workspace_request': 'form',
                    'tolerations': 'form',
                    'node_selectors': 'form',
                    'gams_license': 'form',
                },
                'collection_format_map': {
                    'tolerations': 'csv',
                    'node_selectors': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.delete_instance_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/usage/instances',
                'operation_id': 'delete_instance',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'label',
                ],
                'required': [
                    'label',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'label',
                ]
            },
            root_map={
                'validations': {
                    ('label',): {
                        'max_length': 30,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'label':
                        (str,),
                },
                'attribute_map': {
                    'label': 'label',
                },
                'location_map': {
                    'label': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_quota_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/usage/quota',
                'operation_id': 'delete_quota',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'username',
                    'field',
                ],
                'required': [
                    'username',
                ],
                'nullable': [
                ],
                'enum': [
                    'field',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('field',): {

                        "VOLUME_QUOTA": "volume_quota",
                        "PARALLEL_QUOTA": "parallel_quota",
                        "DISK_QUOTA": "disk_quota"
                    },
                },
                'openapi_types': {
                    'username':
                        (str,),
                    'field':
                        (str,),
                },
                'attribute_map': {
                    'username': 'username',
                    'field': 'field',
                },
                'location_map': {
                    'username': 'query',
                    'field': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_user_instances_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/usage/instances/{username}',
                'operation_id': 'delete_user_instances',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'username',
                ],
                'required': [
                    'username',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'username':
                        (str,),
                },
                'attribute_map': {
                    'username': 'username',
                },
                'location_map': {
                    'username': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_instances_endpoint = _Endpoint(
            settings={
                'response_type': ([ModelInstanceInfoFull],),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/usage/instances',
                'operation_id': 'get_instances',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_quota_endpoint = _Endpoint(
            settings={
                'response_type': ([Quota],),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/usage/quota',
                'operation_id': 'get_quota',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'username',
                ],
                'required': [
                    'username',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'username':
                        (str,),
                },
                'attribute_map': {
                    'username': 'username',
                },
                'location_map': {
                    'username': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_usage_endpoint = _Endpoint(
            settings={
                'response_type': (ModelUsage,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/usage/',
                'operation_id': 'get_usage',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'username',
                    'recursive',
                    'from_datetime',
                    'to_datetime',
                    'x_fields',
                    'token',
                    'hypercube_token',
                ],
                'required': [
                    'username',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'username':
                        (str,),
                    'recursive':
                        (bool,),
                    'from_datetime':
                        (datetime,),
                    'to_datetime':
                        (datetime,),
                    'x_fields':
                        (str,),
                    'token':
                        ([str],),
                    'hypercube_token':
                        ([str],),
                },
                'attribute_map': {
                    'username': 'username',
                    'recursive': 'recursive',
                    'from_datetime': 'from_datetime',
                    'to_datetime': 'to_datetime',
                    'x_fields': 'X-Fields',
                    'token': 'token',
                    'hypercube_token': 'hypercube_token',
                },
                'location_map': {
                    'username': 'query',
                    'recursive': 'query',
                    'from_datetime': 'query',
                    'to_datetime': 'query',
                    'x_fields': 'header',
                    'token': 'query',
                    'hypercube_token': 'query',
                },
                'collection_format_map': {
                    'token': 'multi',
                    'hypercube_token': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_user_instances_endpoint = _Endpoint(
            settings={
                'response_type': (ModelUserinstanceInfo,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/usage/instances/{username}',
                'operation_id': 'get_user_instances',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'username',
                ],
                'required': [
                    'username',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'username':
                        (str,),
                },
                'attribute_map': {
                    'username': 'username',
                },
                'location_map': {
                    'username': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_instance_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/usage/instances',
                'operation_id': 'update_instance',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'label',
                    'cpu_request',
                    'memory_request',
                    'multiplier',
                    'workspace_request',
                    'old_label',
                    'tolerations',
                    'node_selectors',
                    'gams_license',
                ],
                'required': [
                    'label',
                    'cpu_request',
                    'memory_request',
                    'multiplier',
                    'workspace_request',
                    'old_label',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'label',
                    'cpu_request',
                    'memory_request',
                    'multiplier',
                    'workspace_request',
                    'old_label',
                    'gams_license',
                ]
            },
            root_map={
                'validations': {
                    ('label',): {
                        'max_length': 30,
                        'min_length': 1,
                    },
                    ('cpu_request',): {

                        'inclusive_minimum': 0,
                    },
                    ('memory_request',): {

                        'exclusive_minimum': 0,
                    },
                    ('multiplier',): {

                        'inclusive_minimum': 0,
                    },
                    ('workspace_request',): {

                        'inclusive_maximum': 1000000,
                        'inclusive_minimum': 100,
                    },
                    ('old_label',): {
                        'max_length': 30,
                        'min_length': 1,
                    },
                    ('gams_license',): {
                        'max_length': 1000,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'label':
                        (str,),
                    'cpu_request':
                        (float,),
                    'memory_request':
                        (int,),
                    'multiplier':
                        (float,),
                    'workspace_request':
                        (int,),
                    'old_label':
                        (str,),
                    'tolerations':
                        ([str],),
                    'node_selectors':
                        ([str],),
                    'gams_license':
                        (str,),
                },
                'attribute_map': {
                    'label': 'label',
                    'cpu_request': 'cpu_request',
                    'memory_request': 'memory_request',
                    'multiplier': 'multiplier',
                    'workspace_request': 'workspace_request',
                    'old_label': 'old_label',
                    'tolerations': 'tolerations',
                    'node_selectors': 'node_selectors',
                    'gams_license': 'gams_license',
                },
                'location_map': {
                    'label': 'form',
                    'cpu_request': 'form',
                    'memory_request': 'form',
                    'multiplier': 'form',
                    'workspace_request': 'form',
                    'old_label': 'form',
                    'tolerations': 'form',
                    'node_selectors': 'form',
                    'gams_license': 'form',
                },
                'collection_format_map': {
                    'tolerations': 'csv',
                    'node_selectors': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.update_quota_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/usage/quota',
                'operation_id': 'update_quota',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'username',
                    'parallel_quota',
                    'volume_quota',
                    'disk_quota',
                ],
                'required': [
                    'username',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'parallel_quota',
                    'volume_quota',
                    'disk_quota',
                ]
            },
            root_map={
                'validations': {
                    ('parallel_quota',): {

                        'inclusive_minimum': 0,
                    },
                    ('volume_quota',): {

                        'inclusive_minimum': 0,
                    },
                    ('disk_quota',): {

                        'inclusive_maximum': 100000000000000,
                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'username':
                        (str,),
                    'parallel_quota':
                        (float,),
                    'volume_quota':
                        (float,),
                    'disk_quota':
                        (int,),
                },
                'attribute_map': {
                    'username': 'username',
                    'parallel_quota': 'parallel_quota',
                    'volume_quota': 'volume_quota',
                    'disk_quota': 'disk_quota',
                },
                'location_map': {
                    'username': 'form',
                    'parallel_quota': 'form',
                    'volume_quota': 'form',
                    'disk_quota': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.update_user_default_instance_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/usage/instances/{username}/default',
                'operation_id': 'update_user_default_instance',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'username',
                    'default_label',
                ],
                'required': [
                    'username',
                    'default_label',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'default_label',
                ]
            },
            root_map={
                'validations': {
                    ('default_label',): {
                        'max_length': 30,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'username':
                        (str,),
                    'default_label':
                        (str,),
                },
                'attribute_map': {
                    'username': 'username',
                    'default_label': 'default_label',
                },
                'location_map': {
                    'username': 'path',
                    'default_label': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.update_user_instances_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/usage/instances/{username}',
                'operation_id': 'update_user_instances',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'username',
                    'default_label',
                    'labels',
                ],
                'required': [
                    'username',
                    'default_label',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'default_label',
                    'labels',
                ]
            },
            root_map={
                'validations': {
                    ('default_label',): {
                        'max_length': 30,
                        'min_length': 1,
                    },
                    ('labels',): {

                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'username':
                        (str,),
                    'default_label':
                        (str,),
                    'labels':
                        ([str],),
                },
                'attribute_map': {
                    'username': 'username',
                    'default_label': 'default_label',
                    'labels': 'labels',
                },
                'location_map': {
                    'username': 'path',
                    'default_label': 'form',
                    'labels': 'form',
                },
                'collection_format_map': {
                    'labels': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )

    def create_instance(
        self,
        label,
        cpu_request,
        memory_request,
        multiplier,
        workspace_request,
        **kwargs
    ):
        """Adds new instance  # noqa: E501

        Requires admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_instance(label, cpu_request, memory_request, multiplier, workspace_request, async_req=True)
        >>> result = thread.get()

        Args:
            label (str): Label to assign to instance
            cpu_request (float): CPU units (vCPU/Core, Hyperthread)
            memory_request (int): Memory units (MiB)
            multiplier (float): Instance multiplier
            workspace_request (int): Max amount of disk space that can be used during the solve (MiB)

        Keyword Args:
            tolerations ([str]): Toleration information for the pod. [optional]
            node_selectors ([str]): Node selector information for the pod. [optional]
            gams_license (str): Base64-encoded GAMS license to be used on this instance (takes precedence over the user license and the system-wide license, not supported in Engine One). [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['label'] = \
            label
        kwargs['cpu_request'] = \
            cpu_request
        kwargs['memory_request'] = \
            memory_request
        kwargs['multiplier'] = \
            multiplier
        kwargs['workspace_request'] = \
            workspace_request
        return self.create_instance_endpoint.call_with_http_info(**kwargs)

    def delete_instance(
        self,
        label,
        **kwargs
    ):
        """Deletes existing instance  # noqa: E501

        Requires admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_instance(label, async_req=True)
        >>> result = thread.get()

        Args:
            label (str): Label of instance to delete

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['label'] = \
            label
        return self.delete_instance_endpoint.call_with_http_info(**kwargs)

    def delete_quota(
        self,
        username,
        **kwargs
    ):
        """Deletes the quota that is bound to the given user  # noqa: E501

        Admins can delete quotas of everyone. Inviters can delete quotas of invitees.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_quota(username, async_req=True)
        >>> result = thread.get()

        Args:
            username (str): Name of the user

        Keyword Args:
            field (str): Name of the field to delete, if not provided all fields are deleted. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['username'] = \
            username
        return self.delete_quota_endpoint.call_with_http_info(**kwargs)

    def delete_user_instances(
        self,
        username,
        **kwargs
    ):
        """Deletes instances assigned to a user  # noqa: E501

        Admins can delete instances of anyone. Inviters can delete instances of direct/indirect invitees.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_user_instances(username, async_req=True)
        >>> result = thread.get()

        Args:
            username (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['username'] = \
            username
        return self.delete_user_instances_endpoint.call_with_http_info(**kwargs)

    def get_instances(
        self,
        **kwargs
    ):
        """Lists all instances  # noqa: E501

        Requires admin role or the user must be able to use raw resource requests.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instances(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [ModelInstanceInfoFull]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_instances_endpoint.call_with_http_info(**kwargs)

    def get_quota(
        self,
        username,
        **kwargs
    ):
        """Gets quotas for the given user  # noqa: E501

        Users inherit quotas from their (grand) inviters as well. Admins can query the quotas of everyone. Inviters can query the quotas of themselves and invitees. Users can query quotas for themselves.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_quota(username, async_req=True)
        >>> result = thread.get()

        Args:
            username (str): Name of the user

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Quota]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['username'] = \
            username
        return self.get_quota_endpoint.call_with_http_info(**kwargs)

    def get_usage(
        self,
        username,
        **kwargs
    ):
        """Queries the usage data of a user with or without the user's invitees  # noqa: E501

        Admins can query everyone's usage data. Inviters can query usage data of invitees or usage data of jobs they have access to. Users can only query their own usage data or usage data of jobs they have access to. `resource_warning`, `instance`, and `multiplier` fields are hidden by default for compatibility reasons, please use X-Fields header to get it. For example: X-Fields: job_usage{\\*, labels{\\*}}, hypercube_job_usage{\\*, labels{\\*}}  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_usage(username, async_req=True)
        >>> result = thread.get()

        Args:
            username (str): Name of the user

        Keyword Args:
            recursive (bool): Show invitees as well. [optional] if omitted the server will use the default value of False
            from_datetime (datetime): iso8601 Datetime to filter jobs out when they are submitted before.. [optional]
            to_datetime (datetime): iso8601 Datetime to filter jobs out when they are submitted after.. [optional]
            x_fields (str): [optional]
            token ([str]): Job tokens to filter. [optional]
            hypercube_token ([str]): Hypercube tokens to filter. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ModelUsage
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['username'] = \
            username
        return self.get_usage_endpoint.call_with_http_info(**kwargs)

    def get_user_instances(
        self,
        username,
        **kwargs
    ):
        """Lists all instances user has permissions to use as well as the default instance  # noqa: E501

        Admins list instances of anyone. Inviters can list instances of direct/indirect invitees. Users can list own instances  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_instances(username, async_req=True)
        >>> result = thread.get()

        Args:
            username (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ModelUserinstanceInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['username'] = \
            username
        return self.get_user_instances_endpoint.call_with_http_info(**kwargs)

    def update_instance(
        self,
        label,
        cpu_request,
        memory_request,
        multiplier,
        workspace_request,
        old_label,
        **kwargs
    ):
        """Updates existing instance  # noqa: E501

        Requires admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_instance(label, cpu_request, memory_request, multiplier, workspace_request, old_label, async_req=True)
        >>> result = thread.get()

        Args:
            label (str): Label to assign to instance
            cpu_request (float): CPU units (vCPU/Core, Hyperthread)
            memory_request (int): Memory units (MiB)
            multiplier (float): Instance multiplier
            workspace_request (int): Max amount of disk space that can be used during the solve (MiB)
            old_label (str): Label of instance to modify

        Keyword Args:
            tolerations ([str]): Toleration information for the pod. [optional]
            node_selectors ([str]): Node selector information for the pod. [optional]
            gams_license (str): Base64-encoded GAMS license to be used on this instance (takes precedence over the user license and the system-wide license, not supported in Engine One). [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['label'] = \
            label
        kwargs['cpu_request'] = \
            cpu_request
        kwargs['memory_request'] = \
            memory_request
        kwargs['multiplier'] = \
            multiplier
        kwargs['workspace_request'] = \
            workspace_request
        kwargs['old_label'] = \
            old_label
        return self.update_instance_endpoint.call_with_http_info(**kwargs)

    def update_quota(
        self,
        username,
        **kwargs
    ):
        """Updates the quota that is bound to the given user  # noqa: E501

        If the user is inviter, everyone in the user's subtree is also effected. Admins cannot have quotas. Admins can update quotas of everyone. Inviters can update quotas of invitees.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_quota(username, async_req=True)
        >>> result = thread.get()

        Args:
            username (str): Name of the user

        Keyword Args:
            parallel_quota (float): Number of GAMS Seconds that the user and the user's invitees can run in parallel. [optional]
            volume_quota (float): Number of GAMS Seconds that the user and the user's invitees can run in total. [optional]
            disk_quota (int): Storage in bytes that the user and the user's invitees can use in total. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['username'] = \
            username
        return self.update_quota_endpoint.call_with_http_info(**kwargs)

    def update_user_default_instance(
        self,
        username,
        default_label,
        **kwargs
    ):
        """Updates the default instance of the logged in user  # noqa: E501

        `username` must match the logged in user and instance specified must be available to the user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user_default_instance(username, default_label, async_req=True)
        >>> result = thread.get()

        Args:
            username (str):
            default_label (str): Label of the instance to be used as default

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['username'] = \
            username
        kwargs['default_label'] = \
            default_label
        return self.update_user_default_instance_endpoint.call_with_http_info(**kwargs)

    def update_user_instances(
        self,
        username,
        default_label,
        **kwargs
    ):
        """Updates instances a user has permissions to use  # noqa: E501

        Admins can update instances of anyone. Admin can assign any existing instances. Admins cannot be assigned instances (only default instance). Inviters can update instances of direct/indirect invitees. Inviters can only assign instances that have been assigned to them.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user_instances(username, default_label, async_req=True)
        >>> result = thread.get()

        Args:
            username (str):
            default_label (str): Label of the instance to be used as default

        Keyword Args:
            labels ([str]): Instances to assign to user. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['username'] = \
            username
        kwargs['default_label'] = \
            default_label
        return self.update_user_instances_endpoint.call_with_http_info(**kwargs)

