"""
    GAMS Engine

    With GAMS Engine you can register and solve GAMS models. It has a namespace management system, so you can restrict your users to certain models.  # noqa: E501

    The version of the OpenAPI document: latest
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from gams.engine.api_client import ApiClient, Endpoint as _Endpoint
from gams.engine.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from gams.engine.model.bad_input import BadInput
from gams.engine.model.identity_provider import IdentityProvider
from gams.engine.model.invitation import Invitation
from gams.engine.model.invitation_token import InvitationToken
from gams.engine.model.message import Message
from gams.engine.model.not_found import NotFound
from gams.engine.model.user import User
from gams.engine.model.webhook import Webhook


class UsersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.assign_identity_providers_to_inviter_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/users/inviters-providers/{username}',
                'operation_id': 'assign_identity_providers_to_inviter',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'username',
                    'name',
                ],
                'required': [
                    'username',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'username':
                        (str,),
                    'name':
                        ([str],),
                },
                'attribute_map': {
                    'username': 'username',
                    'name': 'name',
                },
                'location_map': {
                    'username': 'path',
                    'name': 'form',
                },
                'collection_format_map': {
                    'name': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.create_invitation_endpoint = _Endpoint(
            settings={
                'response_type': (InvitationToken,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/users/invitation',
                'operation_id': 'create_invitation',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'roles',
                    'namespace_permissions',
                    'parallel_quota',
                    'volume_quota',
                    'disk_quota',
                    'labels',
                    'default_label',
                    'user_groups',
                    'gams_license',
                    'identity_provider_name',
                    'identity_provider_user_subject',
                    'invitable_identity_providers',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'roles',
                ],
                'validation': [
                    'parallel_quota',
                    'volume_quota',
                    'disk_quota',
                    'labels',
                    'default_label',
                    'gams_license',
                ]
            },
            root_map={
                'validations': {
                    ('parallel_quota',): {

                        'inclusive_minimum': 0,
                    },
                    ('volume_quota',): {

                        'inclusive_minimum': 0,
                    },
                    ('disk_quota',): {

                        'inclusive_maximum': 100000000000000,
                        'inclusive_minimum': 0,
                    },
                    ('labels',): {

                    },
                    ('default_label',): {
                        'max_length': 30,
                        'min_length': 1,
                    },
                    ('gams_license',): {
                        'max_length': 1000,
                    },
                },
                'allowed_values': {
                    ('roles',): {
                        0 : 'inviter', 1: 'admin'
                    },
                },
                'openapi_types': {
                    'roles':
                        ([str],),
                    'namespace_permissions':
                        ([str],),
                    'parallel_quota':
                        (float,),
                    'volume_quota':
                        (float,),
                    'disk_quota':
                        (int,),
                    'labels':
                        ([str],),
                    'default_label':
                        (str,),
                    'user_groups':
                        ([str],),
                    'gams_license':
                        (str,),
                    'identity_provider_name':
                        (str,),
                    'identity_provider_user_subject':
                        (str,),
                    'invitable_identity_providers':
                        ([str],),
                },
                'attribute_map': {
                    'roles': 'roles',
                    'namespace_permissions': 'namespace_permissions',
                    'parallel_quota': 'parallel_quota',
                    'volume_quota': 'volume_quota',
                    'disk_quota': 'disk_quota',
                    'labels': 'labels',
                    'default_label': 'default_label',
                    'user_groups': 'user_groups',
                    'gams_license': 'gams_license',
                    'identity_provider_name': 'identity_provider_name',
                    'identity_provider_user_subject': 'identity_provider_user_subject',
                    'invitable_identity_providers': 'invitable_identity_providers',
                },
                'location_map': {
                    'roles': 'form',
                    'namespace_permissions': 'form',
                    'parallel_quota': 'form',
                    'volume_quota': 'form',
                    'disk_quota': 'form',
                    'labels': 'form',
                    'default_label': 'form',
                    'user_groups': 'form',
                    'gams_license': 'form',
                    'identity_provider_name': 'form',
                    'identity_provider_user_subject': 'form',
                    'invitable_identity_providers': 'form',
                },
                'collection_format_map': {
                    'roles': 'csv',
                    'namespace_permissions': 'csv',
                    'labels': 'csv',
                    'user_groups': 'csv',
                    'invitable_identity_providers': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.create_webhook_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/users/webhooks',
                'operation_id': 'create_webhook',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'url',
                    'content_type',
                    'secret',
                    'recursive',
                    'events',
                    'insecure_ssl',
                ],
                'required': [
                    'url',
                ],
                'nullable': [
                ],
                'enum': [
                    'content_type',
                    'events',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('content_type',): {

                        "FORM": "form",
                        "JSON": "json"
                    },
                    ('events',): {

                    },
                },
                'openapi_types': {
                    'url':
                        (str,),
                    'content_type':
                        (str,),
                    'secret':
                        (str,),
                    'recursive':
                        (bool,),
                    'events':
                        ([str],),
                    'insecure_ssl':
                        (bool,),
                },
                'attribute_map': {
                    'url': 'url',
                    'content_type': 'content_type',
                    'secret': 'secret',
                    'recursive': 'recursive',
                    'events': 'events',
                    'insecure_ssl': 'insecure_ssl',
                },
                'location_map': {
                    'url': 'form',
                    'content_type': 'form',
                    'secret': 'form',
                    'recursive': 'form',
                    'events': 'form',
                    'insecure_ssl': 'form',
                },
                'collection_format_map': {
                    'events': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.delete_invitation_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/users/invitation',
                'operation_id': 'delete_invitation',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'token',
                ],
                'required': [
                    'token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'token': 'token',
                },
                'location_map': {
                    'token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_user_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/users/',
                'operation_id': 'delete_user',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'username',
                    'delete_results',
                    'delete_children',
                ],
                'required': [
                    'username',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'username',
                ]
            },
            root_map={
                'validations': {
                    ('username',): {

                        'regex': {
                            'pattern': r'^[a-zA-Z0-9_]{4,70}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'username':
                        (str,),
                    'delete_results':
                        (bool,),
                    'delete_children':
                        (bool,),
                },
                'attribute_map': {
                    'username': 'username',
                    'delete_results': 'delete_results',
                    'delete_children': 'delete_children',
                },
                'location_map': {
                    'username': 'query',
                    'delete_results': 'query',
                    'delete_children': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_webhook_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/users/webhooks',
                'operation_id': 'delete_webhook',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'exclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_invitation_metadata_endpoint = _Endpoint(
            settings={
                'response_type': (Invitation,),
                'auth': [],
                'endpoint_path': '/users/invitation/{token}',
                'operation_id': 'get_invitation_metadata',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'token',
                ],
                'required': [
                    'token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'token': 'token',
                },
                'location_map': {
                    'token': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_identity_providers_of_inviter_endpoint = _Endpoint(
            settings={
                'response_type': ([IdentityProvider],),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/users/inviters-providers/{username}',
                'operation_id': 'list_identity_providers_of_inviter',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'username',
                ],
                'required': [
                    'username',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'username':
                        (str,),
                },
                'attribute_map': {
                    'username': 'username',
                },
                'location_map': {
                    'username': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_invitations_endpoint = _Endpoint(
            settings={
                'response_type': ([Invitation],),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/users/invitation',
                'operation_id': 'list_invitations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'token',
                    'everyone',
                    'x_fields',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token':
                        (str,),
                    'everyone':
                        (bool,),
                    'x_fields':
                        (str,),
                },
                'attribute_map': {
                    'token': 'token',
                    'everyone': 'everyone',
                    'x_fields': 'X-Fields',
                },
                'location_map': {
                    'token': 'query',
                    'everyone': 'query',
                    'x_fields': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_users_endpoint = _Endpoint(
            settings={
                'response_type': ([User],),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/users/',
                'operation_id': 'list_users',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'username',
                    'everyone',
                    'x_fields',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'username',
                ]
            },
            root_map={
                'validations': {
                    ('username',): {

                        'regex': {
                            'pattern': r'^[a-zA-Z0-9_]{4,70}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'username':
                        (str,),
                    'everyone':
                        (bool,),
                    'x_fields':
                        (str,),
                },
                'attribute_map': {
                    'username': 'username',
                    'everyone': 'everyone',
                    'x_fields': 'X-Fields',
                },
                'location_map': {
                    'username': 'query',
                    'everyone': 'query',
                    'x_fields': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_webhooks_endpoint = _Endpoint(
            settings={
                'response_type': ([Webhook],),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/users/webhooks',
                'operation_id': 'list_webhooks',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.register_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [],
                'endpoint_path': '/users/',
                'operation_id': 'register',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'username',
                    'invitation_code',
                    'password',
                    'identification_token',
                ],
                'required': [
                    'username',
                    'invitation_code',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'username',
                    'password',
                ]
            },
            root_map={
                'validations': {
                    ('username',): {

                        'regex': {
                            'pattern': r'^[a-zA-Z0-9_]{4,70}$',  # noqa: E501
                        },
                    },
                    ('password',): {

                        'regex': {
                            'pattern': r'^[0-9a-zA-Z!"#\$%&\'\(\)\*\+,\-\.\/:;<=>\?@[\]\^_`\{\|}~\\]{8,70}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'username':
                        (str,),
                    'invitation_code':
                        (str,),
                    'password':
                        (str,),
                    'identification_token':
                        (str,),
                },
                'attribute_map': {
                    'username': 'username',
                    'invitation_code': 'invitation_code',
                    'password': 'password',
                    'identification_token': 'identification_token',
                },
                'location_map': {
                    'username': 'form',
                    'invitation_code': 'form',
                    'password': 'form',
                    'identification_token': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.replace_user_name_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/users/username',
                'operation_id': 'replace_user_name',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'username',
                    'new_username',
                ],
                'required': [
                    'username',
                    'new_username',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'username',
                    'new_username',
                ]
            },
            root_map={
                'validations': {
                    ('username',): {

                        'regex': {
                            'pattern': r'^[a-zA-Z0-9_]{4,70}$',  # noqa: E501
                        },
                    },
                    ('new_username',): {

                        'regex': {
                            'pattern': r'^[a-zA-Z0-9_]{4,70}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'username':
                        (str,),
                    'new_username':
                        (str,),
                },
                'attribute_map': {
                    'username': 'username',
                    'new_username': 'new_username',
                },
                'location_map': {
                    'username': 'form',
                    'new_username': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.replace_user_password_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/users/',
                'operation_id': 'replace_user_password',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'username',
                    'password',
                ],
                'required': [
                    'username',
                    'password',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'username',
                    'password',
                ]
            },
            root_map={
                'validations': {
                    ('username',): {

                        'regex': {
                            'pattern': r'^[a-zA-Z0-9_]{4,70}$',  # noqa: E501
                        },
                    },
                    ('password',): {

                        'regex': {
                            'pattern': r'^[0-9a-zA-Z!"#\$%&\'\(\)\*\+,\-\.\/:;<=>\?@[\]\^_`\{\|}~\\]{8,70}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'username':
                        (str,),
                    'password':
                        (str,),
                },
                'attribute_map': {
                    'username': 'username',
                    'password': 'password',
                },
                'location_map': {
                    'username': 'form',
                    'password': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.update_user_identity_provider_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/users/identity-provider',
                'operation_id': 'update_user_identity_provider',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'username',
                    'identity_provider_name',
                    'identity_provider_user_subject',
                    'password',
                ],
                'required': [
                    'username',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'password',
                ]
            },
            root_map={
                'validations': {
                    ('password',): {

                        'regex': {
                            'pattern': r'^[0-9a-zA-Z!"#\$%&\'\(\)\*\+,\-\.\/:;<=>\?@[\]\^_`\{\|}~\\]{8,70}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'username':
                        (str,),
                    'identity_provider_name':
                        (str,),
                    'identity_provider_user_subject':
                        (str,),
                    'password':
                        (str,),
                },
                'attribute_map': {
                    'username': 'username',
                    'identity_provider_name': 'identity_provider_name',
                    'identity_provider_user_subject': 'identity_provider_user_subject',
                    'password': 'password',
                },
                'location_map': {
                    'username': 'form',
                    'identity_provider_name': 'form',
                    'identity_provider_user_subject': 'form',
                    'password': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.update_user_role_endpoint = _Endpoint(
            settings={
                'response_type': (Message,),
                'auth': [
                    'BasicAuth'
                ],
                'endpoint_path': '/users/role',
                'operation_id': 'update_user_role',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'username',
                    'roles',
                ],
                'required': [
                    'username',
                ],
                'nullable': [
                ],
                'enum': [
                    'roles',
                ],
                'validation': [
                    'username',
                ]
            },
            root_map={
                'validations': {
                    ('username',): {

                        'regex': {
                            'pattern': r'^[a-zA-Z0-9_]{4,70}$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('roles',): {
                        0 : 'inviter', 1: 'admin'
                    },
                },
                'openapi_types': {
                    'username':
                        (str,),
                    'roles':
                        ([str],),
                },
                'attribute_map': {
                    'username': 'username',
                    'roles': 'roles',
                },
                'location_map': {
                    'username': 'form',
                    'roles': 'form',
                },
                'collection_format_map': {
                    'roles': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )

    def assign_identity_providers_to_inviter(
        self,
        username,
        **kwargs
    ):
        """Updates the list of identity providers that the specified user can use when inviting  # noqa: E501

        Requires admin or inviter role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.assign_identity_providers_to_inviter(username, async_req=True)
        >>> result = thread.get()

        Args:
            username (str):

        Keyword Args:
            name ([str]): Unique identifiers of identity providers. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['username'] = \
            username
        return self.assign_identity_providers_to_inviter_endpoint.call_with_http_info(**kwargs)

    def create_invitation(
        self,
        **kwargs
    ):
        """Creates an invitation code for new user  # noqa: E501

        Admins can invite admins, inviters and normal users. Inviters can invite inviters and normal users. Inviters cannot grant permissions that they do not possess. Only admins can specify `gams_license`. Requires admin or inviter role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_invitation(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            roles ([str]): Possible values are: ['inviter', 'admin']. [optional]
            namespace_permissions ([str]): Syntax is permission_number@namespace_name, ie \\\"7@global\\\". [optional]
            parallel_quota (float): Number of GAMS Seconds that the user and the user's invitees can run in parallel. [optional]
            volume_quota (float): Number of GAMS Seconds that the user and the user's invitees can run in total. [optional]
            disk_quota (int): Storage space in bytes that the user and the user's invitees can use in total. [optional]
            labels ([str]): Instances to assign to user. [optional]
            default_label (str): Label of the instance to be used as default. [optional]
            user_groups ([str]): User groups to put the user in, in format user_group@namespace format. [optional]
            gams_license (str): Base64 encoded GAMS license to attach to user. [optional]
            identity_provider_name (str): Name of the 3rd party identity provider that will be used to authenticate the user, use \\\"gams_engine\\\" or leave empty to use Engine as your identity provider. You can leave it blank only if you have only Engine as an invitable identity provider. [optional]
            identity_provider_user_subject (str): Subject of the user in the 3rd party identity provider. Leave empty when using Engine as your identity provider. You can leave it blank if you do not know the user's subject in the OAuth 2.0 or OIDC provider. [optional]
            invitable_identity_providers ([str]): If the invited user has the inviter role, this argument lists the identity providers that the user can use to invite.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InvitationToken
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.create_invitation_endpoint.call_with_http_info(**kwargs)

    def create_webhook(
        self,
        url,
        **kwargs
    ):
        """Creates a new webhook  # noqa: E501

        The webhook feature has to be enabled via the `/configuration` endpoint. In case the webhook_access configuration is set to `ADMIN_ONLY`, only admins are able to access this endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_webhook(url, async_req=True)
        >>> result = thread.get()

        Args:
            url (str): The URL to which the payload is to be sent

        Keyword Args:
            content_type (str): The media type used to serialize the data. Possible values are form and json (form is the default).. [optional] if omitted the server will use the default value of "form"
            secret (str): The secret key used to generate the HMAC. This HMAC will be included in the X-ENGINE-HMAC header.. [optional]
            recursive (bool): Whether the webhook should also be registered for invitees. If the logged-in user is admin, recursive means that the webhook is registered globally for all users.. [optional] if omitted the server will use the default value of False
            events ([str]): Events to subscribe to (default: all events). Possible values: ALL JOB_FINISHED HC_JOB_FINISHED. [optional]
            insecure_ssl (bool): Whether to disable validation of SSL certificates when submitting this webhook. We strongly recommend not disabling certificate validation to protect against Man in The Middle attacks.. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['url'] = \
            url
        return self.create_webhook_endpoint.call_with_http_info(**kwargs)

    def delete_invitation(
        self,
        token,
        **kwargs
    ):
        """Deletes an invitation if it is unused  # noqa: E501

        Admins can delete all unused invitations, inviters can only delete invitations that belong to them or that belong to direct/indirect invitees of them.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_invitation(token, async_req=True)
        >>> result = thread.get()

        Args:
            token (str): Token of the invitation to be deleted

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['token'] = \
            token
        return self.delete_invitation_endpoint.call_with_http_info(**kwargs)

    def delete_user(
        self,
        username,
        **kwargs
    ):
        """Deletes a user  # noqa: E501

        Admins can delete anyone, inviters can delete users who are directly/indirectly invited. Requires admin or inviter role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_user(username, async_req=True)
        >>> result = thread.get()

        Args:
            username (str): Username of the user to delete

        Keyword Args:
            delete_results (bool): Also delete all submission results that are related to the user. [optional]
            delete_children (bool): Delete users invited directly/indirectly by this user. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['username'] = \
            username
        return self.delete_user_endpoint.call_with_http_info(**kwargs)

    def delete_webhook(
        self,
        id,
        **kwargs
    ):
        """Removes an existing webhook  # noqa: E501

        The webhook feature has to be enabled via the `/configuration` endpoint. In case the webhook_access configuration is set to `ADMIN_ONLY`, only admins are able to access this endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_webhook(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): The ID of the webhook to be removed

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.delete_webhook_endpoint.call_with_http_info(**kwargs)

    def get_invitation_metadata(
        self,
        token,
        **kwargs
    ):
        """Get the metadata attached to the invitation  # noqa: E501

        The invitation must be unused.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_invitation_metadata(token, async_req=True)
        >>> result = thread.get()

        Args:
            token (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Invitation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['token'] = \
            token
        return self.get_invitation_metadata_endpoint.call_with_http_info(**kwargs)

    def list_identity_providers_of_inviter(
        self,
        username,
        **kwargs
    ):
        """Lists the identity providers that the specified user can use when inviting  # noqa: E501

        Requires admin or inviter role. If the listed user is admin, returns all identity providers. If the listed user is inviter, returns the identity providers that the user can invite with. If the listed user has no role, returns an empty list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_identity_providers_of_inviter(username, async_req=True)
        >>> result = thread.get()

        Args:
            username (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [IdentityProvider]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['username'] = \
            username
        return self.list_identity_providers_of_inviter_endpoint.call_with_http_info(**kwargs)

    def list_invitations(
        self,
        **kwargs
    ):
        """Lists the invitation codes created by the user  # noqa: E501

        \"Everyone\" argument can only be set by the admin, and if it is set, all invitations are listed. Requires inviter or admin role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_invitations(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            token (str): Invitation code to filter. [optional]
            everyone (bool): Can only be set by admin, lists all invitations. [optional]
            x_fields (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Invitation]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_invitations_endpoint.call_with_http_info(**kwargs)

    def list_users(
        self,
        **kwargs
    ):
        """If admin, lists all users unless `everyone` is set to False  # noqa: E501

        If inviter, lists users invited directly/indirectly unless `everyone` is set to False. If normal user, shows details of logged-in user. Setting username filters the results. When `everyone` is set to False, only information about the logged-in user is shown.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_users(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            username (str): Username of the user to filter. [optional]
            everyone (bool): If True, which is default, shows invitees.. [optional] if omitted the server will use the default value of True
            x_fields (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [User]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_users_endpoint.call_with_http_info(**kwargs)

    def list_webhooks(
        self,
        **kwargs
    ):
        """If admin, lists all webhooks  # noqa: E501

        If inviter, lists webhooks of direct/indirect invitees. If user, lists webhooks of logged-in user.  The webhook feature has to be enabled via the `/configuration` endpoint. In case the webhook_access configuration is set to `ADMIN_ONLY`, only admins are able to access this endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_webhooks(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [Webhook]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_webhooks_endpoint.call_with_http_info(**kwargs)

    def register(
        self,
        username,
        invitation_code,
        **kwargs
    ):
        """Creates a new user if the invitation code is valid and not used  # noqa: E501

        Username must be unique. Invitation code is considered invalid if the identity provider attached to it is deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.register(username, invitation_code, async_req=True)
        >>> result = thread.get()

        Args:
            username (str):
            invitation_code (str): Invitation code

        Keyword Args:
            password (str): [optional]
            identification_token (str): 3rd party signed JWT token for identification. Needs to be an ID token for OIDC providers and an access token for OAuth 2.0 providers.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['username'] = \
            username
        kwargs['invitation_code'] = \
            invitation_code
        return self.register_endpoint.call_with_http_info(**kwargs)

    def replace_user_name(
        self,
        username,
        new_username,
        **kwargs
    ):
        """Changes username of the user with the given username  # noqa: E501

        Requires admin permissions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.replace_user_name(username, new_username, async_req=True)
        >>> result = thread.get()

        Args:
            username (str): Username of the user whose username is to be changed
            new_username (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['username'] = \
            username
        kwargs['new_username'] = \
            new_username
        return self.replace_user_name_endpoint.call_with_http_info(**kwargs)

    def replace_user_password(
        self,
        username,
        password,
        **kwargs
    ):
        """Changes password of the user with the given username  # noqa: E501

        Users can change their own passwords, Inviters can change password of invitees, Admins can change the password of anyone. This has no effect if the target user is not using Engine as identity provider.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.replace_user_password(username, password, async_req=True)
        >>> result = thread.get()

        Args:
            username (str): Username of the user whose password is to be changed
            password (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['username'] = \
            username
        kwargs['password'] = \
            password
        return self.replace_user_password_endpoint.call_with_http_info(**kwargs)

    def update_user_identity_provider(
        self,
        username,
        **kwargs
    ):
        """Updates the identity provider of the user or blocks the user  # noqa: E501

        Admins can update anyone's identity provider to any identity provider. Inviters can update their subtree's identity provider to any allowed identity provider. To block the user, leave `identity_provider_name` empty.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user_identity_provider(username, async_req=True)
        >>> result = thread.get()

        Args:
            username (str): Name of the user whose identity provider is to be updated

        Keyword Args:
            identity_provider_name (str): Name of the identity provider. To switch back to using Engine as identity provider, use `gams_engine` as value. If it is empty, the user will be blocked and won't be able to login. . [optional]
            identity_provider_user_subject (str): Subject of the user in the 3rd party identity provider. Leave empty when using Engine as your identity provider. You can leave it blank if you do not know the user's subject in the OAuth 2.0 or OIDC provider. [optional]
            password (str): When `gams_engine` is the identity provider, this field is required and used as the user's password.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['username'] = \
            username
        return self.update_user_identity_provider_endpoint.call_with_http_info(**kwargs)

    def update_user_role(
        self,
        username,
        **kwargs
    ):
        """Promotes/demotes user  # noqa: E501

        Admins can modify anyone. Inviters can modify direct/indirect invitees.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user_role(username, async_req=True)
        >>> result = thread.get()

        Args:
            username (str): Username of the user whose roles are to be changed

        Keyword Args:
            roles ([str]): New roles of the user, possible values are: ['inviter', 'admin']. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Message
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['username'] = \
            username
        return self.update_user_role_endpoint.call_with_http_info(**kwargs)

