# odin-sdk
API Documentation to interact with

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 3.0.106
- Generator version: 7.14.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import odin_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import odin_sdk
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import odin_sdk
from odin_sdk.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://127.0.0.1:8001
# See configuration.py for a list of all supported configuration parameters.
configuration = odin_sdk.Configuration(
    host = "https://127.0.0.1:8001"
)



# Enter a context with an instance of the API client
with odin_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = odin_sdk.AgentsApi(api_client)
    routes_projects_activate_custom_agent_request = odin_sdk.RoutesProjectsActivateCustomAgentRequest() # RoutesProjectsActivateCustomAgentRequest | 
    x_api_key = 'x_api_key_example' # str | Your Odin API key. (optional)
    x_api_secret = 'x_api_secret_example' # str | Your Odin API secret. (optional)

    try:
        # Activate an Existing Custom Agent
        api_response = api_instance.activate_custom_agent_agents_activate_post(routes_projects_activate_custom_agent_request, x_api_key=x_api_key, x_api_secret=x_api_secret)
        print("The response of AgentsApi->activate_custom_agent_agents_activate_post:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AgentsApi->activate_custom_agent_agents_activate_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://127.0.0.1:8001*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AgentsApi* | [**activate_custom_agent_agents_activate_post**](docs/AgentsApi.md#activate_custom_agent_agents_activate_post) | **POST** /agents/activate | Activate an Existing Custom Agent
*AgentsApi* | [**edit_existing_custom_agent_agents_edit_post**](docs/AgentsApi.md#edit_existing_custom_agent_agents_edit_post) | **POST** /agents/edit | Edit an Existing Custom Agent
*AgentsApi* | [**list_agents_for_project_agents_project_id_list_get**](docs/AgentsApi.md#list_agents_for_project_agents_project_id_list_get) | **GET** /agents/{project_id}/list | List Agents for Project
*AgentsApi* | [**save_new_custom_agent_agents_new_post**](docs/AgentsApi.md#save_new_custom_agent_agents_new_post) | **POST** /agents/new | Save a New Custom Agent
*ChatApi* | [**create_chat_chat_create_post**](docs/ChatApi.md#create_chat_chat_create_post) | **POST** /chat/create | Create Chat
*ChatApi* | [**delete_chat_chat_delete_delete**](docs/ChatApi.md#delete_chat_chat_delete_delete) | **DELETE** /chat/delete | Delete Chat
*ChatApi* | [**get_chat_project_project_id_chat_chat_id_get**](docs/ChatApi.md#get_chat_project_project_id_chat_chat_id_get) | **GET** /project/{project_id}/chat/{chat_id} | Get Chat
*ChatApi* | [**get_chats_project_project_id_chat_get**](docs/ChatApi.md#get_chats_project_project_id_chat_get) | **GET** /project/{project_id}/chat | Get Chats
*ChatApi* | [**get_default_models_chat_models_get**](docs/ChatApi.md#get_default_models_chat_models_get) | **GET** /chat/models | Get Default Models
*ChatApi* | [**send_message_v3_v3_chat_message_post**](docs/ChatApi.md#send_message_v3_v3_chat_message_post) | **POST** /v3/chat/message |  Send Message V3
*CustomToolsApi* | [**execute_workflow_tools_execute_workflow_post**](docs/CustomToolsApi.md#execute_workflow_tools_execute_workflow_post) | **POST** /tools/execute-workflow | Execute Workflow
*CustomToolsApi* | [**execute_workflow_with_file_upload_tools_execute_workflow_file_upload_post**](docs/CustomToolsApi.md#execute_workflow_with_file_upload_tools_execute_workflow_file_upload_post) | **POST** /tools/execute-workflow-file-upload | Execute Workflow With File Upload
*DataTypesApi* | [**cancel_compute_column_job_project_project_id_data_type_data_type_id_compute_column_cancel_execution_id_post**](docs/DataTypesApi.md#cancel_compute_column_job_project_project_id_data_type_data_type_id_compute_column_cancel_execution_id_post) | **POST** /project/{project_id}/data-type/{data_type_id}/compute-column/cancel/{execution_id} | Cancel Compute Column Job
*DataTypesApi* | [**compute_column_values_async_project_project_id_data_type_data_type_id_compute_column_async_post**](docs/DataTypesApi.md#compute_column_values_async_project_project_id_data_type_data_type_id_compute_column_async_post) | **POST** /project/{project_id}/data-type/{data_type_id}/compute-column/async | Compute Column Values Async
*DataTypesApi* | [**create_data_type_project_project_id_data_types_post**](docs/DataTypesApi.md#create_data_type_project_project_id_data_types_post) | **POST** /project/{project_id}/data-types | Create Data Type
*DataTypesApi* | [**create_data_type_view_project_project_id_data_type_data_type_id_view_post**](docs/DataTypesApi.md#create_data_type_view_project_project_id_data_type_data_type_id_view_post) | **POST** /project/{project_id}/data-type/{data_type_id}/view | Create Data Type View
*DataTypesApi* | [**delete_data_type_by_id_project_project_id_data_types_data_type_id_delete**](docs/DataTypesApi.md#delete_data_type_by_id_project_project_id_data_types_data_type_id_delete) | **DELETE** /project/{project_id}/data-types/{data_type_id} | Delete Data Type By Id
*DataTypesApi* | [**get_compute_column_jobs_project_project_id_data_type_data_type_id_compute_column_jobs_get**](docs/DataTypesApi.md#get_compute_column_jobs_project_project_id_data_type_data_type_id_compute_column_jobs_get) | **GET** /project/{project_id}/data-type/{data_type_id}/compute-column/jobs | Get Compute Column Jobs
*DataTypesApi* | [**get_compute_column_status_project_project_id_data_type_data_type_id_compute_column_status_execution_id_get**](docs/DataTypesApi.md#get_compute_column_status_project_project_id_data_type_data_type_id_compute_column_status_execution_id_get) | **GET** /project/{project_id}/data-type/{data_type_id}/compute-column/status/{execution_id} | Get Compute Column Status
*DataTypesApi* | [**get_data_type_by_id_project_project_id_data_types_data_type_id_get**](docs/DataTypesApi.md#get_data_type_by_id_project_project_id_data_types_data_type_id_get) | **GET** /project/{project_id}/data-types/{data_type_id} | Get Data Type By Id
*DataTypesApi* | [**get_data_type_view_by_id_project_project_id_data_types_data_type_id_view_get**](docs/DataTypesApi.md#get_data_type_view_by_id_project_project_id_data_types_data_type_id_view_get) | **GET** /project/{project_id}/data-types/{data_type_id}/view | Get Data Type View By Id
*DataTypesApi* | [**get_data_types_project_project_id_data_types_get**](docs/DataTypesApi.md#get_data_types_project_project_id_data_types_get) | **GET** /project/{project_id}/data-types | Get Data Types
*DataTypesApi* | [**get_grouped_data_type_view_by_id_project_project_id_data_types_data_type_id_view_grouped_get**](docs/DataTypesApi.md#get_grouped_data_type_view_by_id_project_project_id_data_types_data_type_id_view_grouped_get) | **GET** /project/{project_id}/data-types/{data_type_id}/view/grouped | Get Grouped Data Type View By Id
*DataTypesApi* | [**get_template_details_project_project_id_data_type_templates_template_name_get**](docs/DataTypesApi.md#get_template_details_project_project_id_data_type_templates_template_name_get) | **GET** /project/{project_id}/data-type-templates/{template_name} | Get Template Details
*DataTypesApi* | [**get_templates_project_project_id_data_type_templates_get**](docs/DataTypesApi.md#get_templates_project_project_id_data_type_templates_get) | **GET** /project/{project_id}/data-type-templates | Get Templates
*DataTypesApi* | [**import_table_project_project_id_import_table_post**](docs/DataTypesApi.md#import_table_project_project_id_import_table_post) | **POST** /project/{project_id}/import-table | Import Table
*DataTypesApi* | [**update_column_metadata_project_project_id_data_type_data_type_id_column_column_name_metadata_put**](docs/DataTypesApi.md#update_column_metadata_project_project_id_data_type_data_type_id_column_column_name_metadata_put) | **PUT** /project/{project_id}/data-type/{data_type_id}/column/{column_name}/metadata | Update Column Metadata
*DataTypesApi* | [**update_data_type_view_project_project_id_data_type_data_type_id_view_view_id_put**](docs/DataTypesApi.md#update_data_type_view_project_project_id_data_type_data_type_id_view_view_id_put) | **PUT** /project/{project_id}/data-type/{data_type_id}/view/{view_id} | Update Data Type View
*DataTypesApi* | [**use_template_project_project_id_data_type_templates_use_post**](docs/DataTypesApi.md#use_template_project_project_id_data_type_templates_use_post) | **POST** /project/{project_id}/data-type-templates/use | Use Template
*JsonsApi* | [**delete_json_json_delete**](docs/JsonsApi.md#delete_json_json_delete) | **DELETE** /json | Delete Json
*JsonsApi* | [**edit_json_json_put**](docs/JsonsApi.md#edit_json_json_put) | **PUT** /json | Edit Json
*JsonsApi* | [**get_json_json_post**](docs/JsonsApi.md#get_json_json_post) | **POST** /json | Get Json
*JsonsApi* | [**get_jsons_jsons_post**](docs/JsonsApi.md#get_jsons_jsons_post) | **POST** /jsons | Get Jsons
*KnowledgeBaseApi* | [**add_file_to_knowledge_base_v3_v3_project_knowledge_add_file_post**](docs/KnowledgeBaseApi.md#add_file_to_knowledge_base_v3_v3_project_knowledge_add_file_post) | **POST** /v3/project/knowledge/add/file | Add File To Knowledge Base V3
*KnowledgeBaseApi* | [**batch_delete_project_knowledge_delete_delete**](docs/KnowledgeBaseApi.md#batch_delete_project_knowledge_delete_delete) | **DELETE** /project/knowledge/delete | Batch Delete
*KnowledgeBaseApi* | [**sync_kb_file_v2_v2_project_knowledge_sync_file_post**](docs/KnowledgeBaseApi.md#sync_kb_file_v2_v2_project_knowledge_sync_file_post) | **POST** /v2/project/knowledge/sync/file | Sync Kb File V2
*ProjectsApi* | [**add_user_to_project_project_user_add_post**](docs/ProjectsApi.md#add_user_to_project_project_user_add_post) | **POST** /project/user/add | Add User To Project
*ProjectsApi* | [**create_project_project_create_post**](docs/ProjectsApi.md#create_project_project_create_post) | **POST** /project/create | Create Project
*ProjectsApi* | [**delete_project_project_delete_delete**](docs/ProjectsApi.md#delete_project_project_delete_delete) | **DELETE** /project/delete | Delete Project
*ProjectsApi* | [**edit_project_user_project_user_edit_post**](docs/ProjectsApi.md#edit_project_user_project_user_edit_post) | **POST** /project/user/edit | Edit Project User
*ProjectsApi* | [**get_project_members_project_project_id_members_get**](docs/ProjectsApi.md#get_project_members_project_project_id_members_get) | **GET** /project/{project_id}/members | Get Project Members
*ProjectsApi* | [**get_projects_projects_get**](docs/ProjectsApi.md#get_projects_projects_get) | **GET** /projects | Get Projects
*ProjectsApi* | [**update_project_project_update_post**](docs/ProjectsApi.md#update_project_project_update_post) | **POST** /project/update | Update Project
*RolesApi* | [**create_role_project_project_id_roles_post**](docs/RolesApi.md#create_role_project_project_id_roles_post) | **POST** /project/{project_id}/roles | Create Role
*RolesApi* | [**get_all_role_ids_project_project_id_roles_get**](docs/RolesApi.md#get_all_role_ids_project_project_id_roles_get) | **GET** /project/{project_id}/roles | Get All Role Ids
*ToolsApi* | [**execute_step_tools_execute_step_post**](docs/ToolsApi.md#execute_step_tools_execute_step_post) | **POST** /tools/execute-step | Execute Step


## Documentation For Models

 - [APIKey](docs/APIKey.md)
 - [ActionsRules](docs/ActionsRules.md)
 - [ActivateCustomAgentResponse](docs/ActivateCustomAgentResponse.md)
 - [AddMembersRules](docs/AddMembersRules.md)
 - [AddUserToProjectRequest](docs/AddUserToProjectRequest.md)
 - [AddUserToProjectResponse](docs/AddUserToProjectResponse.md)
 - [AgentsRules](docs/AgentsRules.md)
 - [AnalyticsRules](docs/AnalyticsRules.md)
 - [AssistantRules](docs/AssistantRules.md)
 - [BatchDeleteRequest](docs/BatchDeleteRequest.md)
 - [BatchDeleteResponse](docs/BatchDeleteResponse.md)
 - [ChatModelInfoResponse](docs/ChatModelInfoResponse.md)
 - [ChatRules](docs/ChatRules.md)
 - [ComputeColumnAsyncResponse](docs/ComputeColumnAsyncResponse.md)
 - [ComputeColumnCancelResponse](docs/ComputeColumnCancelResponse.md)
 - [ComputeColumnJobsResponse](docs/ComputeColumnJobsResponse.md)
 - [ComputeColumnRequest](docs/ComputeColumnRequest.md)
 - [ComputeColumnStatusResponse](docs/ComputeColumnStatusResponse.md)
 - [CreateChatPromptRequest](docs/CreateChatPromptRequest.md)
 - [CreateChatPromptResponse](docs/CreateChatPromptResponse.md)
 - [CreateProjectRequest](docs/CreateProjectRequest.md)
 - [CreateProjectResponse](docs/CreateProjectResponse.md)
 - [CreateRoleRequest](docs/CreateRoleRequest.md)
 - [CreateRoleResponse](docs/CreateRoleResponse.md)
 - [CreateViewRequest](docs/CreateViewRequest.md)
 - [CreateViewResponse](docs/CreateViewResponse.md)
 - [CustomChatbot](docs/CustomChatbot.md)
 - [DTField](docs/DTField.md)
 - [DataTypeWithSchema](docs/DataTypeWithSchema.md)
 - [DeleteChatRequest](docs/DeleteChatRequest.md)
 - [DeleteChatResponse](docs/DeleteChatResponse.md)
 - [DeleteDataTypeResponse](docs/DeleteDataTypeResponse.md)
 - [DeleteJsonRequest](docs/DeleteJsonRequest.md)
 - [DeleteJsonResponse](docs/DeleteJsonResponse.md)
 - [DeleteProjectRequest](docs/DeleteProjectRequest.md)
 - [DeleteProjectResponse](docs/DeleteProjectResponse.md)
 - [DocumentRules](docs/DocumentRules.md)
 - [EditExistingCustomAgent](docs/EditExistingCustomAgent.md)
 - [EditExistingCustomAgentResponse](docs/EditExistingCustomAgentResponse.md)
 - [EditProjectRequest](docs/EditProjectRequest.md)
 - [EditProjectResponse](docs/EditProjectResponse.md)
 - [ExecutionMode](docs/ExecutionMode.md)
 - [ExecutionTriggerMode](docs/ExecutionTriggerMode.md)
 - [FlowsRules](docs/FlowsRules.md)
 - [GetAllProjectsResponse](docs/GetAllProjectsResponse.md)
 - [GetAllRoleNamesResponse](docs/GetAllRoleNamesResponse.md)
 - [GetChatResponse](docs/GetChatResponse.md)
 - [GetChatsResponse](docs/GetChatsResponse.md)
 - [GetDataTypeViewResponse](docs/GetDataTypeViewResponse.md)
 - [GetGroupedDataTypeViewResponse](docs/GetGroupedDataTypeViewResponse.md)
 - [GetJsonRequest](docs/GetJsonRequest.md)
 - [GetJsonsRequest](docs/GetJsonsRequest.md)
 - [GetProjectMembersResponse](docs/GetProjectMembersResponse.md)
 - [GetTemplatesResponse](docs/GetTemplatesResponse.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [Images](docs/Images.md)
 - [ImportTableResponse](docs/ImportTableResponse.md)
 - [InvitedUser](docs/InvitedUser.md)
 - [KBFileStatus](docs/KBFileStatus.md)
 - [KBRules](docs/KBRules.md)
 - [KbInfo](docs/KbInfo.md)
 - [LLMModel](docs/LLMModel.md)
 - [ListAgentsForProjectResponse](docs/ListAgentsForProjectResponse.md)
 - [ModelJson](docs/ModelJson.md)
 - [PersonalityId](docs/PersonalityId.md)
 - [Project](docs/Project.md)
 - [ProjectInfo](docs/ProjectInfo.md)
 - [ProjectMember](docs/ProjectMember.md)
 - [QuickUploadMultiple](docs/QuickUploadMultiple.md)
 - [Resource](docs/Resource.md)
 - [Role](docs/Role.md)
 - [RolesRules](docs/RolesRules.md)
 - [RoutesDataTypesAddDataTypeRequest](docs/RoutesDataTypesAddDataTypeRequest.md)
 - [RoutesDataTypesAddDataTypeResponse](docs/RoutesDataTypesAddDataTypeResponse.md)
 - [RoutesDataTypesGetDataTypeResponse](docs/RoutesDataTypesGetDataTypeResponse.md)
 - [RoutesDataTypesGetDataTypesResponse](docs/RoutesDataTypesGetDataTypesResponse.md)
 - [RoutesKnowledgebaseKnowledgeBaseDataResponse](docs/RoutesKnowledgebaseKnowledgeBaseDataResponse.md)
 - [RoutesProjectsActivateCustomAgentRequest](docs/RoutesProjectsActivateCustomAgentRequest.md)
 - [RoutesProjectsMember](docs/RoutesProjectsMember.md)
 - [Rules](docs/Rules.md)
 - [SaveNewCustomAgent](docs/SaveNewCustomAgent.md)
 - [SaveNewCustomAgentResponse](docs/SaveNewCustomAgentResponse.md)
 - [SendMessageResponse](docs/SendMessageResponse.md)
 - [SettingsRules](docs/SettingsRules.md)
 - [StepExecutionRequest](docs/StepExecutionRequest.md)
 - [StepExecutionResult](docs/StepExecutionResult.md)
 - [SyncFileRequestLegacy](docs/SyncFileRequestLegacy.md)
 - [SystemPromptInfo](docs/SystemPromptInfo.md)
 - [TemplateField](docs/TemplateField.md)
 - [TemplatePreview](docs/TemplatePreview.md)
 - [UpdateColumnMetadataRequest](docs/UpdateColumnMetadataRequest.md)
 - [UpdateColumnMetadataResponse](docs/UpdateColumnMetadataResponse.md)
 - [UpdateJsonRequest](docs/UpdateJsonRequest.md)
 - [UpdateProjectRequest](docs/UpdateProjectRequest.md)
 - [UpdateProjectResponse](docs/UpdateProjectResponse.md)
 - [UpdateViewRequest](docs/UpdateViewRequest.md)
 - [UpdateViewResponse](docs/UpdateViewResponse.md)
 - [UseTemplateRequest](docs/UseTemplateRequest.md)
 - [UseTemplateResponse](docs/UseTemplateResponse.md)
 - [UserDetails](docs/UserDetails.md)
 - [UserInfo](docs/UserInfo.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)
 - [WorkflowExecutionRequest](docs/WorkflowExecutionRequest.md)
 - [WorkflowExecutionResult](docs/WorkflowExecutionResult.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="APIKeyHeader"></a>
### APIKeyHeader

- **Type**: API key
- **API key parameter name**: X-Test-API-Key
- **Location**: HTTP header


## Author




