# coding: utf-8

"""
    API Docs

    API Documentation to interact with

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated
from odin_sdk.models.activate_custom_agent_response import ActivateCustomAgentResponse
from odin_sdk.models.edit_existing_custom_agent import EditExistingCustomAgent
from odin_sdk.models.edit_existing_custom_agent_response import EditExistingCustomAgentResponse
from odin_sdk.models.list_agents_for_project_response import ListAgentsForProjectResponse
from odin_sdk.models.routes_projects_activate_custom_agent_request import RoutesProjectsActivateCustomAgentRequest
from odin_sdk.models.save_new_custom_agent import SaveNewCustomAgent
from odin_sdk.models.save_new_custom_agent_response import SaveNewCustomAgentResponse

from odin_sdk.api_client import ApiClient, RequestSerialized
from odin_sdk.api_response import ApiResponse
from odin_sdk.rest import RESTResponseType


class AgentsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def activate_custom_agent_agents_activate_post(
        self,
        routes_projects_activate_custom_agent_request: RoutesProjectsActivateCustomAgentRequest,
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ActivateCustomAgentResponse:
        """Activate an Existing Custom Agent

        Activate an existing custom agent in a project.

        :param routes_projects_activate_custom_agent_request: (required)
        :type routes_projects_activate_custom_agent_request: RoutesProjectsActivateCustomAgentRequest
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._activate_custom_agent_agents_activate_post_serialize(
            routes_projects_activate_custom_agent_request=routes_projects_activate_custom_agent_request,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ActivateCustomAgentResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def activate_custom_agent_agents_activate_post_with_http_info(
        self,
        routes_projects_activate_custom_agent_request: RoutesProjectsActivateCustomAgentRequest,
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ActivateCustomAgentResponse]:
        """Activate an Existing Custom Agent

        Activate an existing custom agent in a project.

        :param routes_projects_activate_custom_agent_request: (required)
        :type routes_projects_activate_custom_agent_request: RoutesProjectsActivateCustomAgentRequest
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._activate_custom_agent_agents_activate_post_serialize(
            routes_projects_activate_custom_agent_request=routes_projects_activate_custom_agent_request,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ActivateCustomAgentResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def activate_custom_agent_agents_activate_post_without_preload_content(
        self,
        routes_projects_activate_custom_agent_request: RoutesProjectsActivateCustomAgentRequest,
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Activate an Existing Custom Agent

        Activate an existing custom agent in a project.

        :param routes_projects_activate_custom_agent_request: (required)
        :type routes_projects_activate_custom_agent_request: RoutesProjectsActivateCustomAgentRequest
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._activate_custom_agent_agents_activate_post_serialize(
            routes_projects_activate_custom_agent_request=routes_projects_activate_custom_agent_request,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ActivateCustomAgentResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _activate_custom_agent_agents_activate_post_serialize(
        self,
        routes_projects_activate_custom_agent_request,
        x_api_key,
        x_api_secret,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if x_api_key is not None:
            _header_params['X-API-KEY'] = x_api_key
        if x_api_secret is not None:
            _header_params['X-API-SECRET'] = x_api_secret
        # process the form parameters
        # process the body parameter
        if routes_projects_activate_custom_agent_request is not None:
            _body_params = routes_projects_activate_custom_agent_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/agents/activate',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def edit_existing_custom_agent_agents_edit_post(
        self,
        edit_existing_custom_agent: EditExistingCustomAgent,
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EditExistingCustomAgentResponse:
        """Edit an Existing Custom Agent

        Edit an existing custom agent in a project. <br><br> The most complex component of the API is the <b>building_blocks</b> field. It is an array of json objects, each of which represents a building block that can be attached to the agent.<br> Each block is identified by the \"name\" field in its json structure. It is <b>vital</b> that the names are provided correctly, or the blocks will not be reconstituted properly.<br> The types of the building blocks available, and their json structure, is as follows:  <ul> <li> <b>Enhanced Search</b><ul> <li>name: enhanced_search</li> <li>Improved version of basic chat with KB, using multiple calls to the LLM and vector search to refine and source the answer.</li> <li>Resource-intensive. Does not support basic GPT-3.5 model.</li> <li>json format: <code>{\"name\": \"enhanced_search\", \"answered_rules\": [\"Say 'thank you'.\"], \"group_on_backend\": false}</code></li> <li>JSON keys: <ul>     <li><b>name</b> - identifier for the block, must be \"enhanced_search\"</li>     <li><b>answered_rules</b> - array of strings defining rules for how the agent should answer the user when the user indicates that their initial query has been satisfactorily resolved.</li>     <li><b>group_on_backend</b> - whether to group search results by source before they go into the language model. Enabling this will increase the diversity of sources available to the model.</li> </ul></li> </ul> </li> </ul>

        :param edit_existing_custom_agent: (required)
        :type edit_existing_custom_agent: EditExistingCustomAgent
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_existing_custom_agent_agents_edit_post_serialize(
            edit_existing_custom_agent=edit_existing_custom_agent,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EditExistingCustomAgentResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def edit_existing_custom_agent_agents_edit_post_with_http_info(
        self,
        edit_existing_custom_agent: EditExistingCustomAgent,
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EditExistingCustomAgentResponse]:
        """Edit an Existing Custom Agent

        Edit an existing custom agent in a project. <br><br> The most complex component of the API is the <b>building_blocks</b> field. It is an array of json objects, each of which represents a building block that can be attached to the agent.<br> Each block is identified by the \"name\" field in its json structure. It is <b>vital</b> that the names are provided correctly, or the blocks will not be reconstituted properly.<br> The types of the building blocks available, and their json structure, is as follows:  <ul> <li> <b>Enhanced Search</b><ul> <li>name: enhanced_search</li> <li>Improved version of basic chat with KB, using multiple calls to the LLM and vector search to refine and source the answer.</li> <li>Resource-intensive. Does not support basic GPT-3.5 model.</li> <li>json format: <code>{\"name\": \"enhanced_search\", \"answered_rules\": [\"Say 'thank you'.\"], \"group_on_backend\": false}</code></li> <li>JSON keys: <ul>     <li><b>name</b> - identifier for the block, must be \"enhanced_search\"</li>     <li><b>answered_rules</b> - array of strings defining rules for how the agent should answer the user when the user indicates that their initial query has been satisfactorily resolved.</li>     <li><b>group_on_backend</b> - whether to group search results by source before they go into the language model. Enabling this will increase the diversity of sources available to the model.</li> </ul></li> </ul> </li> </ul>

        :param edit_existing_custom_agent: (required)
        :type edit_existing_custom_agent: EditExistingCustomAgent
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_existing_custom_agent_agents_edit_post_serialize(
            edit_existing_custom_agent=edit_existing_custom_agent,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EditExistingCustomAgentResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def edit_existing_custom_agent_agents_edit_post_without_preload_content(
        self,
        edit_existing_custom_agent: EditExistingCustomAgent,
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Edit an Existing Custom Agent

        Edit an existing custom agent in a project. <br><br> The most complex component of the API is the <b>building_blocks</b> field. It is an array of json objects, each of which represents a building block that can be attached to the agent.<br> Each block is identified by the \"name\" field in its json structure. It is <b>vital</b> that the names are provided correctly, or the blocks will not be reconstituted properly.<br> The types of the building blocks available, and their json structure, is as follows:  <ul> <li> <b>Enhanced Search</b><ul> <li>name: enhanced_search</li> <li>Improved version of basic chat with KB, using multiple calls to the LLM and vector search to refine and source the answer.</li> <li>Resource-intensive. Does not support basic GPT-3.5 model.</li> <li>json format: <code>{\"name\": \"enhanced_search\", \"answered_rules\": [\"Say 'thank you'.\"], \"group_on_backend\": false}</code></li> <li>JSON keys: <ul>     <li><b>name</b> - identifier for the block, must be \"enhanced_search\"</li>     <li><b>answered_rules</b> - array of strings defining rules for how the agent should answer the user when the user indicates that their initial query has been satisfactorily resolved.</li>     <li><b>group_on_backend</b> - whether to group search results by source before they go into the language model. Enabling this will increase the diversity of sources available to the model.</li> </ul></li> </ul> </li> </ul>

        :param edit_existing_custom_agent: (required)
        :type edit_existing_custom_agent: EditExistingCustomAgent
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_existing_custom_agent_agents_edit_post_serialize(
            edit_existing_custom_agent=edit_existing_custom_agent,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EditExistingCustomAgentResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _edit_existing_custom_agent_agents_edit_post_serialize(
        self,
        edit_existing_custom_agent,
        x_api_key,
        x_api_secret,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if x_api_key is not None:
            _header_params['X-API-KEY'] = x_api_key
        if x_api_secret is not None:
            _header_params['X-API-SECRET'] = x_api_secret
        # process the form parameters
        # process the body parameter
        if edit_existing_custom_agent is not None:
            _body_params = edit_existing_custom_agent


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/agents/edit',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_agents_for_project_agents_project_id_list_get(
        self,
        project_id: Annotated[StrictStr, Field(description="ID of the project.")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListAgentsForProjectResponse:
        """List Agents for Project

        List all agents in a project, including default agents.

        :param project_id: ID of the project. (required)
        :type project_id: str
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_agents_for_project_agents_project_id_list_get_serialize(
            project_id=project_id,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListAgentsForProjectResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_agents_for_project_agents_project_id_list_get_with_http_info(
        self,
        project_id: Annotated[StrictStr, Field(description="ID of the project.")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListAgentsForProjectResponse]:
        """List Agents for Project

        List all agents in a project, including default agents.

        :param project_id: ID of the project. (required)
        :type project_id: str
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_agents_for_project_agents_project_id_list_get_serialize(
            project_id=project_id,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListAgentsForProjectResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_agents_for_project_agents_project_id_list_get_without_preload_content(
        self,
        project_id: Annotated[StrictStr, Field(description="ID of the project.")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Agents for Project

        List all agents in a project, including default agents.

        :param project_id: ID of the project. (required)
        :type project_id: str
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_agents_for_project_agents_project_id_list_get_serialize(
            project_id=project_id,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListAgentsForProjectResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_agents_for_project_agents_project_id_list_get_serialize(
        self,
        project_id,
        x_api_key,
        x_api_secret,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if project_id is not None:
            _path_params['project_id'] = project_id
        # process the query parameters
        # process the header parameters
        if x_api_key is not None:
            _header_params['X-API-KEY'] = x_api_key
        if x_api_secret is not None:
            _header_params['X-API-SECRET'] = x_api_secret
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/agents/{project_id}/list',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def save_new_custom_agent_agents_new_post(
        self,
        save_new_custom_agent: SaveNewCustomAgent,
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SaveNewCustomAgentResponse:
        """Save a New Custom Agent

        Save a new custom agent in a project. <br><br> The most complex component of the API is the <b>building_blocks</b> field. It is an array of json objects, each of which represents a building block that can be attached to the agent.<br> Each block is identified by the \"name\" field in its json structure. It is <b>vital</b> that the names are provided correctly, or the blocks will not be reconstituted properly.<br> The types of the building blocks available, and their json structure, is as follows:  <ul> <li> <b>Enhanced Search</b><ul> <li>name: enhanced_search</li> <li>Improved version of basic chat with KB, using multiple calls to the LLM and vector search to refine and source the answer.</li> <li>Resource-intensive. Does not support basic GPT-3.5 model.</li> <li>json format: <code>{\"name\": \"enhanced_search\", \"answered_rules\": [\"Say 'thank you'.\"], \"group_on_backend\": false}</code></li> <li>JSON keys: <ul>     <li><b>name</b> - identifier for the block, must be \"enhanced_search\"</li>     <li><b>answered_rules</b> - array of strings defining rules for how the agent should answer the user when the user indicates that their initial query has been satisfactorily resolved.</li>     <li><b>group_on_backend</b> - whether to group search results by source before they go into the language model. Enabling this will increase the diversity of sources available to the model.</li> </ul></li> </ul> </li> </ul>

        :param save_new_custom_agent: (required)
        :type save_new_custom_agent: SaveNewCustomAgent
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._save_new_custom_agent_agents_new_post_serialize(
            save_new_custom_agent=save_new_custom_agent,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SaveNewCustomAgentResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def save_new_custom_agent_agents_new_post_with_http_info(
        self,
        save_new_custom_agent: SaveNewCustomAgent,
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SaveNewCustomAgentResponse]:
        """Save a New Custom Agent

        Save a new custom agent in a project. <br><br> The most complex component of the API is the <b>building_blocks</b> field. It is an array of json objects, each of which represents a building block that can be attached to the agent.<br> Each block is identified by the \"name\" field in its json structure. It is <b>vital</b> that the names are provided correctly, or the blocks will not be reconstituted properly.<br> The types of the building blocks available, and their json structure, is as follows:  <ul> <li> <b>Enhanced Search</b><ul> <li>name: enhanced_search</li> <li>Improved version of basic chat with KB, using multiple calls to the LLM and vector search to refine and source the answer.</li> <li>Resource-intensive. Does not support basic GPT-3.5 model.</li> <li>json format: <code>{\"name\": \"enhanced_search\", \"answered_rules\": [\"Say 'thank you'.\"], \"group_on_backend\": false}</code></li> <li>JSON keys: <ul>     <li><b>name</b> - identifier for the block, must be \"enhanced_search\"</li>     <li><b>answered_rules</b> - array of strings defining rules for how the agent should answer the user when the user indicates that their initial query has been satisfactorily resolved.</li>     <li><b>group_on_backend</b> - whether to group search results by source before they go into the language model. Enabling this will increase the diversity of sources available to the model.</li> </ul></li> </ul> </li> </ul>

        :param save_new_custom_agent: (required)
        :type save_new_custom_agent: SaveNewCustomAgent
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._save_new_custom_agent_agents_new_post_serialize(
            save_new_custom_agent=save_new_custom_agent,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SaveNewCustomAgentResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def save_new_custom_agent_agents_new_post_without_preload_content(
        self,
        save_new_custom_agent: SaveNewCustomAgent,
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Save a New Custom Agent

        Save a new custom agent in a project. <br><br> The most complex component of the API is the <b>building_blocks</b> field. It is an array of json objects, each of which represents a building block that can be attached to the agent.<br> Each block is identified by the \"name\" field in its json structure. It is <b>vital</b> that the names are provided correctly, or the blocks will not be reconstituted properly.<br> The types of the building blocks available, and their json structure, is as follows:  <ul> <li> <b>Enhanced Search</b><ul> <li>name: enhanced_search</li> <li>Improved version of basic chat with KB, using multiple calls to the LLM and vector search to refine and source the answer.</li> <li>Resource-intensive. Does not support basic GPT-3.5 model.</li> <li>json format: <code>{\"name\": \"enhanced_search\", \"answered_rules\": [\"Say 'thank you'.\"], \"group_on_backend\": false}</code></li> <li>JSON keys: <ul>     <li><b>name</b> - identifier for the block, must be \"enhanced_search\"</li>     <li><b>answered_rules</b> - array of strings defining rules for how the agent should answer the user when the user indicates that their initial query has been satisfactorily resolved.</li>     <li><b>group_on_backend</b> - whether to group search results by source before they go into the language model. Enabling this will increase the diversity of sources available to the model.</li> </ul></li> </ul> </li> </ul>

        :param save_new_custom_agent: (required)
        :type save_new_custom_agent: SaveNewCustomAgent
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._save_new_custom_agent_agents_new_post_serialize(
            save_new_custom_agent=save_new_custom_agent,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SaveNewCustomAgentResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _save_new_custom_agent_agents_new_post_serialize(
        self,
        save_new_custom_agent,
        x_api_key,
        x_api_secret,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if x_api_key is not None:
            _header_params['X-API-KEY'] = x_api_key
        if x_api_secret is not None:
            _header_params['X-API-SECRET'] = x_api_secret
        # process the form parameters
        # process the body parameter
        if save_new_custom_agent is not None:
            _body_params = save_new_custom_agent


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/agents/new',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


