# coding: utf-8

"""
    API Docs

    API Documentation to interact with

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictBytes, StrictStr
from typing import Any, Optional, Tuple, Union
from typing_extensions import Annotated
from odin_sdk.models.batch_delete_request import BatchDeleteRequest
from odin_sdk.models.batch_delete_response import BatchDeleteResponse
from odin_sdk.models.routes_knowledgebase_knowledge_base_data_response import RoutesKnowledgebaseKnowledgeBaseDataResponse
from odin_sdk.models.sync_file_request_legacy import SyncFileRequestLegacy

from odin_sdk.api_client import ApiClient, RequestSerialized
from odin_sdk.api_response import ApiResponse
from odin_sdk.rest import RESTResponseType


class KnowledgeBaseApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def add_file_to_knowledge_base_v3_v3_project_knowledge_add_file_post(
        self,
        file: Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]],
        project_id: StrictStr,
        metadata: Optional[Any],
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        file_type: Optional[StrictStr] = None,
        force: Optional[StrictBool] = None,
        resource_type_id: Optional[StrictStr] = None,
        is_quick_upload: Optional[StrictBool] = None,
        data_type_id: Optional[StrictStr] = None,
        upload_signifier: Optional[StrictStr] = None,
        csv_delimiter: Optional[StrictStr] = None,
        path: Optional[StrictStr] = None,
        transcription_provider: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RoutesKnowledgebaseKnowledgeBaseDataResponse:
        """Add File To Knowledge Base V3

        Add files to the Knowledge Base with metadata extraction.

        :param file: (required)
        :type file: bytearray
        :param project_id: (required)
        :type project_id: str
        :param metadata: (required)
        :type metadata: object
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param file_type:
        :type file_type: str
        :param force:
        :type force: bool
        :param resource_type_id:
        :type resource_type_id: str
        :param is_quick_upload:
        :type is_quick_upload: bool
        :param data_type_id:
        :type data_type_id: str
        :param upload_signifier:
        :type upload_signifier: str
        :param csv_delimiter:
        :type csv_delimiter: str
        :param path:
        :type path: str
        :param transcription_provider:
        :type transcription_provider: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_file_to_knowledge_base_v3_v3_project_knowledge_add_file_post_serialize(
            file=file,
            project_id=project_id,
            metadata=metadata,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            file_type=file_type,
            force=force,
            resource_type_id=resource_type_id,
            is_quick_upload=is_quick_upload,
            data_type_id=data_type_id,
            upload_signifier=upload_signifier,
            csv_delimiter=csv_delimiter,
            path=path,
            transcription_provider=transcription_provider,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RoutesKnowledgebaseKnowledgeBaseDataResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def add_file_to_knowledge_base_v3_v3_project_knowledge_add_file_post_with_http_info(
        self,
        file: Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]],
        project_id: StrictStr,
        metadata: Optional[Any],
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        file_type: Optional[StrictStr] = None,
        force: Optional[StrictBool] = None,
        resource_type_id: Optional[StrictStr] = None,
        is_quick_upload: Optional[StrictBool] = None,
        data_type_id: Optional[StrictStr] = None,
        upload_signifier: Optional[StrictStr] = None,
        csv_delimiter: Optional[StrictStr] = None,
        path: Optional[StrictStr] = None,
        transcription_provider: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RoutesKnowledgebaseKnowledgeBaseDataResponse]:
        """Add File To Knowledge Base V3

        Add files to the Knowledge Base with metadata extraction.

        :param file: (required)
        :type file: bytearray
        :param project_id: (required)
        :type project_id: str
        :param metadata: (required)
        :type metadata: object
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param file_type:
        :type file_type: str
        :param force:
        :type force: bool
        :param resource_type_id:
        :type resource_type_id: str
        :param is_quick_upload:
        :type is_quick_upload: bool
        :param data_type_id:
        :type data_type_id: str
        :param upload_signifier:
        :type upload_signifier: str
        :param csv_delimiter:
        :type csv_delimiter: str
        :param path:
        :type path: str
        :param transcription_provider:
        :type transcription_provider: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_file_to_knowledge_base_v3_v3_project_knowledge_add_file_post_serialize(
            file=file,
            project_id=project_id,
            metadata=metadata,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            file_type=file_type,
            force=force,
            resource_type_id=resource_type_id,
            is_quick_upload=is_quick_upload,
            data_type_id=data_type_id,
            upload_signifier=upload_signifier,
            csv_delimiter=csv_delimiter,
            path=path,
            transcription_provider=transcription_provider,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RoutesKnowledgebaseKnowledgeBaseDataResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def add_file_to_knowledge_base_v3_v3_project_knowledge_add_file_post_without_preload_content(
        self,
        file: Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]],
        project_id: StrictStr,
        metadata: Optional[Any],
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        file_type: Optional[StrictStr] = None,
        force: Optional[StrictBool] = None,
        resource_type_id: Optional[StrictStr] = None,
        is_quick_upload: Optional[StrictBool] = None,
        data_type_id: Optional[StrictStr] = None,
        upload_signifier: Optional[StrictStr] = None,
        csv_delimiter: Optional[StrictStr] = None,
        path: Optional[StrictStr] = None,
        transcription_provider: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add File To Knowledge Base V3

        Add files to the Knowledge Base with metadata extraction.

        :param file: (required)
        :type file: bytearray
        :param project_id: (required)
        :type project_id: str
        :param metadata: (required)
        :type metadata: object
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param file_type:
        :type file_type: str
        :param force:
        :type force: bool
        :param resource_type_id:
        :type resource_type_id: str
        :param is_quick_upload:
        :type is_quick_upload: bool
        :param data_type_id:
        :type data_type_id: str
        :param upload_signifier:
        :type upload_signifier: str
        :param csv_delimiter:
        :type csv_delimiter: str
        :param path:
        :type path: str
        :param transcription_provider:
        :type transcription_provider: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_file_to_knowledge_base_v3_v3_project_knowledge_add_file_post_serialize(
            file=file,
            project_id=project_id,
            metadata=metadata,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            file_type=file_type,
            force=force,
            resource_type_id=resource_type_id,
            is_quick_upload=is_quick_upload,
            data_type_id=data_type_id,
            upload_signifier=upload_signifier,
            csv_delimiter=csv_delimiter,
            path=path,
            transcription_provider=transcription_provider,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RoutesKnowledgebaseKnowledgeBaseDataResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_file_to_knowledge_base_v3_v3_project_knowledge_add_file_post_serialize(
        self,
        file,
        project_id,
        metadata,
        x_api_key,
        x_api_secret,
        file_type,
        force,
        resource_type_id,
        is_quick_upload,
        data_type_id,
        upload_signifier,
        csv_delimiter,
        path,
        transcription_provider,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if x_api_key is not None:
            _header_params['X-API-KEY'] = x_api_key
        if x_api_secret is not None:
            _header_params['X-API-SECRET'] = x_api_secret
        # process the form parameters
        if file is not None:
            _files['file'] = file
        if project_id is not None:
            _form_params.append(('project_id', project_id))
        if metadata is not None:
            _form_params.append(('metadata', metadata))
        if file_type is not None:
            _form_params.append(('file_type', file_type))
        if force is not None:
            _form_params.append(('force', force))
        if resource_type_id is not None:
            _form_params.append(('resource_type_id', resource_type_id))
        if is_quick_upload is not None:
            _form_params.append(('is_quick_upload', is_quick_upload))
        if data_type_id is not None:
            _form_params.append(('data_type_id', data_type_id))
        if upload_signifier is not None:
            _form_params.append(('upload_signifier', upload_signifier))
        if csv_delimiter is not None:
            _form_params.append(('csv_delimiter', csv_delimiter))
        if path is not None:
            _form_params.append(('path', path))
        if transcription_provider is not None:
            _form_params.append(('transcription_provider', transcription_provider))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v3/project/knowledge/add/file',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def batch_delete_project_knowledge_delete_delete(
        self,
        batch_delete_request: BatchDeleteRequest,
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BatchDeleteResponse:
        """Batch Delete

        Deletes the selected resources.

        :param batch_delete_request: (required)
        :type batch_delete_request: BatchDeleteRequest
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._batch_delete_project_knowledge_delete_delete_serialize(
            batch_delete_request=batch_delete_request,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BatchDeleteResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def batch_delete_project_knowledge_delete_delete_with_http_info(
        self,
        batch_delete_request: BatchDeleteRequest,
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BatchDeleteResponse]:
        """Batch Delete

        Deletes the selected resources.

        :param batch_delete_request: (required)
        :type batch_delete_request: BatchDeleteRequest
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._batch_delete_project_knowledge_delete_delete_serialize(
            batch_delete_request=batch_delete_request,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BatchDeleteResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def batch_delete_project_knowledge_delete_delete_without_preload_content(
        self,
        batch_delete_request: BatchDeleteRequest,
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Batch Delete

        Deletes the selected resources.

        :param batch_delete_request: (required)
        :type batch_delete_request: BatchDeleteRequest
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._batch_delete_project_knowledge_delete_delete_serialize(
            batch_delete_request=batch_delete_request,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BatchDeleteResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _batch_delete_project_knowledge_delete_delete_serialize(
        self,
        batch_delete_request,
        x_api_key,
        x_api_secret,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if x_api_key is not None:
            _header_params['X-API-KEY'] = x_api_key
        if x_api_secret is not None:
            _header_params['X-API-SECRET'] = x_api_secret
        # process the form parameters
        # process the body parameter
        if batch_delete_request is not None:
            _body_params = batch_delete_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/project/knowledge/delete',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def sync_kb_file_v2_v2_project_knowledge_sync_file_post(
        self,
        sync_file_request_legacy: SyncFileRequestLegacy,
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RoutesKnowledgebaseKnowledgeBaseDataResponse:
        """Sync Kb File V2

        Sync files to the Knowledge Base.

        :param sync_file_request_legacy: (required)
        :type sync_file_request_legacy: SyncFileRequestLegacy
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sync_kb_file_v2_v2_project_knowledge_sync_file_post_serialize(
            sync_file_request_legacy=sync_file_request_legacy,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RoutesKnowledgebaseKnowledgeBaseDataResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def sync_kb_file_v2_v2_project_knowledge_sync_file_post_with_http_info(
        self,
        sync_file_request_legacy: SyncFileRequestLegacy,
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RoutesKnowledgebaseKnowledgeBaseDataResponse]:
        """Sync Kb File V2

        Sync files to the Knowledge Base.

        :param sync_file_request_legacy: (required)
        :type sync_file_request_legacy: SyncFileRequestLegacy
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sync_kb_file_v2_v2_project_knowledge_sync_file_post_serialize(
            sync_file_request_legacy=sync_file_request_legacy,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RoutesKnowledgebaseKnowledgeBaseDataResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def sync_kb_file_v2_v2_project_knowledge_sync_file_post_without_preload_content(
        self,
        sync_file_request_legacy: SyncFileRequestLegacy,
        x_api_key: Annotated[Optional[StrictStr], Field(description="Your Odin API key.")] = None,
        x_api_secret: Annotated[Optional[StrictStr], Field(description="Your Odin API secret.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Sync Kb File V2

        Sync files to the Knowledge Base.

        :param sync_file_request_legacy: (required)
        :type sync_file_request_legacy: SyncFileRequestLegacy
        :param x_api_key: Your Odin API key.
        :type x_api_key: str
        :param x_api_secret: Your Odin API secret.
        :type x_api_secret: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sync_kb_file_v2_v2_project_knowledge_sync_file_post_serialize(
            sync_file_request_legacy=sync_file_request_legacy,
            x_api_key=x_api_key,
            x_api_secret=x_api_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RoutesKnowledgebaseKnowledgeBaseDataResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _sync_kb_file_v2_v2_project_knowledge_sync_file_post_serialize(
        self,
        sync_file_request_legacy,
        x_api_key,
        x_api_secret,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if x_api_key is not None:
            _header_params['X-API-KEY'] = x_api_key
        if x_api_secret is not None:
            _header_params['X-API-SECRET'] = x_api_secret
        # process the form parameters
        # process the body parameter
        if sync_file_request_legacy is not None:
            _body_params = sync_file_request_legacy


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v2/project/knowledge/sync/file',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


