# coding: utf-8

"""
    API Docs

    API Documentation to interact with

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ComputeColumnStatusResponse(BaseModel):
    """
    ComputeColumnStatusResponse
    """ # noqa: E501
    message: StrictStr
    execution_id: StrictStr
    status: StrictStr
    progress_percentage: Union[StrictFloat, StrictInt]
    processed_rows: StrictInt
    total_rows: Optional[StrictInt]
    updated_rows: StrictInt
    failed_rows: List[StrictInt]
    started_at: Optional[StrictStr]
    completed_at: Optional[StrictStr]
    error_message: Optional[StrictStr]
    metadata: Dict[str, Any]
    __properties: ClassVar[List[str]] = ["message", "execution_id", "status", "progress_percentage", "processed_rows", "total_rows", "updated_rows", "failed_rows", "started_at", "completed_at", "error_message", "metadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ComputeColumnStatusResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if total_rows (nullable) is None
        # and model_fields_set contains the field
        if self.total_rows is None and "total_rows" in self.model_fields_set:
            _dict['total_rows'] = None

        # set to None if started_at (nullable) is None
        # and model_fields_set contains the field
        if self.started_at is None and "started_at" in self.model_fields_set:
            _dict['started_at'] = None

        # set to None if completed_at (nullable) is None
        # and model_fields_set contains the field
        if self.completed_at is None and "completed_at" in self.model_fields_set:
            _dict['completed_at'] = None

        # set to None if error_message (nullable) is None
        # and model_fields_set contains the field
        if self.error_message is None and "error_message" in self.model_fields_set:
            _dict['error_message'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ComputeColumnStatusResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "message": obj.get("message"),
            "execution_id": obj.get("execution_id"),
            "status": obj.get("status"),
            "progress_percentage": obj.get("progress_percentage"),
            "processed_rows": obj.get("processed_rows"),
            "total_rows": obj.get("total_rows"),
            "updated_rows": obj.get("updated_rows"),
            "failed_rows": obj.get("failed_rows"),
            "started_at": obj.get("started_at"),
            "completed_at": obj.get("completed_at"),
            "error_message": obj.get("error_message"),
            "metadata": obj.get("metadata")
        })
        return _obj


