# coding: utf-8

"""
    API Docs

    API Documentation to interact with

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from odin_sdk.models.personality_id import PersonalityId
from typing import Optional, Set
from typing_extensions import Self

class CreateProjectRequest(BaseModel):
    """
    CreateProjectRequest
    """ # noqa: E501
    project_name: StrictStr
    project_description: StrictStr
    project_type: Optional[StrictStr] = None
    personality_name: Optional[StrictStr] = None
    personality_instructions: Optional[StrictStr] = None
    personality_id: Optional[PersonalityId] = None
    personality_type: Optional[StrictStr] = None
    personality_temperature: Optional[Union[StrictFloat, StrictInt]] = None
    __properties: ClassVar[List[str]] = ["project_name", "project_description", "project_type", "personality_name", "personality_instructions", "personality_id", "personality_type", "personality_temperature"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateProjectRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of personality_id
        if self.personality_id:
            _dict['personality_id'] = self.personality_id.to_dict()
        # set to None if project_type (nullable) is None
        # and model_fields_set contains the field
        if self.project_type is None and "project_type" in self.model_fields_set:
            _dict['project_type'] = None

        # set to None if personality_name (nullable) is None
        # and model_fields_set contains the field
        if self.personality_name is None and "personality_name" in self.model_fields_set:
            _dict['personality_name'] = None

        # set to None if personality_instructions (nullable) is None
        # and model_fields_set contains the field
        if self.personality_instructions is None and "personality_instructions" in self.model_fields_set:
            _dict['personality_instructions'] = None

        # set to None if personality_id (nullable) is None
        # and model_fields_set contains the field
        if self.personality_id is None and "personality_id" in self.model_fields_set:
            _dict['personality_id'] = None

        # set to None if personality_type (nullable) is None
        # and model_fields_set contains the field
        if self.personality_type is None and "personality_type" in self.model_fields_set:
            _dict['personality_type'] = None

        # set to None if personality_temperature (nullable) is None
        # and model_fields_set contains the field
        if self.personality_temperature is None and "personality_temperature" in self.model_fields_set:
            _dict['personality_temperature'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateProjectRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "project_name": obj.get("project_name"),
            "project_description": obj.get("project_description"),
            "project_type": obj.get("project_type"),
            "personality_name": obj.get("personality_name"),
            "personality_instructions": obj.get("personality_instructions"),
            "personality_id": PersonalityId.from_dict(obj["personality_id"]) if obj.get("personality_id") is not None else None,
            "personality_type": obj.get("personality_type"),
            "personality_temperature": obj.get("personality_temperature")
        })
        return _obj


