# coding: utf-8

"""
    API Docs

    API Documentation to interact with

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CreateViewRequest(BaseModel):
    """
    CreateViewRequest
    """ # noqa: E501
    name: StrictStr = Field(description="Name of the view")
    description: Optional[StrictStr] = None
    type: Optional[StrictStr] = Field(default='grid', description="Type of view (grid, kanban, etc)")
    sort: Optional[Dict[str, Any]] = None
    filter: Optional[Dict[str, Any]] = None
    group: Optional[Dict[str, Any]] = None
    options: Optional[Dict[str, Any]] = None
    settings: Optional[Dict[str, Any]] = None
    column_meta: Optional[Dict[str, Any]] = None
    enable_share: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["name", "description", "type", "sort", "filter", "group", "options", "settings", "column_meta", "enable_share"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateViewRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if sort (nullable) is None
        # and model_fields_set contains the field
        if self.sort is None and "sort" in self.model_fields_set:
            _dict['sort'] = None

        # set to None if filter (nullable) is None
        # and model_fields_set contains the field
        if self.filter is None and "filter" in self.model_fields_set:
            _dict['filter'] = None

        # set to None if group (nullable) is None
        # and model_fields_set contains the field
        if self.group is None and "group" in self.model_fields_set:
            _dict['group'] = None

        # set to None if options (nullable) is None
        # and model_fields_set contains the field
        if self.options is None and "options" in self.model_fields_set:
            _dict['options'] = None

        # set to None if settings (nullable) is None
        # and model_fields_set contains the field
        if self.settings is None and "settings" in self.model_fields_set:
            _dict['settings'] = None

        # set to None if column_meta (nullable) is None
        # and model_fields_set contains the field
        if self.column_meta is None and "column_meta" in self.model_fields_set:
            _dict['column_meta'] = None

        # set to None if enable_share (nullable) is None
        # and model_fields_set contains the field
        if self.enable_share is None and "enable_share" in self.model_fields_set:
            _dict['enable_share'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateViewRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "type": obj.get("type") if obj.get("type") is not None else 'grid',
            "sort": obj.get("sort"),
            "filter": obj.get("filter"),
            "group": obj.get("group"),
            "options": obj.get("options"),
            "settings": obj.get("settings"),
            "column_meta": obj.get("column_meta"),
            "enable_share": obj.get("enable_share")
        })
        return _obj


