# coding: utf-8

"""
    API Docs

    API Documentation to interact with

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DTField(BaseModel):
    """
    DTField
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier for the field")
    name: StrictStr = Field(description="Name of the field")
    description: Optional[StrictStr] = None
    options: Optional[Dict[str, Any]] = None
    type: StrictStr = Field(description="Field type (e.g., text, number, etc.)")
    cell_value_type: StrictStr = Field(description="Type of value stored in cells")
    is_multiple_cell_value: Optional[StrictBool] = Field(default=False, description="Whether field can contain multiple values")
    db_field_type: StrictStr = Field(description="Database field type")
    db_field_name: StrictStr = Field(description="Name of the field in database")
    not_null: Optional[StrictBool] = Field(default=False, description="Whether field is required")
    unique: Optional[StrictBool] = Field(default=False, description="Whether field values must be unique")
    is_primary: Optional[StrictBool] = Field(default=False, description="Whether field is primary key")
    is_computed: Optional[StrictBool] = Field(default=False, description="Whether field is computed")
    is_lookup: Optional[StrictBool] = Field(default=False, description="Whether field is a lookup field")
    is_pending: Optional[StrictBool] = Field(default=False, description="Whether field is pending creation")
    has_error: Optional[StrictBool] = Field(default=False, description="Whether field has errors")
    lookup_linked_field_id: Optional[StrictStr] = None
    lookup_options: Optional[StrictStr] = None
    table_id: StrictStr = Field(description="ID of the table this field belongs to")
    version: Optional[StrictInt] = Field(default=1, description="Version number of the field")
    created_time: Optional[datetime] = Field(default=None, description="Creation timestamp")
    last_modified_time: Optional[datetime] = None
    deleted_time: Optional[datetime] = None
    created_by: StrictStr = Field(description="User ID who created the field")
    last_modified_by: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "name", "description", "options", "type", "cell_value_type", "is_multiple_cell_value", "db_field_type", "db_field_name", "not_null", "unique", "is_primary", "is_computed", "is_lookup", "is_pending", "has_error", "lookup_linked_field_id", "lookup_options", "table_id", "version", "created_time", "last_modified_time", "deleted_time", "created_by", "last_modified_by"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DTField from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if options (nullable) is None
        # and model_fields_set contains the field
        if self.options is None and "options" in self.model_fields_set:
            _dict['options'] = None

        # set to None if lookup_linked_field_id (nullable) is None
        # and model_fields_set contains the field
        if self.lookup_linked_field_id is None and "lookup_linked_field_id" in self.model_fields_set:
            _dict['lookup_linked_field_id'] = None

        # set to None if lookup_options (nullable) is None
        # and model_fields_set contains the field
        if self.lookup_options is None and "lookup_options" in self.model_fields_set:
            _dict['lookup_options'] = None

        # set to None if last_modified_time (nullable) is None
        # and model_fields_set contains the field
        if self.last_modified_time is None and "last_modified_time" in self.model_fields_set:
            _dict['last_modified_time'] = None

        # set to None if deleted_time (nullable) is None
        # and model_fields_set contains the field
        if self.deleted_time is None and "deleted_time" in self.model_fields_set:
            _dict['deleted_time'] = None

        # set to None if last_modified_by (nullable) is None
        # and model_fields_set contains the field
        if self.last_modified_by is None and "last_modified_by" in self.model_fields_set:
            _dict['last_modified_by'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DTField from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "options": obj.get("options"),
            "type": obj.get("type"),
            "cell_value_type": obj.get("cell_value_type"),
            "is_multiple_cell_value": obj.get("is_multiple_cell_value") if obj.get("is_multiple_cell_value") is not None else False,
            "db_field_type": obj.get("db_field_type"),
            "db_field_name": obj.get("db_field_name"),
            "not_null": obj.get("not_null") if obj.get("not_null") is not None else False,
            "unique": obj.get("unique") if obj.get("unique") is not None else False,
            "is_primary": obj.get("is_primary") if obj.get("is_primary") is not None else False,
            "is_computed": obj.get("is_computed") if obj.get("is_computed") is not None else False,
            "is_lookup": obj.get("is_lookup") if obj.get("is_lookup") is not None else False,
            "is_pending": obj.get("is_pending") if obj.get("is_pending") is not None else False,
            "has_error": obj.get("has_error") if obj.get("has_error") is not None else False,
            "lookup_linked_field_id": obj.get("lookup_linked_field_id"),
            "lookup_options": obj.get("lookup_options"),
            "table_id": obj.get("table_id"),
            "version": obj.get("version") if obj.get("version") is not None else 1,
            "created_time": obj.get("created_time"),
            "last_modified_time": obj.get("last_modified_time"),
            "deleted_time": obj.get("deleted_time"),
            "created_by": obj.get("created_by"),
            "last_modified_by": obj.get("last_modified_by")
        })
        return _obj


