# coding: utf-8

"""
    API Docs

    API Documentation to interact with

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class EditExistingCustomAgent(BaseModel):
    """
    EditExistingCustomAgent
    """ # noqa: E501
    project_id: StrictStr = Field(description="ID of the project in which to create the agent.")
    agent_name: StrictStr = Field(description="Custom name of the agent.")
    edit_agent_id: StrictStr = Field(description="ID of the agent to edit.")
    personality: Optional[StrictStr] = Field(default='You are a helpful agent.', description="Personality definition of the agent.")
    building_blocks: Optional[List[Dict[str, Any]]] = None
    temperature: Optional[Union[StrictFloat, StrictInt]] = None
    mask_urls: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["project_id", "agent_name", "edit_agent_id", "personality", "building_blocks", "temperature", "mask_urls"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EditExistingCustomAgent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if building_blocks (nullable) is None
        # and model_fields_set contains the field
        if self.building_blocks is None and "building_blocks" in self.model_fields_set:
            _dict['building_blocks'] = None

        # set to None if temperature (nullable) is None
        # and model_fields_set contains the field
        if self.temperature is None and "temperature" in self.model_fields_set:
            _dict['temperature'] = None

        # set to None if mask_urls (nullable) is None
        # and model_fields_set contains the field
        if self.mask_urls is None and "mask_urls" in self.model_fields_set:
            _dict['mask_urls'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EditExistingCustomAgent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "project_id": obj.get("project_id"),
            "agent_name": obj.get("agent_name"),
            "edit_agent_id": obj.get("edit_agent_id"),
            "personality": obj.get("personality") if obj.get("personality") is not None else 'You are a helpful agent.',
            "building_blocks": obj.get("building_blocks"),
            "temperature": obj.get("temperature"),
            "mask_urls": obj.get("mask_urls")
        })
        return _obj


