# coding: utf-8

"""
    API Docs

    API Documentation to interact with

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class GetChatResponse(BaseModel):
    """
    GetChatResponse
    """ # noqa: E501
    id: StrictStr
    metadata: Optional[Dict[str, Any]] = None
    created_at: Optional[Union[StrictFloat, StrictInt]] = None
    messages: Optional[List[Any]] = None
    name: Optional[StrictStr] = None
    document_id: Optional[StrictStr] = None
    document_keys: Optional[List[Any]] = None
    custom_agent: Optional[StrictStr] = None
    chat_files_metadata: Optional[List[Any]] = None
    debug_prompt_info: Optional[Dict[str, Any]] = None
    __properties: ClassVar[List[str]] = ["id", "metadata", "created_at", "messages", "name", "document_id", "document_keys", "custom_agent", "chat_files_metadata", "debug_prompt_info"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetChatResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['created_at'] = None

        # set to None if messages (nullable) is None
        # and model_fields_set contains the field
        if self.messages is None and "messages" in self.model_fields_set:
            _dict['messages'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if document_id (nullable) is None
        # and model_fields_set contains the field
        if self.document_id is None and "document_id" in self.model_fields_set:
            _dict['document_id'] = None

        # set to None if document_keys (nullable) is None
        # and model_fields_set contains the field
        if self.document_keys is None and "document_keys" in self.model_fields_set:
            _dict['document_keys'] = None

        # set to None if custom_agent (nullable) is None
        # and model_fields_set contains the field
        if self.custom_agent is None and "custom_agent" in self.model_fields_set:
            _dict['custom_agent'] = None

        # set to None if chat_files_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.chat_files_metadata is None and "chat_files_metadata" in self.model_fields_set:
            _dict['chat_files_metadata'] = None

        # set to None if debug_prompt_info (nullable) is None
        # and model_fields_set contains the field
        if self.debug_prompt_info is None and "debug_prompt_info" in self.model_fields_set:
            _dict['debug_prompt_info'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetChatResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "metadata": obj.get("metadata"),
            "created_at": obj.get("created_at"),
            "messages": obj.get("messages"),
            "name": obj.get("name"),
            "document_id": obj.get("document_id"),
            "document_keys": obj.get("document_keys"),
            "custom_agent": obj.get("custom_agent"),
            "chat_files_metadata": obj.get("chat_files_metadata"),
            "debug_prompt_info": obj.get("debug_prompt_info")
        })
        return _obj


