# coding: utf-8

"""
    API Docs

    API Documentation to interact with

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from odin_sdk.models.dt_field import DTField
from typing import Optional, Set
from typing_extensions import Self

class GetGroupedDataTypeViewResponse(BaseModel):
    """
    GetGroupedDataTypeViewResponse
    """ # noqa: E501
    message: StrictStr
    grouped_data: List[Dict[str, Any]]
    data_schema: List[DTField]
    views: List[Dict[str, Any]]
    total_count: StrictInt
    group_config: Dict[str, Any]
    __properties: ClassVar[List[str]] = ["message", "grouped_data", "data_schema", "views", "total_count", "group_config"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetGroupedDataTypeViewResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in data_schema (list)
        _items = []
        if self.data_schema:
            for _item_data_schema in self.data_schema:
                if _item_data_schema:
                    _items.append(_item_data_schema.to_dict())
            _dict['data_schema'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetGroupedDataTypeViewResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "message": obj.get("message"),
            "grouped_data": obj.get("grouped_data"),
            "data_schema": [DTField.from_dict(_item) for _item in obj["data_schema"]] if obj.get("data_schema") is not None else None,
            "views": obj.get("views"),
            "total_count": obj.get("total_count"),
            "group_config": obj.get("group_config")
        })
        return _obj


