# coding: utf-8

"""
    API Docs

    API Documentation to interact with

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from odin_sdk.models.api_key import APIKey
from odin_sdk.models.custom_chatbot import CustomChatbot
from odin_sdk.models.kb_info import KbInfo
from odin_sdk.models.routes_projects_member import RoutesProjectsMember
from typing import Optional, Set
from typing_extensions import Self

class Project(BaseModel):
    """
    Project
    """ # noqa: E501
    id: StrictStr
    name: StrictStr
    owner: Optional[StrictStr] = None
    created_at: Optional[Union[StrictFloat, StrictInt]] = None
    type: Optional[StrictStr] = None
    model_name: Optional[StrictStr] = None
    members: Optional[List[RoutesProjectsMember]]
    description: Optional[StrictStr] = None
    is_favorite: Optional[StrictBool] = None
    kb_info: Optional[KbInfo] = None
    kb_last_synced: Optional[Union[StrictFloat, StrictInt]] = None
    kb_status: Optional[StrictStr] = None
    kb_sync_schedule: Optional[Union[StrictFloat, StrictInt]] = None
    blacklisted_docs: Optional[List[StrictStr]] = None
    team_id: Optional[StrictStr] = None
    system_prompt: Optional[Any] = None
    custom_agent: Optional[StrictStr] = None
    custom_agent_name: Optional[StrictStr] = None
    updated_at: Optional[Union[StrictFloat, StrictInt]] = None
    is_public: Optional[StrictBool] = None
    use_textract: Optional[StrictBool] = None
    mask_pii: Optional[StrictBool] = None
    inline_citations: Optional[StrictBool] = None
    custom_chatbot: Optional[CustomChatbot] = None
    feedback_history: Optional[List[Any]] = None
    api_keys: Optional[APIKey] = None
    kb_version: Optional[StrictInt] = None
    embedding_model: Optional[StrictStr] = None
    teamsbot_upload_method: Optional[StrictStr] = None
    teamsbot_static_message_footer: Optional[StrictStr] = None
    teamsbot_show_feedback_buttons: Optional[StrictBool] = None
    teamsbot_show_kb_search_message: Optional[StrictBool] = None
    teamsbot_show_message_sources: Optional[StrictBool] = None
    shared_to_team: Optional[StrictBool] = None
    team_default_role: Optional[StrictStr] = None
    enable_automator_v2: Optional[StrictBool] = None
    shared: Optional[StrictStr] = None
    owner_name: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "name", "owner", "created_at", "type", "model_name", "members", "description", "is_favorite", "kb_info", "kb_last_synced", "kb_status", "kb_sync_schedule", "blacklisted_docs", "team_id", "system_prompt", "custom_agent", "custom_agent_name", "updated_at", "is_public", "use_textract", "mask_pii", "inline_citations", "custom_chatbot", "feedback_history", "api_keys", "kb_version", "embedding_model", "teamsbot_upload_method", "teamsbot_static_message_footer", "teamsbot_show_feedback_buttons", "teamsbot_show_kb_search_message", "teamsbot_show_message_sources", "shared_to_team", "team_default_role", "enable_automator_v2", "shared", "owner_name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Project from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in members (list)
        _items = []
        if self.members:
            for _item_members in self.members:
                if _item_members:
                    _items.append(_item_members.to_dict())
            _dict['members'] = _items
        # override the default output from pydantic by calling `to_dict()` of kb_info
        if self.kb_info:
            _dict['kb_info'] = self.kb_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of system_prompt
        if self.system_prompt:
            _dict['system_prompt'] = self.system_prompt.to_dict()
        # override the default output from pydantic by calling `to_dict()` of custom_chatbot
        if self.custom_chatbot:
            _dict['custom_chatbot'] = self.custom_chatbot.to_dict()
        # override the default output from pydantic by calling `to_dict()` of api_keys
        if self.api_keys:
            _dict['api_keys'] = self.api_keys.to_dict()
        # set to None if owner (nullable) is None
        # and model_fields_set contains the field
        if self.owner is None and "owner" in self.model_fields_set:
            _dict['owner'] = None

        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['created_at'] = None

        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if model_name (nullable) is None
        # and model_fields_set contains the field
        if self.model_name is None and "model_name" in self.model_fields_set:
            _dict['model_name'] = None

        # set to None if members (nullable) is None
        # and model_fields_set contains the field
        if self.members is None and "members" in self.model_fields_set:
            _dict['members'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if is_favorite (nullable) is None
        # and model_fields_set contains the field
        if self.is_favorite is None and "is_favorite" in self.model_fields_set:
            _dict['is_favorite'] = None

        # set to None if kb_info (nullable) is None
        # and model_fields_set contains the field
        if self.kb_info is None and "kb_info" in self.model_fields_set:
            _dict['kb_info'] = None

        # set to None if kb_last_synced (nullable) is None
        # and model_fields_set contains the field
        if self.kb_last_synced is None and "kb_last_synced" in self.model_fields_set:
            _dict['kb_last_synced'] = None

        # set to None if kb_status (nullable) is None
        # and model_fields_set contains the field
        if self.kb_status is None and "kb_status" in self.model_fields_set:
            _dict['kb_status'] = None

        # set to None if kb_sync_schedule (nullable) is None
        # and model_fields_set contains the field
        if self.kb_sync_schedule is None and "kb_sync_schedule" in self.model_fields_set:
            _dict['kb_sync_schedule'] = None

        # set to None if blacklisted_docs (nullable) is None
        # and model_fields_set contains the field
        if self.blacklisted_docs is None and "blacklisted_docs" in self.model_fields_set:
            _dict['blacklisted_docs'] = None

        # set to None if team_id (nullable) is None
        # and model_fields_set contains the field
        if self.team_id is None and "team_id" in self.model_fields_set:
            _dict['team_id'] = None

        # set to None if system_prompt (nullable) is None
        # and model_fields_set contains the field
        if self.system_prompt is None and "system_prompt" in self.model_fields_set:
            _dict['system_prompt'] = None

        # set to None if custom_agent_name (nullable) is None
        # and model_fields_set contains the field
        if self.custom_agent_name is None and "custom_agent_name" in self.model_fields_set:
            _dict['custom_agent_name'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updated_at'] = None

        # set to None if is_public (nullable) is None
        # and model_fields_set contains the field
        if self.is_public is None and "is_public" in self.model_fields_set:
            _dict['is_public'] = None

        # set to None if use_textract (nullable) is None
        # and model_fields_set contains the field
        if self.use_textract is None and "use_textract" in self.model_fields_set:
            _dict['use_textract'] = None

        # set to None if mask_pii (nullable) is None
        # and model_fields_set contains the field
        if self.mask_pii is None and "mask_pii" in self.model_fields_set:
            _dict['mask_pii'] = None

        # set to None if inline_citations (nullable) is None
        # and model_fields_set contains the field
        if self.inline_citations is None and "inline_citations" in self.model_fields_set:
            _dict['inline_citations'] = None

        # set to None if custom_chatbot (nullable) is None
        # and model_fields_set contains the field
        if self.custom_chatbot is None and "custom_chatbot" in self.model_fields_set:
            _dict['custom_chatbot'] = None

        # set to None if feedback_history (nullable) is None
        # and model_fields_set contains the field
        if self.feedback_history is None and "feedback_history" in self.model_fields_set:
            _dict['feedback_history'] = None

        # set to None if api_keys (nullable) is None
        # and model_fields_set contains the field
        if self.api_keys is None and "api_keys" in self.model_fields_set:
            _dict['api_keys'] = None

        # set to None if kb_version (nullable) is None
        # and model_fields_set contains the field
        if self.kb_version is None and "kb_version" in self.model_fields_set:
            _dict['kb_version'] = None

        # set to None if embedding_model (nullable) is None
        # and model_fields_set contains the field
        if self.embedding_model is None and "embedding_model" in self.model_fields_set:
            _dict['embedding_model'] = None

        # set to None if teamsbot_upload_method (nullable) is None
        # and model_fields_set contains the field
        if self.teamsbot_upload_method is None and "teamsbot_upload_method" in self.model_fields_set:
            _dict['teamsbot_upload_method'] = None

        # set to None if teamsbot_static_message_footer (nullable) is None
        # and model_fields_set contains the field
        if self.teamsbot_static_message_footer is None and "teamsbot_static_message_footer" in self.model_fields_set:
            _dict['teamsbot_static_message_footer'] = None

        # set to None if teamsbot_show_feedback_buttons (nullable) is None
        # and model_fields_set contains the field
        if self.teamsbot_show_feedback_buttons is None and "teamsbot_show_feedback_buttons" in self.model_fields_set:
            _dict['teamsbot_show_feedback_buttons'] = None

        # set to None if teamsbot_show_kb_search_message (nullable) is None
        # and model_fields_set contains the field
        if self.teamsbot_show_kb_search_message is None and "teamsbot_show_kb_search_message" in self.model_fields_set:
            _dict['teamsbot_show_kb_search_message'] = None

        # set to None if teamsbot_show_message_sources (nullable) is None
        # and model_fields_set contains the field
        if self.teamsbot_show_message_sources is None and "teamsbot_show_message_sources" in self.model_fields_set:
            _dict['teamsbot_show_message_sources'] = None

        # set to None if shared_to_team (nullable) is None
        # and model_fields_set contains the field
        if self.shared_to_team is None and "shared_to_team" in self.model_fields_set:
            _dict['shared_to_team'] = None

        # set to None if team_default_role (nullable) is None
        # and model_fields_set contains the field
        if self.team_default_role is None and "team_default_role" in self.model_fields_set:
            _dict['team_default_role'] = None

        # set to None if enable_automator_v2 (nullable) is None
        # and model_fields_set contains the field
        if self.enable_automator_v2 is None and "enable_automator_v2" in self.model_fields_set:
            _dict['enable_automator_v2'] = None

        # set to None if shared (nullable) is None
        # and model_fields_set contains the field
        if self.shared is None and "shared" in self.model_fields_set:
            _dict['shared'] = None

        # set to None if owner_name (nullable) is None
        # and model_fields_set contains the field
        if self.owner_name is None and "owner_name" in self.model_fields_set:
            _dict['owner_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Project from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "owner": obj.get("owner"),
            "created_at": obj.get("created_at"),
            "type": obj.get("type"),
            "model_name": obj.get("model_name"),
            "members": [RoutesProjectsMember.from_dict(_item) for _item in obj["members"]] if obj.get("members") is not None else None,
            "description": obj.get("description"),
            "is_favorite": obj.get("is_favorite"),
            "kb_info": KbInfo.from_dict(obj["kb_info"]) if obj.get("kb_info") is not None else None,
            "kb_last_synced": obj.get("kb_last_synced"),
            "kb_status": obj.get("kb_status"),
            "kb_sync_schedule": obj.get("kb_sync_schedule"),
            "blacklisted_docs": obj.get("blacklisted_docs"),
            "team_id": obj.get("team_id"),
            "system_prompt": AnyOf.from_dict(obj["system_prompt"]) if obj.get("system_prompt") is not None else None,
            "custom_agent": obj.get("custom_agent"),
            "custom_agent_name": obj.get("custom_agent_name"),
            "updated_at": obj.get("updated_at"),
            "is_public": obj.get("is_public"),
            "use_textract": obj.get("use_textract"),
            "mask_pii": obj.get("mask_pii"),
            "inline_citations": obj.get("inline_citations"),
            "custom_chatbot": CustomChatbot.from_dict(obj["custom_chatbot"]) if obj.get("custom_chatbot") is not None else None,
            "feedback_history": obj.get("feedback_history"),
            "api_keys": APIKey.from_dict(obj["api_keys"]) if obj.get("api_keys") is not None else None,
            "kb_version": obj.get("kb_version"),
            "embedding_model": obj.get("embedding_model"),
            "teamsbot_upload_method": obj.get("teamsbot_upload_method"),
            "teamsbot_static_message_footer": obj.get("teamsbot_static_message_footer"),
            "teamsbot_show_feedback_buttons": obj.get("teamsbot_show_feedback_buttons"),
            "teamsbot_show_kb_search_message": obj.get("teamsbot_show_kb_search_message"),
            "teamsbot_show_message_sources": obj.get("teamsbot_show_message_sources"),
            "shared_to_team": obj.get("shared_to_team"),
            "team_default_role": obj.get("team_default_role"),
            "enable_automator_v2": obj.get("enable_automator_v2"),
            "shared": obj.get("shared"),
            "owner_name": obj.get("owner_name")
        })
        return _obj


