# coding: utf-8

"""
    API Docs

    API Documentation to interact with

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from odin_sdk.models.system_prompt_info import SystemPromptInfo
from typing import Optional, Set
from typing_extensions import Self

class ProjectInfo(BaseModel):
    """
    ProjectInfo
    """ # noqa: E501
    name: StrictStr
    created_at: Union[StrictFloat, StrictInt]
    members: List[StrictStr]
    owner: StrictStr
    description: StrictStr
    type: StrictStr
    model_name: StrictStr
    system_prompt: Optional[SystemPromptInfo] = None
    id: StrictStr
    __properties: ClassVar[List[str]] = ["name", "created_at", "members", "owner", "description", "type", "model_name", "system_prompt", "id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of system_prompt
        if self.system_prompt:
            _dict['system_prompt'] = self.system_prompt.to_dict()
        # set to None if system_prompt (nullable) is None
        # and model_fields_set contains the field
        if self.system_prompt is None and "system_prompt" in self.model_fields_set:
            _dict['system_prompt'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "created_at": obj.get("created_at"),
            "members": obj.get("members"),
            "owner": obj.get("owner"),
            "description": obj.get("description"),
            "type": obj.get("type"),
            "model_name": obj.get("model_name"),
            "system_prompt": SystemPromptInfo.from_dict(obj["system_prompt"]) if obj.get("system_prompt") is not None else None,
            "id": obj.get("id")
        })
        return _obj


