# coding: utf-8

"""
    API Docs

    API Documentation to interact with

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class StepExecutionResult(BaseModel):
    """
    StepExecutionResult
    """ # noqa: E501
    success: StrictBool = Field(description="Whether the step execution was successful")
    message: StrictStr = Field(description="A message describing the result")
    data: Optional[Any] = Field(default=None, description="The step execution result data (workflow format)")
    error: Optional[StrictStr] = None
    execution_time_ms: Optional[StrictInt] = None
    ui: Optional[Dict[str, Any]] = None
    __properties: ClassVar[List[str]] = ["success", "message", "data", "error", "execution_time_ms", "ui"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StepExecutionResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict['data'] = self.data.to_dict()
        # set to None if data (nullable) is None
        # and model_fields_set contains the field
        if self.data is None and "data" in self.model_fields_set:
            _dict['data'] = None

        # set to None if error (nullable) is None
        # and model_fields_set contains the field
        if self.error is None and "error" in self.model_fields_set:
            _dict['error'] = None

        # set to None if execution_time_ms (nullable) is None
        # and model_fields_set contains the field
        if self.execution_time_ms is None and "execution_time_ms" in self.model_fields_set:
            _dict['execution_time_ms'] = None

        # set to None if ui (nullable) is None
        # and model_fields_set contains the field
        if self.ui is None and "ui" in self.model_fields_set:
            _dict['ui'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StepExecutionResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "success": obj.get("success"),
            "message": obj.get("message"),
            "data": AnyOf.from_dict(obj["data"]) if obj.get("data") is not None else None,
            "error": obj.get("error"),
            "execution_time_ms": obj.get("execution_time_ms"),
            "ui": obj.get("ui")
        })
        return _obj


