# coding: utf-8

"""
    API Docs

    API Documentation to interact with

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from odin_sdk.models.template_field import TemplateField
from typing import Optional, Set
from typing_extensions import Self

class TemplatePreview(BaseModel):
    """
    TemplatePreview
    """ # noqa: E501
    template_id: StrictStr
    title: StrictStr
    description: StrictStr
    fields_count: StrictInt
    preview_fields: Optional[List[TemplateField]] = None
    category: StrictStr
    __properties: ClassVar[List[str]] = ["template_id", "title", "description", "fields_count", "preview_fields", "category"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TemplatePreview from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in preview_fields (list)
        _items = []
        if self.preview_fields:
            for _item_preview_fields in self.preview_fields:
                if _item_preview_fields:
                    _items.append(_item_preview_fields.to_dict())
            _dict['preview_fields'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TemplatePreview from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "template_id": obj.get("template_id"),
            "title": obj.get("title"),
            "description": obj.get("description"),
            "fields_count": obj.get("fields_count"),
            "preview_fields": [TemplateField.from_dict(_item) for _item in obj["preview_fields"]] if obj.get("preview_fields") is not None else None,
            "category": obj.get("category")
        })
        return _obj


