# coding: utf-8

"""
    API Docs

    API Documentation to interact with

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from odin_sdk.models.custom_chatbot import CustomChatbot
from typing import Optional, Set
from typing_extensions import Self

class UpdateProjectRequest(BaseModel):
    """
    UpdateProjectRequest
    """ # noqa: E501
    project_id: StrictStr
    name: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    model_name: Optional[StrictStr] = None
    enrich_question: Optional[StrictBool] = None
    enrich_sources: Optional[StrictBool] = None
    description: Optional[StrictStr] = None
    test_info: Optional[Dict[str, Any]] = None
    is_public: Optional[StrictBool] = None
    no_context_answer: Optional[StrictStr] = None
    only_answer_with_context: Optional[StrictBool] = None
    custom_chatbot: Optional[CustomChatbot] = None
    use_textract: Optional[StrictBool] = None
    mask_pii: Optional[StrictBool] = None
    inline_citations: Optional[StrictBool] = None
    data_extraction_method: Optional[StrictStr] = None
    teamsbot_upload_method: Optional[StrictStr] = None
    teamsbot_static_message_footer: Optional[StrictStr] = None
    teamsbot_show_feedback_buttons: Optional[StrictBool] = None
    teamsbot_show_kb_search_message: Optional[StrictBool] = None
    teamsbot_show_message_sources: Optional[StrictBool] = None
    enable_temporary_message_retention: Optional[StrictBool] = None
    temporary_message_retention_duration: Optional[StrictInt] = None
    docx_extraction_method: Optional[StrictStr] = None
    shared_to_team: Optional[StrictBool] = None
    team_default_role: Optional[StrictStr] = None
    enable_automator_v2: Optional[StrictBool] = None
    team_id: Optional[StrictStr] = None
    custom_agent: Optional[StrictStr] = None
    custom_agent_name: Optional[StrictStr] = None
    transcription_provider_key: Optional[StrictStr] = None
    transcription_model_key: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["project_id", "name", "type", "model_name", "enrich_question", "enrich_sources", "description", "test_info", "is_public", "no_context_answer", "only_answer_with_context", "custom_chatbot", "use_textract", "mask_pii", "inline_citations", "data_extraction_method", "teamsbot_upload_method", "teamsbot_static_message_footer", "teamsbot_show_feedback_buttons", "teamsbot_show_kb_search_message", "teamsbot_show_message_sources", "enable_temporary_message_retention", "temporary_message_retention_duration", "docx_extraction_method", "shared_to_team", "team_default_role", "enable_automator_v2", "team_id", "custom_agent", "custom_agent_name", "transcription_provider_key", "transcription_model_key"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateProjectRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of custom_chatbot
        if self.custom_chatbot:
            _dict['custom_chatbot'] = self.custom_chatbot.to_dict()
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if model_name (nullable) is None
        # and model_fields_set contains the field
        if self.model_name is None and "model_name" in self.model_fields_set:
            _dict['model_name'] = None

        # set to None if enrich_question (nullable) is None
        # and model_fields_set contains the field
        if self.enrich_question is None and "enrich_question" in self.model_fields_set:
            _dict['enrich_question'] = None

        # set to None if enrich_sources (nullable) is None
        # and model_fields_set contains the field
        if self.enrich_sources is None and "enrich_sources" in self.model_fields_set:
            _dict['enrich_sources'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if test_info (nullable) is None
        # and model_fields_set contains the field
        if self.test_info is None and "test_info" in self.model_fields_set:
            _dict['test_info'] = None

        # set to None if is_public (nullable) is None
        # and model_fields_set contains the field
        if self.is_public is None and "is_public" in self.model_fields_set:
            _dict['is_public'] = None

        # set to None if no_context_answer (nullable) is None
        # and model_fields_set contains the field
        if self.no_context_answer is None and "no_context_answer" in self.model_fields_set:
            _dict['no_context_answer'] = None

        # set to None if only_answer_with_context (nullable) is None
        # and model_fields_set contains the field
        if self.only_answer_with_context is None and "only_answer_with_context" in self.model_fields_set:
            _dict['only_answer_with_context'] = None

        # set to None if custom_chatbot (nullable) is None
        # and model_fields_set contains the field
        if self.custom_chatbot is None and "custom_chatbot" in self.model_fields_set:
            _dict['custom_chatbot'] = None

        # set to None if use_textract (nullable) is None
        # and model_fields_set contains the field
        if self.use_textract is None and "use_textract" in self.model_fields_set:
            _dict['use_textract'] = None

        # set to None if mask_pii (nullable) is None
        # and model_fields_set contains the field
        if self.mask_pii is None and "mask_pii" in self.model_fields_set:
            _dict['mask_pii'] = None

        # set to None if inline_citations (nullable) is None
        # and model_fields_set contains the field
        if self.inline_citations is None and "inline_citations" in self.model_fields_set:
            _dict['inline_citations'] = None

        # set to None if data_extraction_method (nullable) is None
        # and model_fields_set contains the field
        if self.data_extraction_method is None and "data_extraction_method" in self.model_fields_set:
            _dict['data_extraction_method'] = None

        # set to None if teamsbot_upload_method (nullable) is None
        # and model_fields_set contains the field
        if self.teamsbot_upload_method is None and "teamsbot_upload_method" in self.model_fields_set:
            _dict['teamsbot_upload_method'] = None

        # set to None if teamsbot_static_message_footer (nullable) is None
        # and model_fields_set contains the field
        if self.teamsbot_static_message_footer is None and "teamsbot_static_message_footer" in self.model_fields_set:
            _dict['teamsbot_static_message_footer'] = None

        # set to None if teamsbot_show_feedback_buttons (nullable) is None
        # and model_fields_set contains the field
        if self.teamsbot_show_feedback_buttons is None and "teamsbot_show_feedback_buttons" in self.model_fields_set:
            _dict['teamsbot_show_feedback_buttons'] = None

        # set to None if teamsbot_show_kb_search_message (nullable) is None
        # and model_fields_set contains the field
        if self.teamsbot_show_kb_search_message is None and "teamsbot_show_kb_search_message" in self.model_fields_set:
            _dict['teamsbot_show_kb_search_message'] = None

        # set to None if teamsbot_show_message_sources (nullable) is None
        # and model_fields_set contains the field
        if self.teamsbot_show_message_sources is None and "teamsbot_show_message_sources" in self.model_fields_set:
            _dict['teamsbot_show_message_sources'] = None

        # set to None if enable_temporary_message_retention (nullable) is None
        # and model_fields_set contains the field
        if self.enable_temporary_message_retention is None and "enable_temporary_message_retention" in self.model_fields_set:
            _dict['enable_temporary_message_retention'] = None

        # set to None if temporary_message_retention_duration (nullable) is None
        # and model_fields_set contains the field
        if self.temporary_message_retention_duration is None and "temporary_message_retention_duration" in self.model_fields_set:
            _dict['temporary_message_retention_duration'] = None

        # set to None if docx_extraction_method (nullable) is None
        # and model_fields_set contains the field
        if self.docx_extraction_method is None and "docx_extraction_method" in self.model_fields_set:
            _dict['docx_extraction_method'] = None

        # set to None if shared_to_team (nullable) is None
        # and model_fields_set contains the field
        if self.shared_to_team is None and "shared_to_team" in self.model_fields_set:
            _dict['shared_to_team'] = None

        # set to None if team_default_role (nullable) is None
        # and model_fields_set contains the field
        if self.team_default_role is None and "team_default_role" in self.model_fields_set:
            _dict['team_default_role'] = None

        # set to None if enable_automator_v2 (nullable) is None
        # and model_fields_set contains the field
        if self.enable_automator_v2 is None and "enable_automator_v2" in self.model_fields_set:
            _dict['enable_automator_v2'] = None

        # set to None if team_id (nullable) is None
        # and model_fields_set contains the field
        if self.team_id is None and "team_id" in self.model_fields_set:
            _dict['team_id'] = None

        # set to None if custom_agent (nullable) is None
        # and model_fields_set contains the field
        if self.custom_agent is None and "custom_agent" in self.model_fields_set:
            _dict['custom_agent'] = None

        # set to None if custom_agent_name (nullable) is None
        # and model_fields_set contains the field
        if self.custom_agent_name is None and "custom_agent_name" in self.model_fields_set:
            _dict['custom_agent_name'] = None

        # set to None if transcription_provider_key (nullable) is None
        # and model_fields_set contains the field
        if self.transcription_provider_key is None and "transcription_provider_key" in self.model_fields_set:
            _dict['transcription_provider_key'] = None

        # set to None if transcription_model_key (nullable) is None
        # and model_fields_set contains the field
        if self.transcription_model_key is None and "transcription_model_key" in self.model_fields_set:
            _dict['transcription_model_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateProjectRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "project_id": obj.get("project_id"),
            "name": obj.get("name"),
            "type": obj.get("type"),
            "model_name": obj.get("model_name"),
            "enrich_question": obj.get("enrich_question"),
            "enrich_sources": obj.get("enrich_sources"),
            "description": obj.get("description"),
            "test_info": obj.get("test_info"),
            "is_public": obj.get("is_public"),
            "no_context_answer": obj.get("no_context_answer"),
            "only_answer_with_context": obj.get("only_answer_with_context"),
            "custom_chatbot": CustomChatbot.from_dict(obj["custom_chatbot"]) if obj.get("custom_chatbot") is not None else None,
            "use_textract": obj.get("use_textract"),
            "mask_pii": obj.get("mask_pii"),
            "inline_citations": obj.get("inline_citations"),
            "data_extraction_method": obj.get("data_extraction_method"),
            "teamsbot_upload_method": obj.get("teamsbot_upload_method"),
            "teamsbot_static_message_footer": obj.get("teamsbot_static_message_footer"),
            "teamsbot_show_feedback_buttons": obj.get("teamsbot_show_feedback_buttons"),
            "teamsbot_show_kb_search_message": obj.get("teamsbot_show_kb_search_message"),
            "teamsbot_show_message_sources": obj.get("teamsbot_show_message_sources"),
            "enable_temporary_message_retention": obj.get("enable_temporary_message_retention"),
            "temporary_message_retention_duration": obj.get("temporary_message_retention_duration"),
            "docx_extraction_method": obj.get("docx_extraction_method"),
            "shared_to_team": obj.get("shared_to_team"),
            "team_default_role": obj.get("team_default_role"),
            "enable_automator_v2": obj.get("enable_automator_v2"),
            "team_id": obj.get("team_id"),
            "custom_agent": obj.get("custom_agent"),
            "custom_agent_name": obj.get("custom_agent_name"),
            "transcription_provider_key": obj.get("transcription_provider_key"),
            "transcription_model_key": obj.get("transcription_model_key")
        })
        return _obj


