# coding: utf-8

"""
    API Docs

    API Documentation to interact with

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from odin_sdk.models.execution_mode import ExecutionMode
from odin_sdk.models.execution_trigger_mode import ExecutionTriggerMode
from typing import Optional, Set
from typing_extensions import Self

class WorkflowExecutionRequest(BaseModel):
    """
    WorkflowExecutionRequest
    """ # noqa: E501
    project_id: StrictStr = Field(description="The project ID")
    tool_id: StrictStr = Field(description="The tool ID")
    tool_config: Optional[Dict[str, Any]] = None
    inputs: Optional[Dict[str, Any]] = Field(default=None, description="Runtime inputs")
    execution_mode: Optional[ExecutionMode] = Field(default=None, description="execution mode: 'workflow' or 'debug'")
    mode: Optional[ExecutionTriggerMode] = Field(default=None, description="Execution trigger mode: 'manual', 'scheduled', 'email', or 'file_upload'")
    push_ref: Optional[StrictStr] = None
    chat_id: Optional[StrictStr] = None
    message_id: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["project_id", "tool_id", "tool_config", "inputs", "execution_mode", "mode", "push_ref", "chat_id", "message_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowExecutionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if tool_config (nullable) is None
        # and model_fields_set contains the field
        if self.tool_config is None and "tool_config" in self.model_fields_set:
            _dict['tool_config'] = None

        # set to None if push_ref (nullable) is None
        # and model_fields_set contains the field
        if self.push_ref is None and "push_ref" in self.model_fields_set:
            _dict['push_ref'] = None

        # set to None if chat_id (nullable) is None
        # and model_fields_set contains the field
        if self.chat_id is None and "chat_id" in self.model_fields_set:
            _dict['chat_id'] = None

        # set to None if message_id (nullable) is None
        # and model_fields_set contains the field
        if self.message_id is None and "message_id" in self.model_fields_set:
            _dict['message_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowExecutionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "project_id": obj.get("project_id"),
            "tool_id": obj.get("tool_id"),
            "tool_config": obj.get("tool_config"),
            "inputs": obj.get("inputs"),
            "execution_mode": obj.get("execution_mode"),
            "mode": obj.get("mode"),
            "push_ref": obj.get("push_ref"),
            "chat_id": obj.get("chat_id"),
            "message_id": obj.get("message_id")
        })
        return _obj


