"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Redis = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const service_deployment_1 = require("./service-deployment");
class Redis extends constructs_1.Construct {
    constructor(scope, id, options = {}) {
        super(scope, id);
        const primary = new service_deployment_1.ServiceDeployment(this, 'primary', {
            image: 'registry.k8s.io/redis:e2e',
            containerPort: 6379,
            externalPort: 6379,
            containerName: 'primary',
            env: { GET_HOSTS_FROM: 'dns' },
            labels: {
                app: 'redis',
                role: 'primary',
                ...options.labels,
            },
        });
        this.primaryHost = primary.host;
        const replicas = options.replicas ?? 2;
        if (replicas > 0) {
            const replica = new service_deployment_1.ServiceDeployment(this, 'replica', {
                image: 'gcr.io/google_samples/gb-redisslave:v1',
                containerName: 'replica',
                containerPort: 6379,
                externalPort: 6379,
                env: { GET_HOSTS_FROM: 'env', REDIS_MASTER_SERVICE_HOST: this.primaryHost },
                replicas: replicas,
                labels: {
                    app: 'redis',
                    role: 'replica',
                    ...options.labels,
                },
            });
            this.replicaHost = replica.host;
        }
        else {
            // if we have no slave, then use the same host as the primary
            this.replicaHost = primary.host;
        }
    }
}
exports.Redis = Redis;
_a = JSII_RTTI_SYMBOL_1;
Redis[_a] = { fqn: "cdk8s-redis.Redis", version: "0.1.852" };
//# sourceMappingURL=data:application/json;base64,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