"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecureBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const s3 = require("aws-cdk-lib/aws-s3");
class SecureBucket extends s3.Bucket {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            removalPolicy: cdk.RemovalPolicy.RETAIN,
            encryption: (() => {
                if (!props?.encryption) {
                    return s3.BucketEncryption.KMS_MANAGED;
                }
                else {
                    if (props.encryption === s3.BucketEncryption.UNENCRYPTED) {
                        throw new Error('DeplicatedArgumentFoundError: BucketEncryption.UNENCRYPTED is deplicated, Bucket cano not be unencrypted.');
                    }
                }
                return props.encryption;
            })(),
            accessControl: (() => {
                if (!props?.accessControl) {
                    return s3.BucketAccessControl.PRIVATE;
                }
                return props.accessControl;
            })(),
            eventBridgeEnabled: undefined,
            publicReadAccess: false,
            blockPublicAccess: s3.BlockPublicAccess.BLOCK_ALL,
            enforceSSL: true,
            versioned: props?.versioned !== undefined ? props.versioned : true,
            objectOwnership: (() => {
                if (props?.objectOwnership) {
                    return props.objectOwnership;
                }
                return s3.ObjectOwnership.BUCKET_OWNER_ENFORCED;
            })(),
        });
        // Get CfnBucket
        const cfnBucket = this.node.defaultChild;
        if (props?.eventBridgeEnabled === true) {
            cfnBucket.addPropertyOverride('NotificationConfiguration.EventBridgeConfiguration.EventBridgeEnabled', true);
        }
    }
}
exports.SecureBucket = SecureBucket;
_a = JSII_RTTI_SYMBOL_1;
SecureBucket[_a] = { fqn: "@gammarers/aws-secure-bucket.SecureBucket", version: "2.0.5" };
//# sourceMappingURL=data:application/json;base64,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