"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// tests for the L1 escape hatches (overrides). those are in the IAM module
// because we want to verify them end-to-end, as a complement to the unit
// tests in the @aws-cdk/core module
require("@aws-cdk/assert/jest");
const core_1 = require("@aws-cdk/core");
const iam = require("../lib");
/* eslint-disable quote-props */
describe('IAM escape hatches', () => {
    test('addPropertyOverride should allow overriding supported properties', () => {
        const stack = new core_1.Stack();
        const user = new iam.User(stack, 'user', {
            userName: 'MyUserName',
        });
        const cfn = user.node.findChild('Resource');
        cfn.addPropertyOverride('UserName', 'OverriddenUserName');
        expect(stack).toMatchTemplate({
            'Resources': {
                'user2C2B57AE': {
                    'Type': 'AWS::IAM::User',
                    'Properties': {
                        'UserName': 'OverriddenUserName',
                    },
                },
            },
        });
    });
    test('addPropertyOverrides should allow specifying arbitrary properties', () => {
        // GIVEN
        const stack = new core_1.Stack();
        const user = new iam.User(stack, 'user', { userName: 'MyUserName' });
        const cfn = user.node.findChild('Resource');
        // WHEN
        cfn.addPropertyOverride('Hello.World', 'Boom');
        // THEN
        expect(stack).toMatchTemplate({
            'Resources': {
                'user2C2B57AE': {
                    'Type': 'AWS::IAM::User',
                    'Properties': {
                        'UserName': 'MyUserName',
                        'Hello': {
                            'World': 'Boom',
                        },
                    },
                },
            },
        });
    });
    test('addOverride should allow overriding properties', () => {
        // GIVEN
        const stack = new core_1.Stack();
        const user = new iam.User(stack, 'user', { userName: 'MyUserName' });
        const cfn = user.node.findChild('Resource');
        cfn.cfnOptions.updatePolicy = { useOnlineResharding: true };
        // WHEN
        cfn.addOverride('Properties.Hello.World', 'Bam');
        cfn.addOverride('Properties.UserName', 'HA!');
        cfn.addOverride('Joob.Jab', 'Jib');
        cfn.addOverride('Joob.Jab', 'Jib');
        cfn.addOverride('UpdatePolicy.UseOnlineResharding.Type', 'None');
        // THEN
        expect(stack).toMatchTemplate({
            'Resources': {
                'user2C2B57AE': {
                    'Type': 'AWS::IAM::User',
                    'Properties': {
                        'UserName': 'HA!',
                        'Hello': {
                            'World': 'Bam',
                        },
                    },
                    'Joob': {
                        'Jab': 'Jib',
                    },
                    'UpdatePolicy': {
                        'UseOnlineResharding': {
                            'Type': 'None',
                        },
                    },
                },
            },
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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