"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ pragma:ignore-assets
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
class MyStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id);
        const tagName = new core_1.CfnParameter(this, 'PrincipalTag', { default: 'developer' });
        const stringEquals = new core_1.CfnJson(this, 'PrincipalTagCondition', {
            value: {
                [`aws:PrincipalTag/${tagName.valueAsString}`]: 'true',
            },
        });
        const principal = new lib_1.AccountRootPrincipal().withConditions({
            StringEquals: stringEquals,
        });
        new lib_1.Role(this, 'MyRole', { assumedBy: principal });
    }
}
const app = new core_1.App();
new MyStack(app, 'test-condition-with-ref');
app.synth();
//# sourceMappingURL=data:application/json;base64,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