"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ pragma:ignore-assets
const core_1 = require("@aws-cdk/core");
const iam = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'oidc-provider-integ-test');
new iam.OpenIdConnectProvider(stack, 'NoClientsNoThumbprint', {
    url: 'https://oidc.eks.us-east-1.amazonaws.com/id/test2',
});
new iam.OpenIdConnectProvider(stack, 'Clients', {
    url: 'https://oidc.eks.us-east-1.amazonaws.com/id/test3',
    clientIds: ['foo', 'bar'],
});
new iam.OpenIdConnectProvider(stack, 'Thumbprints', {
    url: 'https://oidc.eks.us-east-1.amazonaws.com/id/test4',
    thumbprints: [
        'aa00aa1122aa00aa1122aa00aa1122aa00aa1122',
        'aa00aa1122aa00aa1122aa00aa1122aa00aa1111',
    ],
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcub2lkYy1wcm92aWRlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLm9pZGMtcHJvdmlkZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxtQ0FBbUM7QUFDbkMsd0NBQTJDO0FBQzNDLDhCQUE4QjtBQUU5QixNQUFNLEdBQUcsR0FBRyxJQUFJLFVBQUcsRUFBRSxDQUFDO0FBQ3RCLE1BQU0sS0FBSyxHQUFHLElBQUksWUFBSyxDQUFDLEdBQUcsRUFBRSwwQkFBMEIsQ0FBQyxDQUFDO0FBRXpELElBQUksR0FBRyxDQUFDLHFCQUFxQixDQUFDLEtBQUssRUFBRSx1QkFBdUIsRUFBRTtJQUM1RCxHQUFHLEVBQUUsbURBQW1EO0NBQ3pELENBQUMsQ0FBQztBQUVILElBQUksR0FBRyxDQUFDLHFCQUFxQixDQUFDLEtBQUssRUFBRSxTQUFTLEVBQUU7SUFDOUMsR0FBRyxFQUFFLG1EQUFtRDtJQUN4RCxTQUFTLEVBQUUsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDO0NBQzFCLENBQUMsQ0FBQztBQUVILElBQUksR0FBRyxDQUFDLHFCQUFxQixDQUFDLEtBQUssRUFBRSxhQUFhLEVBQUU7SUFDbEQsR0FBRyxFQUFFLG1EQUFtRDtJQUN4RCxXQUFXLEVBQUU7UUFDWCwwQ0FBMEM7UUFDMUMsMENBQTBDO0tBQzNDO0NBQ0YsQ0FBQyxDQUFDO0FBRUgsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8vICFjZGstaW50ZWcgcHJhZ21hOmlnbm9yZS1hc3NldHNcbmltcG9ydCB7IEFwcCwgU3RhY2sgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCAqIGFzIGlhbSBmcm9tICcuLi9saWInO1xuXG5jb25zdCBhcHAgPSBuZXcgQXBwKCk7XG5jb25zdCBzdGFjayA9IG5ldyBTdGFjayhhcHAsICdvaWRjLXByb3ZpZGVyLWludGVnLXRlc3QnKTtcblxubmV3IGlhbS5PcGVuSWRDb25uZWN0UHJvdmlkZXIoc3RhY2ssICdOb0NsaWVudHNOb1RodW1icHJpbnQnLCB7XG4gIHVybDogJ2h0dHBzOi8vb2lkYy5la3MudXMtZWFzdC0xLmFtYXpvbmF3cy5jb20vaWQvdGVzdDInLFxufSk7XG5cbm5ldyBpYW0uT3BlbklkQ29ubmVjdFByb3ZpZGVyKHN0YWNrLCAnQ2xpZW50cycsIHtcbiAgdXJsOiAnaHR0cHM6Ly9vaWRjLmVrcy51cy1lYXN0LTEuYW1hem9uYXdzLmNvbS9pZC90ZXN0MycsXG4gIGNsaWVudElkczogWydmb28nLCAnYmFyJ10sXG59KTtcblxubmV3IGlhbS5PcGVuSWRDb25uZWN0UHJvdmlkZXIoc3RhY2ssICdUaHVtYnByaW50cycsIHtcbiAgdXJsOiAnaHR0cHM6Ly9vaWRjLmVrcy51cy1lYXN0LTEuYW1hem9uYXdzLmNvbS9pZC90ZXN0NCcsXG4gIHRodW1icHJpbnRzOiBbXG4gICAgJ2FhMDBhYTExMjJhYTAwYWExMTIyYWEwMGFhMTEyMmFhMDBhYTExMjInLFxuICAgICdhYTAwYWExMTIyYWEwMGFhMTEyMmFhMDBhYTExMjJhYTAwYWExMTExJyxcbiAgXSxcbn0pO1xuXG5hcHAuc3ludGgoKTtcbiJdfQ==