"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-iam-role-1');
const role = new lib_1.Role(stack, 'TestRole', {
    assumedBy: new lib_1.ServicePrincipal('sqs.amazonaws.com'),
});
role.addToPolicy(new lib_1.PolicyStatement({ resources: ['*'], actions: ['sqs:SendMessage'] }));
const policy = new lib_1.Policy(stack, 'HelloPolicy', { policyName: 'Default' });
policy.addStatements(new lib_1.PolicyStatement({ actions: ['ec2:*'], resources: ['*'] }));
policy.attachToRole(role);
// Role with an external ID
new lib_1.Role(stack, 'TestRole2', {
    assumedBy: new lib_1.AccountRootPrincipal(),
    externalIds: ['supply-me'],
});
// Role with an org
new lib_1.Role(stack, 'TestRole3', {
    assumedBy: new lib_1.OrganizationPrincipal('o-1234'),
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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