# Generated by Django 5.2.6 on 2025-09-27 20:31

import django.db.models.deletion
import netbox.models.deletion
import taggit.managers
import utilities.json
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    operations = [
        migrations.CreateModel(
            name='Service',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('type', models.CharField()),
                ('service_id', models.CharField()),
                ('asns', models.ManyToManyField(to='ipam.asn')),
                ('cables', models.ManyToManyField(to='dcim.cable')),
                ('devices', models.ManyToManyField(to='dcim.device')),
                ('interfaces', models.ManyToManyField(to='dcim.interface')),
                ('l2vpns', models.ManyToManyField(to='vpn.l2vpn')),
                ('prefixes', models.ManyToManyField(to='ipam.prefix')),
                ('route_targets', models.ManyToManyField(to='ipam.routetarget')),
                ('tags', taggit.managers.TaggableManager(through='taggit.TaggedItem', to='taggit.Tag')),
                ('tenant', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='tenancy.tenant')),
                ('tunnels', models.ManyToManyField(to='vpn.tunnel')),
                ('virtual_machines', models.ManyToManyField(to='virtualization.virtualmachine')),
                ('vlans', models.ManyToManyField(to='ipam.vlan')),
                ('vrf', models.ManyToManyField(to='ipam.vrf')),
            ],
            options={
                'abstract': False,
            },
            bases=(netbox.models.deletion.DeleteMixin, models.Model),
        ),
    ]
