from django.urls import path, include
from utilities.urls import get_model_urls
from .views import (
    ServiceView,
    ServiceListView,
    ServiceAddView,
    ServiceEditView,
    ServiceDeleteView,
    ServiceRelatedDevicesView,
    ServiceRelatedInterfacesView,
    ServiceRelatedCablesView,
    ServiceRelatedVLANsView,
    ServiceRelatedPrefixesView,
    ServiceRelatedVRFsView,
    ServiceRelatedASNsView,
    ServiceRelatedRouteTargetsView,
    ServiceRelatedL2VPNsView,
    ServiceRelatedTunnelsView,
    ServiceRelatedVirtualMachinesView,
)

urlpatterns = [
    path('',
         include(get_model_urls('netbox_services', 'service', detail=False))
         ),
    path('<int:pk>/',
         include(get_model_urls('netbox_services', 'service', detail=True))
         ),
    path('<int:pk>/relate/devices/',
         ServiceRelatedDevicesView.as_view(),
         name='relate_devices',
         ),
    path('<int:pk>/relate/interfaces/',
         ServiceRelatedInterfacesView.as_view(),
         name='relate_interfaces',
         ),
    path('<int:pk>/relate/cables/',
         ServiceRelatedCablesView.as_view(),
         name='relate_cables',
         ),
    path('<int:pk>/relate/vlans/',
         ServiceRelatedVLANsView.as_view(),
         name='relate_vlans',
         ),
    path('<int:pk>/relate/prefixes/',
         ServiceRelatedPrefixesView.as_view(),
         name='relate_prefixes',
         ),
    path('<int:pk>/relate/vrfs/',
         ServiceRelatedVRFsView.as_view(),
         name='relate_vrfs',
         ),
    path('<int:pk>/relate/asns/',
         ServiceRelatedASNsView.as_view(),
         name='relate_asns',
         ),
    path('<int:pk>/relate/route_targets/',
         ServiceRelatedRouteTargetsView.as_view(),
         name='relate_route_targets',
         ),
    path('<int:pk>/relate/l2vpns/',
         ServiceRelatedL2VPNsView.as_view(),
         name='relate_l2vpns',
         ),
    path('<int:pk>/relate/tunnels/',
         ServiceRelatedTunnelsView.as_view(),
         name='relate_tunnels',
         ),
    path('<int:pk>/relate/virtual_machines/',
         ServiceRelatedVirtualMachinesView.as_view(),
         name='relate_virtual_machines',
         ),
]
