# Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
# SPDX-License-Identifier: Apache-2.0

import logging

logger = logging.getLogger(__name__)


def log_run_start(verbose: bool, num_tests: int, num_threads: int):
    logger.info(f"Starting {num_tests} test(s)")
    if verbose:
        logger.info(f"Number of threads: {num_threads}")


def log_run_end(
    verbose: bool,
    results: dict,
    num_tests: int,
    pass_count: int,
    fail_count: int,
    elapsed_time: float,
    evaluator_input_token_count: int,
    evaluator_output_token_count: int,
):
    if fail_count:
        logger.error(f"[red]{pass_count} passed, {fail_count} failed.")
    else:
        logger.info(f"[green]{num_tests} passed.")

    logger.info(f"Completed in {elapsed_time} seconds.")

    if verbose:
        for _, result in results.items():
            if result.passed:
                logger.info(f"[bold green]{result.test_name}...PASSED")
            else:
                logger.error(f"[bold red]{result.test_name}...FAILED")
        logger.info(
            f"Input tokens processed by evaluator: {evaluator_input_token_count}"
        )
        logger.info(
            f"Output tokens generated by evaluator: {evaluator_output_token_count}"
        )
