import os

from django.conf import settings
from django.utils.translation import gettext_lazy as _

DEFAULT_GRAPHVIZ_DOT_PATH = '/usr/bin/dot'
DEFAULT_HTTP_ACTION_TIMEOUT = 4  # 4 seconds.
DEFAULT_WORKFLOWS_IMAGE_CACHE_MAXIMUM_SIZE = 50 * 2 ** 20  # 50 Megabytes.
DEFAULT_WORKFLOWS_IMAGE_CACHE_STORAGE_BACKEND = 'django.core.files.storage.FileSystemStorage'
DEFAULT_WORKFLOWS_IMAGE_CACHE_STORAGE_BACKEND_ARGUMENTS = {
    'location': os.path.join(settings.MEDIA_ROOT, 'workflows')
}

DEFAULT_WORKFLOWS_WORKFLOW_STATE_ESCALATION_CHECK_INTERVAL = 60 * 5  # 5 minutes.

FIELD_TYPE_CHOICE_CHAR = 1
FIELD_TYPE_CHOICE_INTEGER = 2
FIELD_TYPE_CHOICES = (
    (FIELD_TYPE_CHOICE_CHAR, _(message='Character')),
    (FIELD_TYPE_CHOICE_INTEGER, _(message='Number (Integer)'))
)
FIELD_TYPE_MAPPING = {
    FIELD_TYPE_CHOICE_CHAR: 'django.forms.CharField',
    FIELD_TYPE_CHOICE_INTEGER: 'django.forms.IntegerField'
}

GRAPHVIZ_COLOR_STATE_FILL = '#eeeeee'
GRAPHVIZ_ID_STATE = 'state'
GRAPHVIZ_ID_STATE_ACTION = 'stateaction'
GRAPHVIZ_RANKDIR = 'LR'
GRAPHVIZ_RANKSEP = '1.1'
GRAPHVIZ_SHAPE_CIRCLE = 'circle'
GRAPHVIZ_SHAPE_DOUBLECIRCLE = 'doublecircle'
GRAPHVIZ_SPLINES = 'polyline'
GRAPHVIZ_STYLE_FILLED = 'filled'
GRAPHVIZ_SYMBOL_CONDITIONAL = '(&fnof;)'
GRAPHVIZ_SYMBOL_TIME = '(&tau;)'
GRAPHVIZ_SYMBOL_TRIGGER = '(!)'

ERROR_LOG_DOMAIN_NAME = 'workflows'

STORAGE_NAME_WORKFLOW_CACHE = 'document_states__workflowimagecache'

WIDGET_CLASS_TEXTAREA = 1
WIDGET_CLASS_CHOICES = (
    (WIDGET_CLASS_TEXTAREA, _(message='Text area')),
)
WIDGET_CLASS_MAPPING = {
    WIDGET_CLASS_TEXTAREA: 'django.forms.widgets.Textarea'
}

WORKFLOW_ACTION_ON_ENTRY = 1
WORKFLOW_ACTION_ON_EXIT = 2
WORKFLOW_ACTION_WHEN_CHOICES = (
    (WORKFLOW_ACTION_ON_ENTRY, _(message='On entry')),
    (WORKFLOW_ACTION_ON_EXIT, _(message='On exit'))
)

WORKFLOW_ACTION_HTTP_REQUEST_DEFAULT_RESPONSE_STORE_NAME = 'last_http_request'
