# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ResourceArgs', 'Resource']

@pulumi.input_type
class ResourceArgs:
    def __init__(__self__, *,
                 sample_attribute: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Resource resource.
        :param pulumi.Input[builtins.str] sample_attribute: Sample attribute.
        """
        if sample_attribute is not None:
            pulumi.set(__self__, "sample_attribute", sample_attribute)

    @property
    @pulumi.getter(name="sampleAttribute")
    def sample_attribute(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sample attribute.
        """
        return pulumi.get(self, "sample_attribute")

    @sample_attribute.setter
    def sample_attribute(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sample_attribute", value)


@pulumi.input_type
class _ResourceState:
    def __init__(__self__, *,
                 sample_attribute: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Resource resources.
        :param pulumi.Input[builtins.str] sample_attribute: Sample attribute.
        """
        if sample_attribute is not None:
            pulumi.set(__self__, "sample_attribute", sample_attribute)

    @property
    @pulumi.getter(name="sampleAttribute")
    def sample_attribute(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sample attribute.
        """
        return pulumi.get(self, "sample_attribute")

    @sample_attribute.setter
    def sample_attribute(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sample_attribute", value)


@pulumi.type_token("xyz:index/resource:Resource")
class Resource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 sample_attribute: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a Resource resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] sample_attribute: Sample attribute.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ResourceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Resource resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ResourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 sample_attribute: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceArgs.__new__(ResourceArgs)

            __props__.__dict__["sample_attribute"] = sample_attribute
        super(Resource, __self__).__init__(
            'xyz:index/resource:Resource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            sample_attribute: Optional[pulumi.Input[builtins.str]] = None) -> 'Resource':
        """
        Get an existing Resource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] sample_attribute: Sample attribute.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourceState.__new__(_ResourceState)

        __props__.__dict__["sample_attribute"] = sample_attribute
        return Resource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="sampleAttribute")
    def sample_attribute(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Sample attribute.
        """
        return pulumi.get(self, "sample_attribute")

